<?php
/* ====================
[BEGIN_COT_EXT]
Hooks=parser.last
[END_COT_EXT]
==================== */

/**
 * Adds rel="nofollow" to extrnal links
 *
 * @package nofollow
 * @version 1.1
 * @author Trustmaster
 * @copyright Copyright (c) Vladimir Sibirov 2011
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL');

if (!function_exists('nofollow_replace'))
{
	/**
	 * Replaces links with nofollow links if necessary
	 * @param array $m preg_replace_callback matches
	 * @return string
	 */
	function nofollow_replace($m)
	{
		global $sys;
		if (preg_match('`^.+\.'.preg_quote($sys['domain']).'(/.*)?$`i', $m[4]))
		{
			return $m[0];
		}
		else
		{
			$m[5] = (mb_strpos($m[5], 'rel="') === false) ? 'rel="nofollow"'.$m[5] : str_replace('rel="', 'rel="nofollow ', $m[5]);
			return '<a'.$m[1].'href="http'.$m[3].'://'.$m[4].'" '.$m[5].'>';
		}
	}
}

// Replace all external links
$text = preg_replace_callback('`<a(.+?)href=("|\')?http(s)?://([^\s"\'>]+)\2?(.*?)>`i', 'nofollow_replace', $text);

?>
