<?php

/* ====================
[BEGIN_SED_EXTPLUGIN]
Code=browser
Part=main
File=browser
Hooks=standalone
Tags=
Order=10
[END_SED_EXTPLUGIN]
==================== */

/**
 * Browse PFS files
 *
 * @package Cotonti
 * @version 1.0
 * @author Gert Hengeveld
 * @copyright Webmojo
 */

defined('SED_CODE') or die('Wrong URL.');

require_once 'images/icons.php';

	/**
	 * Get readable filesize
	 *
	 * @param int $size Number of bytes
	 * @return string
	 */
	function getFileSize($size)
	{
		if ($size === 0) return "0 bytes";
		if (!$size) return '';
		$units = array ('B', 'KB', 'MB', 'GB', 'TB', 'PB');
		$i = min(floor(log($size, 1024)), count($units)-1);
		$size = $size/pow(1024, $i);
		$decs = max(2 - floor(log10($size)), 0);
		$shift = pow(10, $decs);
		$value = floor($size*$shift)/$shift;
		return (sprintf('%.'.$decs.'f %s', $value, $units[$i+1]));
	}

$folderid = sed_import('folderid', 'G', 'INT');

$t = new XTemplate(sed_skinfile('browser', true));

if(!$folderid)
{
	$t->assign(array(
		'TITLE' => '<a href="'.sed_url('plug', 'e=browser').'">'.$L['browser'].'</a>',
		'FOLDERNAME' => $L['root'],
		'FOLDERDESC' => ''
	));
}
else
{
	$sql = sed_sql_query("SELECT * FROM $db_pfs_folders WHERE pff_id=".(int)$folderid." AND pff_ispublic=1");
	if($res = sed_sql_fetchassoc($sql))
	{
		$t->assign(array(
			'TITLE' => '<a href="'.sed_url('plug', 'e=browser').'">'.$L['browser'].'</a> '.$cfg['separator'].' <a href="'.sed_url('plug', 'e=browser&folderid='.(int)$res['pff_id']).'">'.$res['pff_title'].'</a>',
			'FOLDERNAME' => $res['pff_title'],
			'FOLDERDESC' => $res['pff_desc']
		));
	}
	else
	{
		sed_redirect(sed_url('plug', 'e=browser', '', true));
	}
}

if(!$folderid)
{
	$sql = sed_sql_query("SELECT *, user_name, (SELECT COUNT(*) FROM $db_pfs WHERE pfs_folderid=pff_id) AS count FROM $db_pfs_folders LEFT JOIN $db_users ON pff_userid=user_id WHERE pff_ispublic=1 ORDER BY pff_title");
	while($row = sed_sql_fetchassoc($sql))
	{
		$icon = $row['pff_isgallery'] ? 'gallery' : 'folder';
		$t->assign(array(
			'FOLDER_ID' => $row['pff_id'],
			'FOLDER_OWNER' => $row['user_name'],
			'FOLDER_OWNERID' => $row['pff_userid'],
			'FOLDER_ADDED' => $row['pff_date'],
			'FOLDER_UPDATED' => $row['pff_updated'],
			'FOLDER_TITLE' => $row['pff_title'],
			'FOLDER_DESC' => $row['pff_desc'],
			'FOLDER_ISGALLERY' => $row['pff_isgallery'],
			'FOLDER_COUNT' => $row['count'],
			'FOLDER_URL' => sed_url('plug', 'e=browser&folderid='.$row['pff_id']),
			'FOLDER_ICON' => $cfg['plugin']['browser']['imgpath'].'/'.$icon.'.png'
		));
		$t->parse('MAIN.FOLDERS.FOLDER');
	}
	$numrows = sed_sql_numrows($sql);
	if($numrows > 0)
	{
		$t->assign('FOLDERCOUNT', $numrows);
		$t->parse('MAIN.FOLDERS');
	}
	else
	{
		$t->parse('MAIN.NOFOLDERS');
	}
}

$sql = sed_sql_query("SELECT *, user_name FROM $db_pfs LEFT JOIN $db_users ON pfs_userid=user_id WHERE pfs_folderid=".(int)$folderid." ORDER BY pfs_file");
while($row = sed_sql_fetchassoc($sql))
{
	$icon = is_file($cfg['plugin']['browser']['imgpath'].'/'.$fileicons[$row['pfs_extension']].'.png') ? $fileicons[$row['pfs_extension']] : 'unknown';
	$t->assign(array(
		'FILE_ID' => $row['pfs_id'],
		'FILE_OWNER' => $row['user_name'],
		'FILE_OWNERID' => $row['pfs_userid'],
		'FILE_ADDED' => $row['pfs_date'],
		'FILE_NAME' => $row['pfs_file'],
		'FILE_EXT' => $row['pfs_extension'],
		'FILE_DESC' => $row['pfs_desc'],
		'FILE_SIZE' => getFileSize($row['pfs_size']/1024),
		'FILE_URL' => sed_pfs_path($row['pfs_userid']).$row['pfs_file'],
		'FILE_ICON' => $cfg['plugin']['browser']['imgpath'].'/'.$icon.'.png'
	));
	$t->parse('MAIN.FILES.FILE');
}
$numrows = sed_sql_numrows($sql);
if($numrows > 0)
{
	$t->assign('FILESCOUNT', $numrows);
	$t->parse('MAIN.FILES');
}
else
{
	$t->parse('MAIN.NOFILES');
}

?>