<?php

define(TWITTER_ACCOUNT, $cfg['plugin']['tweetbutton']['twitter_account']);
define(ENABLE_MENTIONS, $cfg['plugin']['tweetbutton']['enable_mentions']);
define(COUNTBOX_LOCATION, $cfg['plugin']['tweetbutton']['countbox_location']);

function buildTweetButton($text, $url='')
{
	global $cfg;

	$text = '?text='.$text;
	$url = ($url) ? '&amp;url='.urlencode($cfg['mainurl'].'/'.$url) : '';
	$mention = (ENABLE_MENTIONS && TWITTER_ACCOUNT) ? '&amp;via='.TWITTER_ACCOUNT : '';
	$countbox = '&amp;count=';
	switch(COUNTBOX_LOCATION)
	{
		case 'Above':
			$countbox .= 'vertical';
		break;
		case 'Right':
			$countbox .= 'horizontal';
		break;
		default:
			$countbox .= 'none';
	}
	return '<a href="http://twitter.com/share'.$text.$url.$mention.$countbox.'" class="twitter-share-button">Tweet</a><script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>';
}

?>