<!-- BEGIN: MAIN -->

<div class="page-header">
    <h1>{PHP.L.datatable_title}</h1>
</div>


<div class="row">

{FILE "{PHP.cfg.themes_dir}/{PHP.usr.theme}/warnings.tpl"}
	  
	<!-- BEGIN: DEFAULT --> 
	
<script type="text/javascript" language="javascript" class="init">

$(document).ready(function() {

	var otable = $('#example').dataTable( {
	<!-- IF {PHP.cfg.plugin.datatable.serverside} -->
		"processing": true,
		"serverSide": true,
		"ajax": {
            "url": "index.php?r=datatable",
            // "type": "POST"
			"type": "GET"
        },
	<!-- ELSE -->
		"ajax": {
            "url": "index.php?r=datatable",
            "type": "GET"
        },	
	<!-- ENDIF -->
	/*
		// custom language breaks filtering!
		"language": {
            "url": "/plugins/datatable/datatables/i18n/English.json"
        },
	*/
		"columns": [
			<!-- BEGIN: LISTCOLS --> 
			{ "data": "{DATATABLE_COLS}" },
			<!-- END: LISTCOLS --> 
			{ "data": null }
		],
		"columnDefs": [ {
            "targets": -1,
            "data": null,
            "defaultContent": '<a class="btn btn-xs btn-primary view_button"><i class="fa fa-search"></i></a> <a class="btn btn-xs btn-warning edit_button"><i class="fa fa-pencil"></i></a> <a class="btn btn-xs btn-danger delete_button"><i class="fa fa-times-circle"></i></a>'
        } ]
		
	} );
	
	// checkbox filtering
	<!-- BEGIN: CHECKSCRIPT --> 
	$('input:checkbox[name="{CHECKBOX_NAME}"]').on('change', null, otable, function() {
		var {CHECKBOX_NAME} = $('input:checkbox[name="{CHECKBOX_NAME}"]:checked').map(function() {
			return '^' + this.value + '\$';
		}).get().join('|');
		//filter in column 0, with an regex, no smart filtering, no input box, not case sensitive
		otable.fnFilter({CHECKBOX_NAME}, {CHECKBOX_POSITION}, true, false, false, false);
	});
	<!-- END: CHECKSCRIPT --> 
	
	// DataTable
    var table = $('#example').DataTable();
	
	<!-- IF {PHP.cfg.plugin.datatable.footersearch} -->
	
    $('#example tfoot th').each( function () {
        var title = $('#example thead th').eq( $(this).index() ).text();
		if (title != '{PHP.L.datatable_operation_specialcolumn}') {
			$(this).html( '<input type="text" class="form-control" placeholder="Search '+title+'" />' );
		}
    } );
	
	// move search boxes to top
	var r = $('#example tfoot tr');
	r.find('th').each(function(){
		$(this).css('padding', 8);
	});
	$('#example thead').append(r);
	$('#search_0').css('text-align', 'center');
 
    // Apply the search
    table.columns().eq( 0 ).each( function ( colIdx ) {
        $( 'input', table.column( colIdx ).footer() ).on( 'keyup change', function () {
            table
                .column( colIdx )
                .search( this.value )
                .draw();
        } );
    } );
	
	<!-- ENDIF -->
	
	// column visibility
	$('a.toggle-vis').on( 'click', function (e) {
        e.preventDefault();
        // Get the column API object
        var column = table.column( $(this).attr('data-column') );
		console.log(table.column);
        // Toggle the visibility
        var stuff = column.visible( ! column.visible() );
		$(this).toggleClass( "active" );
    } );
	
	//option buttons
	$('#example tbody').on('click', '.view_button', function () {
        var data = table.row( $(this).parents('tr') ).data();
		var getID = data['DT_RowId'].split("_");
        window.location.href = "datatable?action=view&cid="+ getID[1];
    } );
	
	$('#example tbody').on('click', '.edit_button', function () {
        var data = table.row( $(this).parents('tr') ).data();
		var getID = data['DT_RowId'].split("_");
        window.location.href = "datatable?action=update&cid="+ getID[1];
    } );
	
	$('#example tbody').on('click', '.delete_button', function () {
        var data = table.row( $(this).parents('tr') ).data();
		var getID = data['DT_RowId'].split("_");
		window.location.href = "datatable?action=delete&cid="+ getID[1];
    } );
	
	<!-- IF {PHP.cfg.plugin.datatable.range} -->
		// range search init
		<!-- BEGIN: RNGSCRIPT --> 
		$('#{RANGE_NAME}_min, #{RANGE_NAME}_max').keyup( function() {
			table.draw();
		} );

		<!-- END: RNGSCRIPT --> 
	<!-- ENDIF -->
	
} );

<!-- IF {PHP.cfg.plugin.datatable.range} -->

	<!-- BEGIN: RNGSCRIPT2 --> 
	/* Custom filtering function which will search data in column no.{RANGE_POSITION} between two values */
	$.fn.dataTable.ext.search.push(
		function( settings, data, dataIndex ) {	
			var {RANGE_NAME}_min = parseInt( $('#{RANGE_NAME}_min').val(), 10 );
			var {RANGE_NAME}_max = parseInt( $('#{RANGE_NAME}_max').val(), 10 );
			var {RANGE_NAME}_val = parseFloat( data[{RANGE_POSITION}] ) || 0; // use data for the value column
	 
			if ( ( isNaN( {RANGE_NAME}_min ) && isNaN( {RANGE_NAME}_max ) ) ||
				 ( isNaN( {RANGE_NAME}_min ) && {RANGE_NAME}_val <= {RANGE_NAME}_max ) ||
				 ( {RANGE_NAME}_min <= {RANGE_NAME}_val   && isNaN( {RANGE_NAME}_max ) ) ||
				 ( {RANGE_NAME}_min <= {RANGE_NAME}_val   && {RANGE_NAME}_val <= {RANGE_NAME}_max ) )
			{
				return true;
			} else {
				return false;
			}
		}
	);
	<!-- END: RNGSCRIPT2 --> 
<!-- ENDIF -->

</script>
	
	<div class="col-md-12">	
	
		<a class="btn btn-primary pull-right" href="/datatable?action=add">{PHP.L.datatable_addnew} </a>
	
		<button class="btn btn-info collapsed" type="button" data-toggle="collapse" data-target="#column-toggle">
                {PHP.L.datatable_togglecolumns} <b class="caret"></b>
        </button> 
		<button class="btn btn-info collapsed" type="button" data-toggle="collapse" data-target="#advanced-filters">
                {PHP.L.datatable_advfilters} <b class="caret"></b>
        </button>
		<div class="collapse" id="column-toggle" style="margin-top:3px;">
			<div class="btn-group">
			<!-- BEGIN: COLUMNS --> 
				<a class="toggle-vis btn btn-default active" data-column="{COLUMN_COUNTER}">{COLUMN_HEADER}</a> 
			<!-- END: COLUMNS --> 
			</div>	
        </div>	
		<div class="collapse well well-sm" id="advanced-filters" style="margin-top:3px;">
			
			<!-- BEGIN: CHECKBOXES --> 
			<div class="row" style="padding:5px; margin:0px 0px 3px 0px;">
				<div class="col-md-2">Filter {CHECKBOX_HEADER}</div>
				<div class="col-md-10">
				<!-- BEGIN: CHECKLIST --> 
					<input type="checkbox" name="{CHECK_NAME}" value="{CHECK_HEADER}"> {CHECK_HEADER}
				<!-- END: CHECKLIST --> 
				</div>
			</div>
			<!-- END: CHECKBOXES --> 
			
			<!-- BEGIN: RANGECOLS --> 
			<div class="row" style="padding:5px; margin:0px 0px 3px 0px;">
				<div class="col-md-2">Range for {RANGE_HEADER}</div>
				<div class="col-md-10 form-inline">
				Min: <input type="text" class="form-control" style="width:50px;" id="{RANGE_NAME}_min" name="{RANGE_NAME}_min"> 
				Max: <input type="text" class="form-control" style="width:50px;" id="{RANGE_NAME}_max" name="{RANGE_NAME}_max"> 
				</div>
			</div>
			<!-- END: RANGECOLS --> 
			
        </div>		

		<hr>
		<table id="example" class="table table-striped table-bordered" cellspacing="0" width="100%">
				<thead>
					<tr>
						<!-- BEGIN: LISTTOP --> 
						<th>{COLUMN_HEADER}</th>
						<!-- END: LISTTOP --> 
						<th>{PHP.L.datatable_operation_specialcolumn}</th>
					</tr>
				</thead>

				<tfoot>
					<tr>
						<!-- BEGIN: LISTBOTTOM --> 
						<th>{COLUMN_HEADER}</th>
						<!-- END: LISTBOTTOM --> 
						<th></th>
					</tr>
				</tfoot>
			</table>

	</div>
	 
	<!-- END: DEFAULT --> 
	
	
	<!-- BEGIN: FORM --> 
	
	<div class="col-md-12">		
          <form action="" method="post" enctype="multipart/form-data" name="contact_form" role="form">
            <div class="form-group">
              <label>{PHP.L.Name}:</label>
              {DATATABLE_FORM_NAME}
            </div>
            <!-- BEGIN: EXTRAFLD -->
            <div class="form-group">
              <label>{DATATABLE_FORM_EXTRAFLD_TITLE}:</label>
              {DATATABLE_FORM_EXTRAFLD}
            </div>
            <!-- END: EXTRAFLD -->
            <button class="btn btn-primary" type="submit">{PHP.L.Submit}</button>
          </form>	
	</div>
	
	<!-- END: FORM --> 
	
	<!-- BEGIN: UPDATE --> 
	
	<div class="col-md-12">		
          <form action="" method="post" enctype="multipart/form-data" name="contact_form" role="form">
            <div class="form-group">
              <label>{PHP.L.Name}:</label>
              {DATATABLE_FORM_NAME}
            </div>
            <!-- BEGIN: EXTRAFLD -->
            <div class="form-group">
              <label>{DATATABLE_FORM_EXTRAFLD_TITLE}:</label>
              {DATATABLE_FORM_EXTRAFLD}
            </div>
            <!-- END: EXTRAFLD -->
            <button class="btn btn-primary" type="submit">{PHP.L.Submit}</button>
          </form>	
	</div>
	
	<!-- END: UPDATE --> 
	
	<!-- BEGIN: VIEW --> 
	
	<div class="col-md-12">	
	
		{DATATABLE_ID} <br />
		{DATATABLE_NAME}
	
		<table class="table table-striped">
		<!-- BEGIN: EXTRAFLD -->
		<tr>
			<td>{DATATABLE_EXTRAFLD_TITLE}</td>
			<td>{DATATABLE_EXTRAFLD}</td>
		</tr>
		<!-- END: EXTRAFLD -->	
		</table>	
	</div>
	
	<!-- END: VIEW --> 
	  
</div>
<!-- END: MAIN -->
