<?php
/**
 * German Language File for URL management tool
 *
 * @package urleditor
 * @version 0.9.0
 * @author Cotonti Translators Team
 * @copyright Copyright (c) Cotonti Team 2008-2011
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL.');

$L['adm_urls'] = 'URLs';
$L['adm_urls_area'] = 'Bereich';
$L['adm_urls_custom_htaccess'] = 'Benutzerdefinierte .htaccess-Regeln';
$L['adm_urls_error_dat'] = 'Fehler: datas/urltrans.dat ist nicht beschreibbar! Bitte erstellen Sie diese Datei und setzen die Zugriffsrechte auf CHMOD 666.';
$L['adm_urls_format'] = 'Format';
$L['adm_urls_htaccess'] = 'Überschreibe .htaccess?';
$L['adm_urls_new'] = 'Neue Regel';
$L['adm_urls_parameters'] = 'Parameter';
$L['adm_urls_rules'] = 'URL-Umwandlungsregeln';
$L['adm_urls_save'] = 'Speichern';
$L['adm_urls_your'] = 'Deine';
$L['adm_urls_callbacks'] = 'Regel enthält Callbacks';
$L['adm_urls_errors'] = 'Sie müssen hierfür die Rewrite-Optionen manuell hinzufügen.';
$L['adm_help_urls'] = 'Auf dieser Seite können Sie Ihre URLs mit Hilfe einfacher Umwandlungsregeln anpassen. Bitte stellen Sie sicher, dass die Regeln korrekt sind und keine doppelten Einträge existieren. Bitte benutzen Sie keine Leerzeichen, Tabstops und andere Sonderzeichen in den Regeln. Bereiche und Parameter sind wie folgt beschrieben.     
<ol>
<li><strong>Bereich</strong> Ist der Name des Scripts, zu welchem die Regel gehört. Das Symbol (*) bedeutet &quot;jedes Script&quot;</li>
<li><strong>Parameter</strong> ist eine auf die URL-Parameter angepasste Bedingung. Es ist eine Zeichenkette, die Name-Wert-Paare beinhaltet, getrennt durch ein &amp; und Gleichheitszeichen (=) zwischen Parameter-Name und dessen Wert. Ein Fragezeichen (?) am Anfang wird nicht benötigt. Falls Sie hier Variablen angeben, müssen diese in der URL vorhanden sein, um die Regel zu erfüllen. * bedeutet &quot;jeder Wert&quot;, ein einzelner Wert oder eine Liste mehrerer Möglichkeiten, getrennt durch einen senkrechten Strich (|). Alle Werte sollten URL-kodiert sein.<em>Beispiel: name=Val|Josh&amp;id=124&amp;page=*</em>.</li>
<li><strong>Format</strong> Gibt das Format der mit dieser Regel übereinstimmenden URL an. Es ist eine Zeichenkette, welche spezielle Sequenzen beinhaltet, die mit ihren Werten ersetzt werden. Eine normale Sequenz sieht z. B. so aus:{$name}, wobei &quot;name&quot; der Name des URL-Parameters ist (Get-Variable) und mit dessen Wert anstatt der Sequenz ersetzt wird. Es gibt spezielle URL-Parameter, die nicht aus Sequenzen stammen (&quot;Query-String&quot;):            
	<ul>
		<li><em>{$_area}</em> - Script-Name;</li>
		<li><em>{$_host}</em> - Hostname aus der Haupt-URL Ihrer Webseite;</li>
		<li><em>{$_rhost}</em> - Hostname aus dem aktuellen HTTP-Request;</li>
		<li><em>{$_path}</em> - Serverbezogener Pfad Ihrer Seite, / falls sich Ihre Seite im Server-Hauptverzeichnis befindet.</li>
	</ul>
Sie können auch parameterisierte Subdomains nutzen, indem Sie absolute URL-Formate angeben: <em>http://{$c}.site.com/{$al}.html</em>. Wird momentan nur von Apache-Webservern unterstützt.</li>
<li><strong>Neue Regel</strong> Fügt der Tabelle eine neue Regel hinzu.</li>
<li><strong>Anordnung</strong> - Bitte denken Sie daran, dass die Anordnung der Regeln in der Tabelle wichtig ist. Der URL-Umwandlungs-Algorythmus schaut wie folgt nach einer Regel: Zuerst werden alle für einen Bereich definierten Regeln eingelesen. Danach wird versucht, <em>die erste</em> Regel zu finden, welche der Parameter-Bedingung entspricht. Wird keine Regel gefunden, erfolgt ein Rückfall auf den *-Bereich, um dort nach der Regel zu suchen. Es wird empfohlen, dass Ihre Standardregel (mit *-Bereich und *-Parameter) die letzte der *-Regeln oder auch die letzte Regel in der Tabelle ist.<br />  
Sie können die Anordnung ändern, indem Sie einfach die Zeilen mittels Drag-und-Drop an die gewünschte Position verschieben. Sie sollten neue Regeln zuerst speichern, bevor Sie sie einordnen.</li>  
<li><strong>Query-String</strong> Ist das, was man normalerweise nach dem Fragezeichen in einem Link sieht.    Damit werden eventuelle Parameter übergeben und automatisch angehängt, die nicht vom Format-String verarbeitet wurden.</li>
<li><strong>Speichern</strong> Dieser Schalter speichert die Regeln und übernimmt die Änderungen sofort. Weiterhin werden die Änderungen in der Datei .htaccess übernommen (falls beschreibbar) und es wird .htaccess/IsapiRewrite4.ini/nginx.conf angeboten (abhängig vom Server-Typ).</li>
</ol>';

$L['cfg_preset'] = array('URL-Vorlage');
$L['cfg_preset_params'] = array(
	'handy' => 'Handy',
	'compat' => 'Genoa/Seditio-kompatibel',
	'custom' => 'Benutzerdefinierte urltrans.dat',
	'none' => 'Ausgeschaltet'
);

$L['info_desc'] = 'Mit diesem Plugin können Sie benutzerdefinierte URL-Umwandlungsregeln im Adminpanel vornehmen oder eine der Vorlagen verwenden';

?>
