<?php
/* ====================
[BEGIN_COT_EXT]
Hooks=input
[END_COT_EXT]
==================== */

/**
 * Mobile Skin Switcher
 * 
 * @copyright (c) 2011 Seditio.By
 * @package mobiswitcher
 */

defined('COT_CODE') or die('Wrong URL');

$theme_ver = cot_import('ver', 'G', 'ALP');

if ($cfg['plugin']['mobiswitcher']['sef_urls'])
{
	// Get theme_ver from host name
	if (preg_match('#^(m|w)\.'.preg_quote($sys['domain']).'#i', $_SERVER['HTTP_HOST'], $mt))
	{
		$theme_ver = $mt[1];
	}
	else
	{
		$theme_ver = 'n';
	}
}

if (!$theme_ver || !in_array($theme_ver, array('m', 'w', 'n')))
{
	if ($_COOKIE['theme_ver'] == 'm')
	{
		// Saved mobile theme
		$theme_ver = 'm';
	}
	elseif ($_COOKIE['theme_ver'] == 'w')
	{
		// Saved tablet theme
		$theme_ver = 'w';
	}
	elseif ($_COOKIE['theme_ver'] == 'n')
	{
		// Saved normal theme
		$theme_ver = 'n';
	}
	else
	{
		// Auto-detect mobile devices
		require_once $cfg['plugins_dir'] . '/mobiswitcher/inc/mobiswitcher.config.php';
		require_once $cfg['plugins_dir'] . '/mobiswitcher/inc/mobiswitcher.functions.php';

		$mobiDetect = new Mobile_Detect($mobile_devices, $tablet_systems);
	
		if ($mobiDetect->isTablet())
		{
			$theme_ver = 'w';
		}
		elseif ($mobiDetect->isMobile())
		{
			$theme_ver = 'm';
		}
		else
		{
			$theme_ver = 'n';
		}
	}
}

if (in_array($theme_ver, array('m', 'w', 'n')) && $theme_ver != $_COOKIE['theme_ver'])
{
	// Set cookie if settings have changed
	cot_setcookie('theme_ver', $theme_ver, time()+$cfg['cookielifetime'], $cfg['cookiepath'], $cfg['cookiedomain']);
}

// Switch the theme if necessary
if ($theme_ver == 'm')
{
	$usr['theme'] = $cfg['plugin']['mobiswitcher']['mobile_theme'];
}
elseif ($theme_ver == 'w')
{
	$usr['theme'] = $cfg['plugin']['mobiswitcher']['tablet_theme'];
}

// Generate switcher URLs
if ($cfg['plugin']['mobiswitcher']['sef_urls'])
{
	$mobi_uri = str_replace('&', '&amp;', $_SERVER['REQUEST_URI']);
	$normal_url = $sys['scheme'] . '://' . $url['host'] . $mobi_uri;
	$mobile_url = $sys['scheme'] . '://' . 'm.' . $sys['domain'] . $mobi_uri;
	$tablet_url = $sys['scheme'] . '://' . 'w.' . $sys['domain'] . $mobi_uri;
	
	// Redirect to mobile/tablet/normal if necessary
	if (($theme_ver == 'm' || $theme_ver == 'w') && $_SERVER['HTTP_HOST'] != $theme_ver . '.' . $sys['domain'])
	{
		header('Location: ' . $sys['scheme'] . '://' . $theme_ver . '.' . $sys['domain'] . $mobi_uri);
		exit;
	}
	elseif ($theme_ver == 'n' && ($_SERVER['HTTP_HOST'] == 'm.' . $sys['domain'] || $_SERVER['HTTP_HOST'] == 'w.' . $sys['domain']))
	{
		header('Location: ' . $sys['scheme'] . '://' . $url['host'] . $mobi_uri);
		exit;
	}
	
	// Override mainurl for basehref
	if ($theme_ver == 'm' || $theme_ver == 'w')
	{
		$cfg['mainurl'] = $sys['scheme'] . '://' . $theme_ver . '.' . $sys['domain'] . mb_substr($sys['site_uri'], 0, -1);
	}
}
else
{
	$mobi_uri = str_replace('&', '&amp;', preg_replace('#(\?|&)ver=\w#', '',  $_SERVER['REQUEST_URI']));
	$mobi_sep = mb_strpos($mobi_uri, '?') === false ? '?' : '&amp;';
	$normal_url = $mobi_uri . $mobi_sep . 'ver=n';
	$mobile_url = $mobi_uri . $mobi_sep . 'ver=m';
	$tablet_url = $mobi_uri . $mobi_sep . 'ver=w';
}

require_once cot_langfile('mobiswitcher', 'plug', $usr['lang']);

?>