/* Smiley set for editor, in natural order.
Please try to use similar syntax in your sets, because the parser is quite sensitive.

name - smiley name (for internal use)
code - representation in text
file - representation as image
prio - priority for parsing. 1 is highest, 50 is normal. Usually smilies which may
intersect with other smilies have higher priorities over them.
lang - internationalized tip
*/
var smileSet = [
	{
		name: "smile",
		code: ":)",
		file: "smile.png",
		prio: 60,
		lang: smileL.smile
	},
	{
		name: "smiler",
		code: "=)",
		file: "smiler.png",
		prio: 60,
		lang: smileL.smiler
	},
	{
		name: "happy",
		code: ":))",
		file: "lol.png",
		prio: 40,
		lang: smileL.happy
	},
	{
		name: "cool",
		code: ":cool",
		file: "cool.png",
		prio: 40,
		lang: smileL.cool
	},
	{
		name: "sad",
		code: ":(",
		file: "sad.png",
		prio: 60,
		lang: smileL.sad
	},
	{
		name: "anger",
		code: ";)",
		file: "anger.png",
		prio: 50,
		lang: smileL.anger
	},
	{
		name: "shout",
		code: ":D",
		file: "shout.png",
		prio: 50,
		lang: smileL.shout
	},
	{
		name: "eek",
		code: ":O",
		file: "eek.png",
		prio: 50,
		lang: smileL.eek
	},
	{
		name: "sunglass",
		code: "B)",
		file: "sunglass.png",
		prio: 50,
		lang: smileL.sunglass
	},
	{
		name: "confused",
		code: ":/",
		file: "confused.png",
		prio: 50,
		lang: smileL.confused
	},
	{
		name: "razz",
		code: ":X",
		file: "razz.png",
		prio: 50,
		lang: smileL.razz
	},
	{
		name: "angry",
		code: ":((",
		file: "angry.png",
		prio: 50,
		lang: smileL.angry
	},
	{
		name: "fire",
		code: ":E",
		file: "fire.png",
		prio: 50,
		lang: smileL.fire
	},
	{
		name: "love",
		code: ":-*",
		file: "love.png",
		prio: 50,
		lang: smileL.love
	},
	{
		name: "grimace",
		code: "S-)",
		file: "grimace.png",
		prio: 50,
		lang: smileL.grimace
	},
	{
		name: "surprise",
		code: "8-o",
		file: "surprise.png",
		prio: 10,
		lang: smileL.surprise
	},
	{
		name: "prettiness",
		code: ":pretti:",
		file: "prettiness.png",
		prio: 10,
		lang: smileL.prettiness
	},
	{
		name: "question",
		code: ":?",
		file: "question.png",
		prio: 10,
		lang: smileL.question
	},
	{
		name: "tong",
		code: ":P",
		file: "tong.png",
		prio: 50,
		lang: smileL.tong
	},
	{
		name: "vomit",
		code: ":-o~",
		file: "vomit.png",
		prio: 30,
		lang: smileL.vomit
	},
	{
		name: "burn",
		code: ":burn:",
		file: "burn.png",
		prio: 10,
		lang: smileL.burn
	},
	{
		name: "cry",
		code: ":_(",
		file: "cry.png",
		prio: 30,
		lang: smileL.cry
	},
	{
		name: "miao",
		code: ":miao:",
		file: "miao.png",
		prio: 30,
		lang: smileL.miao
	},
	{
		name: "shuai",
		code: ":shuai:",
		file: "shuai.png",
		prio: 10,
		lang: smileL.shuai
	},
	{
		name: "sweat",
		code: ":_)",
		file: "sweat.png",
		prio: 30,
		lang: smileL.sweat
	},
	{
		name: "music",
		code: ":music:",
		file: "music.png",
		prio: 10,
		lang: smileL.music
	},
	{
		name: "ft",
		code: "8-D",
		file: "ft.png",
		prio: 30,
		lang: smileL.ft
	},
	{
		name: "sleep",
		code: ":sleep:",
		file: "sleep.png",
		prio: 10,
		lang: smileL.sleep
	},
	{
		name: "spook",
		code: ":spook:",
		file: "spook.png",
		prio: 10,
		lang: smileL.spook
	},
	{
		name: "slobber",
		code: "B-)~",
		file: "slobber.png",
		prio: 30,
		lang: smileL.slobber
	},
	{
		name: "thirst",
		code: ":-s~",
		file: "thirst.png",
		prio: 30,
		lang: smileL.thirst
	},
	{
		name: "startle",
		code: "8-O",
		file: "startle.png",
		prio: 30,
		lang: smileL.startle
	}
];

// Editor dialog display properties
var smileBox = {
	width: 200, // Width in px
	height: 300, // Height in px
	perRow: 4 // Smilies per row
};