<?php

/**
 * German Language File for the Admin Module (admin.de.lang.php)
 *
 * @package Cotonti
 * @version 0.9.0
 * @author Cotonti Translators Team
 * @copyright Copyright (c) Cotonti Team 2008-2012
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL.');

/**
 * Common words
 */

$L['Extension'] = 'Erweiterung';
$L['Extensions'] = 'Erweiterungen';
$L['Structure'] = 'Struktur';

/**
 * Home Section
 */

$L['home_installable_error'] = 'Bitte entfernen Sie install.php bis zum nächsten Update oder schützen Sie config.php durch bessere Zugriffsrechte.';
                           
$L['home_newusers'] = 'Neue Mitglieder';
$L['home_newpages'] = 'Neue Seiten';
$L['home_newtopics'] = 'Neue Themen';
$L['home_newposts'] = 'Neue Beiträge';
$L['home_newpms'] = 'Neue private Nachrichten';

$L['home_db_rows'] = 'SQL-Datenbank, Zeilenanzahl';
$L['home_db_indexsize'] = 'SQL-Datenbank, Indexgröße (KB)';
$L['home_db_datassize'] = 'SQL-Datenbank, Datengröße (KB)';
$L['home_db_totalsize'] = 'SQL-Datenbank, Gesamtgröße (KB)';

$L['home_ql_b1_title'] = 'Seiteneigenschaften';
$L['home_ql_b1_1'] = 'Basiskonfiguration';
$L['home_ql_b1_2'] = 'Titel';
$L['home_ql_b1_3'] = 'Theme und Zeichensatz';
$L['home_ql_b1_4'] = 'Menübereiche in TPL-Dateien';
$L['home_ql_b1_5'] = 'Sprache';
$L['home_ql_b1_6'] = 'Zeit und Datum';

$L['home_ql_b2_1'] = 'Struktur der Seiten (Kategorien)';
$L['home_ql_b2_2'] = 'Zusatzfelder für Seiten';
$L['home_ql_b2_3'] = 'Zusatzfelder für Kategorien';
$L['home_ql_b2_4'] = 'Parserkonfiguration';

$L['home_ql_b3_1'] = 'Basiskonfiguration';
$L['home_ql_b3_2'] = 'Zusatzfelder für Benutzer';
$L['home_ql_b3_4'] = 'Benutzerrechte';

$L['home_update_notice'] = 'Update verfügbar';
$L['home_update_revision'] = 'Derzeitige Version: <span style="color:#C00;font-weight:bold;">%1$s</span><br />Neue Version: <span style="color:#4E9A06;font-weight:bold;">%3$s</span>'; // %1/%2 Current Version/Revision %3/%4 Updated Version/Revision

/**
 * Config Section
 */

$L['core_forums'] = &$L['Forums'];
$L['core_locale'] = &$L['Locale'];
$L['core_main'] = 'Haupteinstellungen';
$L['core_menus'] = &$L['Menus'];
$L['core_page'] = &$L['Pages'];
$L['core_parser'] = &$L['Parser'];
$L['core_performance'] = 'Leistung';
$L['core_pfs'] = &$L['PFS'];
$L['core_plug'] = &$L['Plugins'];
$L['core_pm'] = &$L['Private_Messages'];
$L['core_polls'] = &$L['Polls'];
$L['core_rss'] = &$L['RSS_Feeds'];
$L['core_security'] = &$L['Security'];
$L['core_sessions'] = 'Sitzungen';
$L['core_structure'] = &$L['Categories'];
$L['core_theme'] = &$L['Themes'];
$L['core_time'] = 'Zeit und Datum';
$L['core_title'] = 'Titel und Metas';

$L['cfg_struct_defaults'] = 'Strukturstandards';

/**
 * Shortcuts
 */
$L['short_admin'] = 'Admin';
$L['short_config'] = 'Konfigurieren';
$L['short_delete'] = 'Löschen';
$L['short_open'] = 'Öffnen';
$L['short_options'] = 'Optionen';
$L['short_rights'] = 'Rechte';
$L['short_struct'] = 'Struktur';

/**
 * Config Section
 * Locale Subsection
 */

$L['cfg_forcedefaultlang'] = array('Standardsprache für alle Benutzer erzwingen', '');
$L['cfg_defaulttimezone'] = array('Standardzeitzone', 'Für Gäste und neue Mitglieder, von -12 bis +12');

/**
 * Config Section
 * Main Subsection
 */

$L['cfg_adminemail'] = array('E-Mail des Admins', 'Benötigt');
$L['cfg_clustermode'] = array('Server-cluster', 'Ja wählen, falls dies eine ausballancierte Installation ist.');
$L['cfg_confirmlinks'] = array('Möglicherweise gefährliche Aktionen bestätigen');
$L['cfg_easypagenav'] = array('Benutzerfreundliche Blätterfunktion', 'Verwendet Seitennummern in URLs anstatt DB-Offsets');
$L['cfg_hostip'] = array('Server-IP', 'Die IP des Servers, optional.');
$L['cfg_maxrowsperpage'] = array('Max. Einträge pro Seite', 'Standardbegrenzung für Blätterfunktion');
$L['cfg_parser'] = array('Markup-Parser', 'Standard: nur Text');

/**
 * Config Section
 * Menus Subsection
 */

$L['cfg_banner'] = array('Banner<br />{HEADER_BANNER} in header.tpl', '');
$L['cfg_bottomline'] = array('Unterste Zeile<br />{FOOTER_BOTTOMLINE} in footer.tpl', '');
$L['cfg_topline'] = array('Oberste Zeile<br />{HEADER_TOPLINE} in header.tpl', '');

$L['cfg_freetext1'] = array('Freitextbereich #1<br />{PHP.cfg.freetext1} in allen tpl-Dateien', '');
$L['cfg_freetext2'] = array('Freitextbereich #2<br />{PHP.cfg.freetext2} in allen tpl-Dateien', '');
$L['cfg_freetext3'] = array('Freitextbereich #3<br />{PHP.cfg.freetext3} in allen tpl-Dateien', '');
$L['cfg_freetext4'] = array('Freitextbereich #4<br />{PHP.cfg.freetext4} in allen tpl-Dateien', '');
$L['cfg_freetext5'] = array('Freitextbereich #5<br />{PHP.cfg.freetext5} in allen tpl-Dateien', '');
$L['cfg_freetext6'] = array('Freitextbereich #6<br />{PHP.cfg.freetext6} in allen tpl-Dateien', '');
$L['cfg_freetext7'] = array('Freitextbereich #7<br />{PHP.cfg.freetext7} in allen tpl-Dateien', '');
$L['cfg_freetext8'] = array('freitextbereich #8<br />{PHP.cfg.freetext8} in allen tpl-Dateien', '');
$L['cfg_freetext9'] = array('Freitextbereich #9<br />{PHP.cfg.freetext9} in allen tpl-Dateien', '');

$L['cfg_menu1'] = array('Menü #1<br />{PHP.cfg.menu1} in allen tpl-Dateien', '');
$L['cfg_menu2'] = array('Menü #2<br />{PHP.cfg.menu2} in allen tpl-Dateien', '');
$L['cfg_menu3'] = array('Menü #3<br />{PHP.cfg.menu3} in allen tpl-Dateien', '');
$L['cfg_menu4'] = array('Menü #4<br />{PHP.cfg.menu4} in allen tpl-Dateien', '');
$L['cfg_menu5'] = array('Menü slot #5<br />{PHP.cfg.menu5} in allen tpl-Dateien', '');
$L['cfg_menu6'] = array('Menü #6<br />{PHP.cfg.menu6} in allen tpl-Dateien', '');
$L['cfg_menu7'] = array('Menü #7<br />{PHP.cfg.menu7} in allen tpl-Dateien', '');
$L['cfg_menu8'] = array('Menü #8<br />{PHP.cfg.menu8} in allen tpl-Dateien', '');
$L['cfg_menu9'] = array('Menü #9<br />{PHP.cfg.menu9} in allen tpl-Dateien', '');

/**
 * Config Section
 * Performance Subsection
 */

$L['cfg_gzip'] = array('Gzip', 'Gzip-Komprimierung der HTML-Ausgabe. verwenden Sie diese Option nicht, wenn GZip-Komprimierung bereits serverseitig eingeschaltet ist. Mit diesem Tool können Sie überprüfen, ob GZip auf Ihrem Server bereits aktiv ist: <a href="http://www.whatsmyip.org/http-compression-test/">HTTP Compression Test</a>');
$L['cfg_headrc_consolidate'] = array('Ressourcen für Header und Footer zusammenführen (JS/CSS)');
$L['cfg_headrc_minify'] = array('Zusammengeführtes JS/CSS verkleinern');
$L['cfg_jquery_cdn'] = array('jQuery von folgender CDN-URL verwenden', 'Beispiel: https://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js');
$L['cfg_jquery'] = array('jQuery einschalten', '');
$L['cfg_turnajax'] = array('Ajax einschalten', 'Funktioniert nur, wenn jQuery eingeschaltet ist');
                  
/**
 * Config Section
 * Security Subsection
*/

$L['cfg_captchamain'] = array('Haupt-Captcha');
$L['cfg_captcharandom'] = array('Zufälliges Captcha');
$L['cfg_hashfunc'] = array('Standard-Hashfunktion', 'Zur Verschlüsselung von Passwörtern');
$L['cfg_referercheck'] = array('Referer-Prüfung für Formulare', 'Verhindert Cross-Domain-Posting');
$L['cfg_shieldenabled'] = array('Schutzschild einschalten', 'Anti-Spamming und Anti-Hammering');
$L['cfg_shieldtadjust'] = array('Schutzschildzeiten (in %)', 'Je höher, desto schwerer haben es Spammer');
$L['cfg_shieldzhammer'] = array('Anti-Hammer nach * schnellen Zugriffen', 'Je niedriger, desto schneller Greift die dreiminütige Sperre');
$L['cfg_devmode'] = array('Entwicklermodus', 'Sollte im Produktionsbetrieb ausgeschaltet werden');
$L['cfg_maintenance'] = array('Wartungsmodus', 'Nur authorisiertes Personal hat Seitenzugriff');
$L['cfg_maintenancereason'] = array('Wartungsgrund', 'Optionale kurze Nachricht');
                                                                               
/**
 * Config Section
 * Sessions Subsection
  */
$L['cfg_cookiedomain'] = array('Cookie-Domain', 'Standard: leer');
$L['cfg_cookielifetime'] = array('Maximale Lebensdauer für Cookies', 'In Sekunden');
$L['cfg_cookiepath'] = array('Cookie-Pfad', 'Standard: leer');
$L['cfg_forcerememberme'] = array('Erzwinge &quot;Login merken&quot;', 'Verwenden Sie diese Funktion auf Mehrdomain-Seiten oder bei plötzlichen Logouts');
$L['cfg_timedout'] = array('Leerlaufzeit in Sekunden', 'Nach dieser Zeitspanne wird ein Benutzer als abwesend angezeigt');
$L['cfg_redirbkonlogin'] = array('Zurückleitung nach Login', 'Leitet den Benutzer nach der Anmeldung zur zuvor angezeigten Seite zurück');
$L['cfg_redirbkonlogout'] = array('Zurückleitung nach Logout', 'Leitet den Benutzer nach der Abmeldung zur zuvor angezeigten Seite zurück');
 
/**
 * Config Section
 * Themes Subsection
 */

$L['cfg_charset'] = array('HTML-Zeichensatz', '');
$L['cfg_disablesysinfos'] = array('Seitenerstellungszeit ausschalten', '(In footer.tpl verwendet)');
$L['cfg_doctypeid'] = array('Dokumententyp', '&lt;!DOCTYPE&gt; des HTML-Layouts');
$L['cfg_forcedefaulttheme'] = array('Standardtheme für alle Benutzer erzwingen', '');
$L['cfg_homebreadcrumb'] = array('Startseite in Wegweiser zeigen', 'Zeigt den Link zur Hauptseite am Anfang des Wegweisers');
$L['cfg_keepcrbottom'] = array('Copyrightvermerk im Tag {FOOTER_BOTTOMLINE} behalten', '(In footer.tpl verwendet)');
$L['cfg_metakeywords'] = array('HTML-Schlüsselwörter', '(Durch Komma getrennt)');
$L['cfg_msg_separate'] = array('Nachrichten getrennt für jede Quelle anzeigen', '');
$L['cfg_separator'] = array('Allgemeines Trennzeichen', '(In Wegweisern usw)');
$L['cfg_showsqlstats'] = array('SQL-Statistiken anzeigen', '(In footer.tpl verwendet)');

/**
 * Config Section
 * Title Subsection
 */

$L['cfg_maintitle'] = array('Seitentitel', 'Haupttitel der Webseite, wird benötigt');
$L['cfg_subtitle'] = array('Beschreibung', 'Optional, wird hinter dem Seitentitel angezeigt');
$L['cfg_title_header'] = array('Header - Titel', 'Optionen: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_header_index'] = array('Header Inhaltstitel', 'Optionen: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_users_details'] = array('Titel - Benutzerdetails', 'Optionen: {USER}, {NAME}');
$L['cfg_subject_mail'] = array('E-Mail-Betreff', 'Optionen: {SITE_TITLE}, {SITE_DESCRIPTION}, {MAIL_SUBJECT}');
$L['cfg_body_mail'] = array('Titel - E-Mail', 'Optionen: {SITE_TITLE}, {SITE_DESCRIPTION}, {SITE_URL}, {ADMIN_EMAIL}, {MAIL_BODY}, {MAIL_SUBJECT}');

/**
 * Config Section
 * Common strings
 */
$L['cfg_css'] = array('Modul/Plugin-CSS einschalten');
$L['cfg_editor'] = array('Richtext-Editor', '');
$L['cfg_markup'] = array('Markup einschalten', 'Schaltet HTML/BB-Code oder andere in Ihrem System installierten Parser ein');

/**
 * Extension management
 */

$L['ext_already_installed'] = 'Diese Erweiterung ist bereits installiert: {$name}';
$L['ext_auth_installed'] = 'Authorisierungsstandards installiert';
$L['ext_auth_locks_updated'] = 'Authorisierungssperren aktualisiert';
$L['ext_auth_uninstalled'] = 'Authorisierungsoptionen entfernt';
$L['ext_bindings_installed'] = '{$cnt} Hookbindings installiert';
$L['ext_bindings_uninstalled'] = '{$cnt} Hookbindings entfernt';
$L['ext_config_error'] = 'Konfigurationssetup fehlgeschlagen';
$L['ext_config_installed'] = 'Konfiguration installiert';
$L['ext_config_uninstalled'] = 'Konfiguration deinstalliert';
$L['ext_config_updated'] = 'Konfigurationsoptionen aktualisiert';
$L['ext_config_struct_error'] = 'Strukturkonfigurationssetup fehlgeschlagen';
$L['ext_config_struct_installed'] = 'Strukturkonfiguration installiert';
$L['ext_config_struct_updated'] = 'Strukturkonfigurationsoptionen aktualisiert';
$L['ext_dependency_error'] = '{$dep_type} &quot;{$dep_name}&quot; benötigt von {$type} &quot;{$name}&quot; ist weder installiert, noch zur Installation ausgewählt';
$L['ext_dependency_uninstall_error'] = '{$type} &quot;{$name}&quot; benötigt diese Erweiterung und sollte zuerst deinstalliert werden';
$L['ext_executed_php'] = 'PHP-Handler ausgeführt: {$ret}';
$L['ext_executed_sql'] = 'SQL-Handler ausgeführt: {$ret}';
$L['ext_installing'] = 'Installiere {$type} &quot;{$name}&quot;';
$L['ext_invalid_format'] = 'Dies ist keine gültige Cotonti-Erweiterung >= 0.9. Bitte wenden Sie sich an den Entwickler';
$L['ext_old_format'] = 'Dies ist ein altes Genoa/Seditio-Plugin. Es könnte möglicherweise nur inkorrekt oder unvollständig funktionieren.';
$L['ext_patch_applied'] = 'Patch {$f} ausgeführt: {$msg}';
$L['ext_patch_error'] = 'Fehler beim Ausführen des Patches {$f}: {$msg}';
$L['ext_requires_modules'] = 'Benötigt Module';
$L['ext_requires_plugins'] = 'Benötigt Plugins';
$L['ext_recommends_modules'] = 'Empfiehlt Module';
$L['ext_recommends_plugins'] = 'Empfiehlt Plugins';
$L['ext_setup_not_found'] = 'Setup-Datei nicht gefunden: {$path}';
$L['ext_uninstall_confirm'] = 'Sind Sie sicher, dass Sie diese Erweiterung deinstallieren möchten? Alle mit ihr verknüpften Daten werden entfernt und können nicht wiederhergestellt werden.<br/><a href="{$url}">Ja, deinstallieren und Daten entfernen.</a>';
$L['ext_uninstalling'] = 'Deinstalliere {$type} &quot;{$name}&quot;';
$L['ext_up2date'] = '{$type} &quot;{$name}&quot; ist auf neuestem Stand';
$L['ext_update_error'] = 'Fehler beim Aktualisieren von {$type} &quot;{$name}&quot;';
$L['ext_updated'] = '{$type} &quot;{$name}&quot; wurde auf Version {$ver} aktualisiert';
$L['ext_updating'] = 'Aktualisiere {$type} &quot;{$name}&quot;';

/**
   * Extension categories 
 */
$L['ext_cat']['administration-management'] = 'Administration &amp; Verwaltung';
$L['ext_cat']['commerce'] = 'Commerce &amp; Shopping';
$L['ext_cat']['community-social'] = 'Community &amp; Soziales';
$L['ext_cat']['customization-i18n'] = 'Anpassung &amp; I18n';
$L['ext_cat']['data-apis'] = 'Datenfeeds &amp; APIs';
$L['ext_cat']['development-maintenance'] = 'Entwicklung &amp; Wartung';
$L['ext_cat']['editor-parser'] = 'Editoren &amp; Markup';
$L['ext_cat']['files-media'] = 'Dateien &amp; Medien';
$L['ext_cat']['forms-feedback'] = 'Formulare &amp; Feedback';
$L['ext_cat']['gaming-clans'] = 'Gaming &amp; Clans';
$L['ext_cat']['intranet-groupware'] = 'Intranet &amp; Groupware';
$L['ext_cat']['misc-ext'] = 'Verschiedenes';
$L['ext_cat']['mobile-geolocation'] = 'Mobil &amp; Geolocation';
$L['ext_cat']['navigation-structure'] = 'Navigation &amp; Struktur';
$L['ext_cat']['performance-seo'] = 'Performance &amp; SEO';
$L['ext_cat']['publications-events'] = 'Veröffentlichungen &amp; Veranstaltungen';
$L['ext_cat']['security-authentication'] = 'Sicherheit &amp; Authentifizierung';
$L['ext_cat']['utilities-tools'] = 'Utilities &amp; Werkzeuge';
$L['ext_cat']['post-install'] = 'Skripte nach der Installation';

/**
* Structure Section
 */

$L['adm_structure_code_reserved'] = "Strukturcode 'all' ist reserviert.";
$L['adm_structure_code_required'] = 'Fehlende Eingabe: Code';
$L['adm_structure_path_required'] = 'Fehlende Eingabe: Pfad';
$L['adm_structure_title_required'] = 'Fehlende Eingabe: Titel';
$L['adm_cat_exists'] = 'Eine Kategorie mit diesem Code existiert bereits';
$L['adm_tpl_mode'] = 'Vorlagenmodus';
$L['adm_tpl_empty'] = 'Standard';
$L['adm_tpl_forced'] = 'Genau wie';
$L['adm_tpl_parent'] = 'Genau wie übergeordnete Kategorie';
$L['adm_tpl_quickcat'] = 'Eigener Kategoriecode';
$L['adm_tpl_resyncalltitle'] = 'Alle Seitenzähler neu abgleichen';
$L['adm_tpl_resynctitle'] = 'Kategorieseitenzähler neu abgleichen';
$L['adm_help_structure'] = 'Die Seiten der Kategorie &quot;system&quot; werden nicht in öffentlichen Listen angezeigt, sie sind für Standalone-Seiten vorgesehen.';

/**
 * Structure Section
 * Extrafields Subsection
 */

$L['adm_extrafields_desc'] = 'Zusatzfelder hinzufügen/bearbeiten';
$L['adm_extrafields_all'] = 'Alle Datenbanktabellen anzeigen';
$L['adm_extrafields_table'] = 'Tabelle';

$L['adm_extrafields_help_notused'] = 'Nicht verwendet';
$L['adm_extrafields_help_variants'] = '{variant1},{variant2},{variant3},...';
$L['adm_extrafields_help_range'] = '{min_value},{max_value}';
$L['adm_extrafields_help_data'] = '{min_year},{max_year},{date_format}. Wenn {date_format} leer ist, wird Zeitstempel verwendet';
$L['adm_extrafields_help_regex'] = 'Regex zur Überprüfung';
$L['adm_extrafields_help_file'] = 'Upload-Verzeichnis';
$L['adm_extrafields_help_separator'] = 'Wertetrennzeichen';
$L['adm_help_info'] = '<b>Basis-HTML</b> ist automatisch gewählt wenn das Feld  leer bleibt';
$L['adm_help_newtags'] = '<br /><br /><b>Neue Tags in TPL-Dateien:</b>';

/**
 * Users Section
 */

$L['adm_rightspergroup'] = 'Rechte pro Gruppe';
$L['adm_maxsizesingle'] = 'Maximale Größe einer einzelnen Datei in '.$L['PFS'].' (KB)';
$L['adm_maxsizeallpfs'] = 'Gemeinsame Größe aller Dateien in '.$L['PFS'].' (KB)';
$L['adm_copyrightsfrom'] = 'Gleiche Rechte wie für Gruppe vergeben';
$L['adm_rights_maintenance'] = 'Seitenzugriff während Wartungsmodus';
$L['adm_skiprights'] = 'Rechte für diese Gruppe überspringen';

/**
 * Plug Section
 */

$L['adm_defauth_guests'] = 'Standardrechte für Gäste';
$L['adm_deflock_guests'] = 'Sperrmaske für Gäste';
$L['adm_defauth_members'] = 'Standardrechte für Mitglieder';
$L['adm_deflock_members'] = 'Sperrmaske für Mitglieder';

$L['adm_present'] = 'vorhanden';
$L['adm_missing'] = 'fehlt';
$L['adm_paused'] = 'pausiert';
$L['adm_running'] = 'läuft';
$L['adm_partrunning'] = 'läuft teilweise';
$L['adm_partstopped'] = 'teilweise angehalten';
$L['adm_installed'] = 'Installiert';
$L['adm_notinstalled'] = 'nicht installiert';

$L['adm_plugsetup'] = 'Plugin-Setup';
$L['adm_override_guests'] = 'System überschreiben, Gäste und inaktive Accounts dürfen nicht Administrieren'; 
$L['adm_override_banned'] = 'System überschreiben, gesperrt';
$L['adm_override_admins'] = 'System überschreiben, Administratoren';

$L['adm_opt_install'] = 'Installieren';
$L['adm_opt_install_explain'] = 'Erzeugt eine Neuinstallation dieser Erweiterung';
$L['adm_opt_pause'] = 'Pausieren';
$L['adm_opt_pauseall'] = 'Alles pausieren';
$L['adm_opt_pauseall_explain'] = 'Pausiert alle Teile des Plugins.';
$L['adm_opt_update'] = 'Aktualisieren';
$L['adm_opt_update_explain'] = 'Aktualisiert die Erweiterung oder Konfiguration, falls die Dateien bereits aktualisiert wurden';
$L['adm_opt_uninstall'] = 'Deinstallieren';
$L['adm_opt_uninstall_explain'] = 'Die Erweiterung wird ausgeschaltet, alle Daten und Konfigurationen entfernt, die Dateien bleiben aber physisch erhalten.';
$L['adm_opt_unpause'] = 'Wieder ausführen';
$L['adm_opt_unpauseall'] = 'Alles wieder ausführen';
$L['adm_opt_unpauseall_explain'] = 'Schaltet alle Teile des Plugins wieder ein.';

$L['adm_opt_setup_missing'] = 'Fehler: Setup-Datei fehlt!';
$L['adm_sort_alphabet'] = 'Alphabetisch';
$L['adm_sort_category'] = 'Kategorieansicht';
$L['adm_only_installed'] = 'installierte';

/**
 * Tools Section
 */

$L['adm_listisempty'] = 'Liste ist leer';

/**
 * Other Section
 * Cache Subsection
 */

$L['adm_delcacheitem'] = 'Cache-Eintrag entfernt';
$L['adm_internalcache'] = 'Interner Cache';
$L['adm_purgeall_done'] = 'Cache vollständig geleert';
$L['adm_diskcache'] = 'Festplattencache';
$L['adm_cache_showall'] = 'Alles anzeigen';

/**
 * Other Section
 * Log Subsection
 */

$L['adm_log'] = 'Systemlog';
$L['adm_infos'] = 'Information';
$L['adm_versiondclocks'] = 'Versionen und Uhren';
$L['adm_checkcorethemes'] = 'Kerndateien und Themes überprüfen';
$L['adm_checkcorenow'] = 'Kerndateien jetzt überprüfen!';
$L['adm_checkingcore'] = 'Kerndateien werden geprüft...';
$L['adm_checkthemes'] = 'Prüfen Sie, ob alle Dateien im Theme vorhanden sind';
$L['adm_checktheme'] = 'Überprüfe TPL-Dateien für Theme';
$L['adm_checkingtheme'] = 'Theme wird überprüft...';
$L['adm_check_ok'] = 'OK';
$L['adm_check_missing'] = 'fehlt';

/**
 * Other Section
 * Infos Subsection
 */

$L['adm_phpver'] = 'PHP-Version';
$L['adm_zendver'] = 'Zend-Version';
$L['adm_interface'] = 'Interface zwischen Webserver und PHP';
$L['adm_cachedrivers'] = 'Cache-Treiber';
$L['adm_os'] = 'Betriebssystem';
$L['adm_clocks'] = 'Uhren';
$L['adm_time1'] = '#1: Unverarbeitete Serverzeit';
$L['adm_time2'] = '#2: vom Server zurückgegebene GMT-Zeit';
$L['adm_time3'] = '#3: GMT-Zeit + Zeitzone (Cotonti-Referenz)';
$L['adm_time4'] = '#4: Die in Ihrem Profil festgelegte lokale Zeit';
$L['adm_help_versions'] = 'Konfigurieren Sie die richtige Zeitzone des Servers, um die Uhr #3 korrekt anzuzeigen.<br />
Uhr #4 hängt von der Zeitzoneneinstellung in Ihrem Profil ab.<br />
Die Uhren #1 und #2 werden von Cotonti ignoriert.';

/**
 * Common Entries
 */

$L['adm_area'] = 'Bereich';
$L['adm_clicktoedit'] = '(klicken zum Bearbeiten)';
$L['adm_confirm'] = 'Schalter zum Bestätigen klicken: ';
$L['adm_done'] = 'Fertig';
$L['adm_failed'] = 'Fehlgeschlagen';
$L['adm_from'] = 'Von';
$L['adm_more'] = 'Weitere Werkzeuge...';
$L['adm_purgeall'] = 'Alles aufräumen';
$L['adm_queue_unvalidated'] = 'unbestätigt';
$L['adm_queue_validated'] = 'bestätigt';
$L['adm_required'] = '(benötigt)';
$L['adm_setby'] = 'Gesetzt von';
$L['adm_to'] = 'Nach';
$L['adm_totalsize'] = 'Gesamtgröße';
$L['adm_warnings'] = 'Warnungen';

$L['editdeleteentries'] = 'Einträge bearbeiten oder löschen';
$L['viewdeleteentries'] = 'Einträge anzeigen oder löschen';

$L['alreadyaddnewentry'] = 'Neuer Eintrag hinzugefügt';
$L['alreadyupdatednewentry'] = 'Eintrag aktualisiert';
$L['alreadydeletednewentry'] = 'Eintrag gelöscht';

/**
 * Extra Fields (Common Entries for Pages & Structure & Users)
 */

$L['adm_extrafields'] = 'Zusatzfelder';
$L['adm_extrafield_added'] = 'Neues Zusatzfeld erfolgreich hinzugefügt.';
$L['adm_extrafield_not_added'] = 'Fehler! Neues Zusatzfeld nicht hinzugefügt.';
$L['adm_extrafield_updated'] = 'Zusatzfeld \'%1$s\' erfolgreich aktualisiert.';
$L['adm_extrafield_not_updated'] = 'Fehler! Zusatzfeld \'%1$s\' nicht aktualisiert.';
$L['adm_extrafield_removed'] = 'Zusatzfeld erfolgreich entfernt.';
$L['adm_extrafield_not_removed'] = 'Fehler! Zusatzfeld nicht gelöscht.';
$L['adm_extrafield_confirmdel'] = 'Soll dieses Zusatzfeld wirklich gelöscht werden? Alle Daten gehen verloren!';
$L['adm_extrafield_confirmupd'] = 'Soll dieses Zusatzfeld wirklich aktualisiert werden? Einige Daten könnten verloren gehen!';
$L['adm_extrafield_default'] = 'Standardwert';
$L['adm_extrafield_required'] = 'Benötigtes Feld';
$L['adm_extrafield_parse'] = 'Interpreter';
$L['adm_extrafield_enable'] = 'Feld einschalten';
$L['adm_extrafield_params'] = 'Feldparameter';

$L['extf_Name'] = 'Name';
$L['extf_Type'] = 'Feldtyp';
$L['extf_Base_HTML'] = 'Basis-HTML';
$L['extf_Page_tags'] = 'Tags';
$L['extf_Description'] = 'Beschreibung (_TITLE)';

$L['adm_extrafield_new'] = 'Neues Zusatzfeld';
$L['adm_extrafield_noalter'] = 'Zusatzfeld nicht der Datenbank hinzufügen, nur als Zusatzfeld registrieren';
$L['adm_extrafield_selectable_values'] = 'Optionen für Listen, Auswahlschalter und Checklisten (durch Komma getrennt)';
$L['adm_help_extrafield'] = 'Hinweis: Feld &quot;Basis-HTML&quot; ist automatisch gewählt, wenn Sie nichts eingeben und auf &quot;Aktualisieren&quot; klicken.';

/**
 * Help messages that still don't work
 */

$L['adm_help_cache'] = 'Not available';
$L['adm_help_check1'] = 'Not available';
$L['adm_help_check2'] = 'Not available';
$L['adm_help_config']= 'Not available';

?>