<?php

/* ====================
  [BEGIN_COT_EXT]
  Hooks=standalone
  [END_COT_EXT]
  ==================== */

/**
 * Datatables Plugin for Cotonti CMF
 *
 * @package Datatable
 * @copyright (c) Joanna Torz for Cotonti Team
 * @license https://github.com/Cotonti/Cotonti/blob/master/License.txt
 */
defined('COT_CODE') or die('Wrong URL');

$action = cot_import('action', 'G', 'TXT');
$cid = (int) cot_import('cid', 'G', 'INT');
$mskin = cot_tplfile(array('datatable'), 'plug');
require_once cot_incfile('datatable', 'plug');
$t = new XTemplate($mskin);

cot_display_messages($t);	
$out['subtitle'] = $L['datatable_title'];

// Check permissions
list($auth_read, $auth_write, $auth_admin) = cot_auth('plug', 'datatable');

switch ($action)
{
	case 'delete':
	
	cot_block($auth_admin);
	
	$sql_datatable_delete = $db->query("SELECT * FROM $db_datatable WHERE datatable_id=$cid LIMIT 1");

	if ($row_datatable_delete = $sql_datatable_delete->fetch())
	{
		$db->delete($db_datatable, "datatable_id = $cid");
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			cot_extrafield_unlinkfiles($row_datatable_delete['datatable_' . $exfld['field_name']], $exfld);
		}
		cot_message('datatable_itemdeleted');
	}
	cot_redirect(cot_url('datatable'));
	
	break;
	
	
		
	case 'view':
	
	cot_block($auth_read);
	
	$row = $db->query("SELECT * FROM $db_datatable WHERE datatable_id = $cid")->fetch();

	$t->assign(array(
		'DATATABLE_NAME' => $row['datatable_name'],
		'DATATABLE_ID' => $row['datatable_id'],
	));

	// Extrafields
	if (isset($cot_extrafields[$db_datatable]))
	{
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			$tag = mb_strtoupper($exfld['field_name']);
			$exfld_val = cot_build_extrafields_data('datatable', $exfld, $row['datatable_'.$exfld['field_name']]);
			$exfld_title = isset($L['datatable_' . $exfld['field_name'] . '_title']) ? $L['datatable_' . $exfld['field_name'] . '_title'] : $exfld['field_description'];

			$t->assign(array(
				'DATATABLE_' . $tag . '_TITLE' => $exfld_title,
				'DATATABLE_' . $tag => $exfld_val,
				'DATATABLE_' . $tag . '_VALUE' => $row['datatable_'.$exfld['field_name']],
				'DATATABLE_EXTRAFLD_TITLE' => $exfld_title,
				'DATATABLE_EXTRAFLD' => $exfld['field_type'] == 'file' ? cot_rc_link($cfg['extrafield_files_dir'] . '/' . $exfld_val, $exfld_val) : $exfld_val,
				'DATATABLE_EXTRAFLD_VALUE' => $row['datatable_'.$exfld['field_name']]
			));
			$t->parse('MAIN.VIEW.EXTRAFLD');
		}
	}

	$t->parse('MAIN.VIEW');
	
	break;
		
				
	case 'add':
	
	cot_block($auth_write);

	if (isset($_POST['x']))
	{
		//Import the variables
		$rdatatable['datatable_name'] = cot_import('rname', 'P', 'TXT');

		// Extra fields
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			$rdatatable['datatable_' . $exfld['field_name']] = cot_import_extrafields('rdatatable' . $exfld['field_name'], $exfld);
		}

		if (empty($rdatatable['datatable_name']) OR $rdatatable['datatable_name'] == '')
		{
			cot_error('datatable_noname', 'rname');
		}

		if (!cot_error_found())
		{
			//$rdatatable['datatable_authorid'] = (int) $usr['id'];
			//$rdatatable['datatable_date'] = (int) $sys['now'];
			//$rdatatable['datatable_val'] = 0;

			$db->insert($db_datatable, $rdatatable);
			
			cot_message('datatable_itemadded');
			cot_extrafield_movefiles();
			
			$sent = true;
		}
	}
	
	if (!$sent) {
		
		cot_display_messages($t);

		$t->assign(array(
			'DATATABLE_FORM_NAME' => cot_inputbox('text', 'rname', $rdatatable['datatable_name'], 'size="50"'),
		));

		// Extra fields
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			$uname = strtoupper($exfld['field_name']);
			$exfld_val = cot_build_extrafields('rdatatable' . $exfld['field_name'], $exfld, $rdatatable[$exfld['field_name']]);
			$exfld_title =  isset($L['datatable_' . $exfld['field_name'] . '_title']) ? $L['datatable_' . $exfld['field_name'] . '_title'] : $exfld['field_description'];
			$t->assign(array(
				'DATATABLE_FORM_' . $uname => $exfld_val,
				'DATATABLE_FORM_' . $uname . '_TITLE' => $exfld_title,
				'DATATABLE_FORM_EXTRAFLD' => $exfld_val,
				'DATATABLE_FORM_EXTRAFLD_TITLE' => $exfld_title
				));
			$t->parse('MAIN.FORM.EXTRAFLD');
		}
	} else {
		cot_redirect(cot_url('datatable'));
	}

		$t->parse('MAIN.FORM');
	
	break;
	
	
		
	case 'update':
	
	cot_block($auth_admin);
	
	$res = $db->query("SELECT * FROM $db_datatable WHERE datatable_id = $cid")->fetch();
	
	foreach ($res as $key => $row)
	{
		if ($key != 'datatable_id') {
			$rdatatable[$key] = $row;	
		}
	}
	
	if (isset($_POST['x']))
	{
		//Import the variables
		$rdatatable['datatable_name'] = cot_import('rname', 'P', 'TXT');

		// Extra fields
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			$rdatatable['datatable_' . $exfld['field_name']] = cot_import_extrafields('rdatatable' . $exfld['field_name'], $exfld);
		}

		if ($rdatatable['datatable_name'] == '')
		{
			cot_error('datatable_noname', 'rname');
		}

		if (!cot_error_found())
		{
			//$rdatatable['datatable_authorid'] = (int) $usr['id'];
			//$rdatatable['datatable_date'] = (int) $sys['now'];
			//$rdatatable['datatable_val'] = 0;

			$db->update($db_datatable, $rdatatable, "datatable_id = $cid");
			
			cot_message('datatable_itemupdated');
			cot_extrafield_movefiles();
			
			$sent = true;
		}
	}
	
	if ($sent) {
		cot_redirect(cot_url('datatable'));
	}

		$t->assign(array(
			'DATATABLE_FORM_NAME' => cot_inputbox('text', 'rname', $rdatatable['datatable_name'], 'size="50"'),
		));

		// Extra fields
		foreach ($cot_extrafields[$db_datatable] as $exfld)
		{
			$uname = strtoupper($exfld['field_name']);
			$exfld_val = cot_build_extrafields('rdatatable' . $exfld['field_name'], $exfld, $rdatatable['datatable_'.$exfld['field_name']]);
			$exfld_title =  isset($L['datatable_' . $exfld['field_name'] . '_title']) ? $L['datatable_' . $exfld['field_name'] . '_title'] : $exfld['field_description'];
			$t->assign(array(
				'DATATABLE_FORM_' . $uname => $exfld_val,
				'DATATABLE_FORM_' . $uname . '_TITLE' => $exfld_title,
				'DATATABLE_FORM_EXTRAFLD' => $exfld_val,
				'DATATABLE_FORM_EXTRAFLD_TITLE' => $exfld_title
				));
			$t->parse('MAIN.UPDATE.EXTRAFLD');
		}

	$t->parse('MAIN.UPDATE');
	
	
	break;
	
	
		
	default:
	
	cot_block($auth_read);
		
	cot_rc_link_file($cfg['plugins_dir'] . "/datatable/datatables/js/jquery.dataTables.js");
	
	// cot_rc_link_file($cfg['plugins_dir'] . "/datatable/datatables/css/jquery.dataTables.css");
	// if not bootstrap, comment 2 lines below and uncomment 1 above
	cot_rc_link_file($cfg['plugins_dir'] . "/datatable/datatables/bootstrap/dataTables.bootstrap.css");
	cot_rc_link_file($cfg['plugins_dir'] . "/datatable/datatables/bootstrap/dataTables.bootstrap.js");

	$headers = array();
	$columns = array();
	$table = array();
	$position = array();
	
	$blacklist = explode(',', $cfg['plugin']['datatable']['blacklist']);
	
	$res = $db->query("SHOW COLUMNS FROM $db_datatable");
	while ($row = $res->fetch())
	{
		if (!in_array($row['Field'],$blacklist) AND $row['Key'] != 'PRI') {	
				// look for translations in lang file, if not found, capitalize column name after cutting off appendix
				$headers[$row['Field']] = isset($L[$row['Field'].'_title']) ? $L[$row['Field'].'_title'] : ucfirst(str_replace('datatable_','',$row['Field']));	
				$columns[] = $row['Field'];				
		}	
	}

	// headers list and column hide area
	$counter = 0;
	foreach ($headers as $key => $value) {	
	
			// header position to table name, will be needed in range search
			$position[$key] = $counter;
			
			$t->assign(array(
				'COLUMN_HEADER' => $value,
				'COLUMN_COUNTER' => $counter
				));
			$t->parse('MAIN.DEFAULT.COLUMNS');
			$t->parse('MAIN.DEFAULT.LISTTOP');
			$t->parse('MAIN.DEFAULT.LISTBOTTOM');
			$counter++;
	}
	
	// ... and last column = operations.
		$t->assign(array(
			'COLUMN_HEADER' => $L['datatable_operation_specialcolumn'],
			'COLUMN_COUNTER' => $counter 
		));
	$t->parse('MAIN.DEFAULT.COLUMNS');
	
	// columns list for javascript
	foreach ($columns as $value) {	
			$t->assign(array(
				'DATATABLE_COLS' => $value,
				));
			$t->parse('MAIN.DEFAULT.LISTCOLS');	
	}
	
	// filtering - columns with range search
	$rangelist = explode(',', $cfg['plugin']['datatable']['range']);
	
	if (is_array($rangelist) AND !empty($rangelist)) {
		foreach ($rangelist as $value) {
			if (!in_array($value,$blacklist) AND in_array($value,$columns)) {
				$t->assign(array(
					'RANGE_NAME' => $value,
					'RANGE_POSITION' => $position[$value],
					'RANGE_HEADER' => $headers[$value],
					));
				$t->parse('MAIN.DEFAULT.RNGSCRIPT');
				$t->parse('MAIN.DEFAULT.RNGSCRIPT2');
				$t->parse('MAIN.DEFAULT.RANGECOLS');
			}
		}
	}
	
	// filtering - columns with checkbox filtering	
	$checklist = explode(',', $cfg['plugin']['datatable']['checkbox']);
	
	if (is_array($checklist) AND !empty($checklist)) {
		
		$res = $db->query("SELECT * FROM $db_datatable");
		while ($row = $res->fetch())
		{
			foreach ($columns as $column) {
				$table[$column][$row[$column]] = $row[$column];
			}	
		}	
			
		foreach ($checklist as $value) {
			if (!in_array($value,$blacklist) AND in_array($value,$columns)) {
				
				// searchable checkbox values
				foreach ($table[$value] as $finalvalue) {
					$t->assign(array(
						'CHECK_NAME' => $value,
						'CHECK_HEADER' => $finalvalue,
						));
					$t->parse('MAIN.DEFAULT.CHECKBOXES.CHECKLIST');	
				}
				
				$t->assign(array(
					'CHECKBOX_NAME' => $value,
					'CHECKBOX_POSITION' => $position[$value],
					'CHECKBOX_HEADER' => $headers[$value],
					));
				$t->parse('MAIN.DEFAULT.CHECKSCRIPT');
				$t->parse('MAIN.DEFAULT.CHECKBOXES');
			}
		}
	}
		
	$res->closeCursor(); 
	$t->parse('MAIN.DEFAULT');
	
	break;
}