<?php
/* ====================
[BEGIN_COT_EXT]
Code=reactions
Name=Reactions
Category=community-social
Description=Allows users to react to content with various emoji reactions
Version=1.0.0
Date=2025-04-26
Author=Rootali / Slaweally
Copyright=Copyright (c) 2025 Rootali / Slaweally
Notes=BSD License
SQL=setup/reactions.install.sql
Hooks=plugins.init
Auth_guests=R
Lock_guests=12345A
Auth_members=RW
Lock_members=12345
Requires_plugins=cotlib
Recommends_modules=page,forums
Recommends_plugins=comments
[END_COT_EXT]

[BEGIN_COT_EXT_CONFIG]
limits=00:separator:::
maxday=01:string::10:Max reactions a user can give per day
maxuser=02:string::5:Max reactions a day a user can give to a particular user
maxreacted=03:string::10:Max number of users displayed who reacted to an item

pagination=10:separator:::
usersperpage=11:string::20:Max users per page
nozero=12:radio::1:No zero-reacted users in the list
reactionsperpage=13:string::20:Max reactions per page
ajax=14:radio::1:Use AJAX

page=20:separator:::
page_on=21:radio::1:Turn on reactions for pages
page_class=23:string::btn btn-outline-primary btn-sm:Class for page reaction links
page_list=24:radio::1:Generate tags for page lists

forums=30:separator:::
forums_on=31:radio::1:Turn on reactions for forums (posts)
forums_class=32:string::btn btn-outline-primary btn-sm:Class for post reaction links

comments=40:separator:::
comments_on=41:radio::1:Turn on reactions for comments
comments_class=42:string::btn btn-outline-primary btn-sm:Class for comment reaction links
comments_order=43:radio::0:Sort comments by reactions count

notifications=50:separator:::
notify_from=51:string::noreply@yoursite.com:Email to send notifications from
notify_by_email=52:radio::0:Notify by email on new reactions
notify_by_pm=53:radio::1:Notify by PM on new reactions

reaction_types=60:separator:::
like=61:radio::1:Enable Like reaction (👍)
love=62:radio::1:Enable Love reaction (❤️)
laugh=63:radio::1:Enable Laugh reaction (😂)
wow=64:radio::1:Enable Wow reaction (😮)
sad=65:radio::1:Enable Sad reaction (😢)
angry=66:radio::0:Enable Angry reaction (😠)

misc=70:separator:::
display_count=71:radio::1:Display reaction counts
display_users=72:radio::1:Display users who reacted
use_tooltips=73:radio::1:Use tooltips to show users who reacted
[END_COT_EXT_CONFIG]
==================== */

defined('COT_CODE') or die('Wrong URL');

global $db;
// 1) Veritabanı tablosunu kaydet
$db->registerTable('reactions');

// 2) Gerekli dosyaları yükle
require_once cot_incfile('reactions', 'plug', 'resources');
require_once cot_incfile('reactions', 'plug', 'functions');

// 3) Comments, forums, page list loop handler dosyaları otomatik yüklenecek
//    (hooks zaten comments.loop, forums.posts.loop, page.list.loop olarak tanımlı
//     reaction.setup.php içinde ayrı ayrı include'a gerek yok)
