<?php
/* ====================
[BEGIN_COT_EXT]
Hooks=ajax
[END_COT_EXT]
==================== */

/**
 * Reactions AJAX handler
 *
 * @package reactions
 * @version 1.0.0
 * @author Rootali / Slaweally
 * @copyright Copyright (c) 2025 Rootali / Slaweally
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL');

require_once cot_incfile('reactions', 'plug');

$action = cot_import('action', 'G', 'ALP');
$ext = cot_import('ext', 'G', 'ALP');
$item = cot_import('item', 'G', 'INT');
$type = cot_import('type', 'G', 'ALP');

$response = array(
    'success' => false,
    'message' => '',
    'counts' => array()
);

if (!in_array($action, array('add', 'remove', 'counts')) || empty($ext) || empty($item)) {
    $response['message'] = 'Invalid parameters';
    echo json_encode($response);
    exit;
}

// Get the item owner
if ($ext == 'page') {
    require_once cot_incfile('page', 'module');
    $res = Cot::$db->query("SELECT page_ownerid FROM " . Cot::$db->pages . " WHERE page_id = ?", array($item));
    $owner_id = $res->fetchColumn();
} elseif ($ext == 'forums') {
    require_once cot_incfile('forums', 'module');
    $res = Cot::$db->query("SELECT fp_posterid FROM " . Cot::$db->forum_posts . " WHERE fp_id = ?", array($item));
    $owner_id = $res->fetchColumn();
} elseif ($ext == 'comments') {
    require_once cot_incfile('comments', 'plug');
    $res = Cot::$db->query("SELECT com_authorid FROM " . Cot::$db->com . " WHERE com_id = ?", array($item));
    $owner_id = $res->fetchColumn();
} else {
    $owner_id = 0;
}

if (!$owner_id) {
    $response['message'] = 'Item not found';
    echo json_encode($response);
    exit;
}

if (empty(Cot::$usr['id'])) {
    $response['message'] = 'Please login to use reactions';
    echo json_encode($response);
    exit;
}

if (Cot::$usr['id'] == $owner_id) {
    $response['message'] = 'You cannot react to your own content';
    echo json_encode($response);
    exit;
}

// Check write permissions
if (!cot_auth('plug', 'reactions', 'W')) {
    $response['message'] = 'You don\'t have permission to use reactions';
    echo json_encode($response);
    exit;
}

if ($action == 'add' && !empty($type)) {
    // Validate reaction type
    $valid_types = array('like', 'love', 'laugh', 'wow', 'sad', 'angry');
    if (!in_array($type, $valid_types) || !Cot::$cfg['plugin']['reactions'][$type]) {
        $response['message'] = 'Invalid reaction type';
        echo json_encode($response);
        exit;
    }
    
    // Check if reaction is allowed
    $status = reaction_check($owner_id, Cot::$usr['id'], $ext, $item);
    
    switch ($status) {
        case REACTION_ERR_MAXDAY:
            $response['message'] = 'You\'ve reached your daily reaction limit';
            break;
        case REACTION_ERR_MAXUSER:
            $response['message'] = 'You\'ve reached your daily reaction limit for this user';
            break;
        case REACTION_ERR_ITEM:
            $response['message'] = 'You\'ve already reacted to this item';
            break;
        case REACTION_ERR_SELF:
            $response['message'] = 'You cannot react to your own content';
            break;
        case REACTION_ERR_NONE:
            // Try to add the reaction
            if (reaction_add($owner_id, Cot::$usr['id'], $ext, $item, $type)) {
                $response['success'] = true;
                $response['message'] = 'Reaction added';
                
                // Send notifications if enabled
                if (Cot::$cfg['plugin']['reactions']['notify_by_pm'] && cot_module_active('pm')) {
                    require_once cot_incfile('pm', 'module');
                    cot_send_pm($owner_id, 'New reaction', 
                        cot_rc('reactions_pm_notification', array(
                            'intro' => Cot::$usr['name'] . ' reacted to your content',
                            'link' => cot_url($ext == 'forums' ? 'forums' : $ext, 'm=posts&id=' . $item, '', true)
                        ))
                    );
                }
                
                if (Cot::$cfg['plugin']['reactions']['notify_by_email']) {
                    $owner_email = Cot::$db->query("SELECT user_email FROM " . Cot::$db->users . " WHERE user_id = ?", array($owner_id))->fetchColumn();
                    if ($owner_email) {
                        cot_mail($owner_email, 'New reaction', 
                            cot_rc('reactions_email_notification', array(
                                'intro' => Cot::$usr['name'] . ' reacted to your content',
                                'link' => cot_url($ext == 'forums' ? 'forums' : $ext, 'm=posts&id=' . $item, '', true)
                            ))
                        );
                    }
                }
            } else {
                $response['message'] = 'Failed to add reaction';
            }
            break;
    }
} elseif ($action == 'remove') {
    // Remove the reaction
    if (reaction_remove(Cot::$usr['id'], $ext, $item)) {
        $response['success'] = true;
        $response['message'] = 'Reaction removed';
    } else {
        $response['message'] = 'No reaction found to remove';
    }
} elseif ($action == 'counts') {
    $response['success'] = true;
}

// Return updated counts for all actions
$response['counts'] = reaction_get_counts($ext, $item);
$response['user_reaction'] = reaction_get_user_reaction(Cot::$usr['id'], $ext, $item);

echo json_encode($response);
exit;