<?php

/**
 * Polish Language File for the Admin Module (admin.pl.lang.php)
 *
 * @package Cotonti
 * @version 0.9.7
 * @author Cotonti Team
 * @copyright Copyright (c) Cotonti Team 2008-2012
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL.');

/**
 * Common words
 */

$L['Extension'] = 'Rozszerzenie';
$L['Extensions'] = 'Rozszerzenia';
$L['Structure'] = 'Struktura';

/**
 * Home Section
 */

$L['home_installable_error'] = 'Proszę usunąć plik install.php do czasu następnej aktualizacji lub chronić przed zapisem';

$L['home_newusers'] = 'Nowi użytkownicy';
$L['home_newpages'] = 'Nowe strony';
$L['home_newtopics'] = 'Nowe wątki';
$L['home_newposts'] = 'Nowe posty';
$L['home_newpms'] = 'Nowe prywatne wiadomości';

$L['home_db_rows'] = 'Baza danych SQL, ilość wierszy';
$L['home_db_indexsize'] = 'Baza danych SQL, rozmiar indeksu (KB)';
$L['home_db_datassize'] = 'Baza danych SQL, rozmiar danych (KB)';
$L['home_db_totalsize'] = 'Baza danych SQL, całkowity rozmiar (KB)';

$L['home_ql_b1_title'] = 'Właściwości strony';
$L['home_ql_b1_1'] = 'Podstawowa konfiguracja';
$L['home_ql_b1_2'] = 'Tytuły';
$L['home_ql_b1_3'] = 'Skórki i kodowanie';
$L['home_ql_b1_4'] = 'Sloty menu w plikach tpl';
$L['home_ql_b1_5'] = 'Język';
$L['home_ql_b1_6'] = 'Data i czas';

$L['home_ql_b2_1'] = 'Struktura stron (kategorie)';
$L['home_ql_b2_2'] = 'Dodatkowe pola dla stron';
$L['home_ql_b2_3'] = 'Dodatkowe pola dla kategorii';
$L['home_ql_b2_4'] = 'Konfiguracja parsera';

$L['home_ql_b3_1'] = 'Podstawowa konfiguracja';
$L['home_ql_b3_2'] = 'Dodatkowe pola dla użytkowników';
$L['home_ql_b3_4'] = 'Uprawnienia';

$L['home_update_notice'] = 'Dostępna jest aktualizacja';
$L['home_update_revision'] = 'Obecna wersja: <span style="color:#C00;font-weight:bold;">%1$s</span><br />Nowa wersja: <span style="color:#4E9A06;font-weight:bold;">%2$s</span>'; // %1/%2 Current version/revision %3/%4 Updated version/revision

/**
 * Config Section
 */

$L['core_forums'] = &$L['Forums'];
$L['core_locale'] = &$L['Locale'];
$L['core_main'] = 'Ustawienia główne';
$L['core_menus'] = &$L['Menus'];
$L['core_page'] = &$L['Pages'];
$L['core_parser'] = &$L['Parser'];
$L['core_performance'] = 'Wydajność';
$L['core_pfs'] = &$L['PFS'];
$L['core_plug'] = &$L['Plugins'];
$L['core_pm'] = &$L['Private_Messages'];
$L['core_polls'] = &$L['Polls'];
$L['core_rss'] = &$L['RSS_Feeds'];
$L['core_security'] = &$L['Security'];
$L['core_structure'] = &$L['Categories'];
$L['core_theme'] = &$L['Themes'];
$L['core_time'] = 'Data i czas';
$L['core_title'] = 'Tytuły i znaczniki Meta';
$L['core_users'] = &$L['Users'];

$L['cfg_struct_defaults'] = 'Domyślna struktura';

/**
 * Shortcuts
 */
$L['short_admin'] = 'Administracja';
$L['short_config'] = 'Konfiguracja';
$L['short_delete'] = 'Usuń';
$L['short_open'] = 'Otwórz';
$L['short_options'] = 'Opcje';
$L['short_rights'] = 'Uprawnienia';
$L['short_struct'] = 'Struktura';

/**
 * Config Section
 * Locale Subsection
 */

$L['cfg_forcedefaultlang'] = array('Wymuś domyślny język dla wszystkich użytkowników', '');
$L['cfg_defaulttimezone'] = array('Domyślna strefa czasowa', 'Dla gości i nowych użytkowników, od -12 do +12');

/**
 * Config Section
 * Main Subsection
 */

$L['cfg_adminemail'] = array('Email administratora', 'Wymagany');
$L['cfg_clustermode'] = array('Klaster serwerów', ''); //poprawić
$L['cfg_confirmlinks'] = array('Potwierdzaj potencjalnie niebezpieczne czynności');
$L['cfg_devmode'] = array('Tryb debugowania', 'Nie włączać na działających stronach');
$L['cfg_easypagenav'] = array('Podział stron przyjazny dla użytkownika', 'Używa numerów stron w adresach URL zamiast przesunięcia DB');
$L['cfg_hostip'] = array('IP serwera', 'IP serwera, opcjonalne.');
$L['cfg_jquery'] = array('Włącz jQuery', '');
$L['cfg_maintenance'] = array('Tryb moderacji', 'Tylko autoryzowany personel ma dostęp do strony');
$L['cfg_maintenancereason'] = array('Powód moderacji', 'Opcjonalne, krótki opis');
$L['cfg_maxrowsperpage'] = array('Maks. ilość pozycji na stronie', 'Domyślny limit pozycji do podziału na strony');
$L['cfg_parser'] = array('Parser wprowadzanego tekstu', 'Domyślnie: zwykły tekst');
$L['cfg_redirbkonlogin'] = array('Przekierowanie po zalogowaniu', 'Przekierowanie do strony na której był użytkownik przed zalogowaniem');
$L['cfg_redirbkonlogout'] = array('Przekierowanie po wylogowaniu', 'Przekierowanie do strony na której był użytkownik przed wylogowaniem');
$L['cfg_turnajax'] = array('Włącz Ajax', 'Działa tylko przy włączonym jQuery');

/**
 * Config Section
 * Menus Subsection
 */

$L['cfg_banner'] = array('Baner<br />{HEADER_BANNER} w pliku header.tpl', '');
$L['cfg_bottomline'] = array('Stopka<br />{FOOTER_BOTTOMLINE} w pliku footer.tpl', '');
$L['cfg_topline'] = array('Nagłówek<br />{HEADER_TOPLINE} w pliku header.tpl', '');

$L['cfg_freetext1'] = array('Slot własnego tekstu #1<br />{PHP.cfg.freetext1} we wszystkich plikach tpl', '');
$L['cfg_freetext2'] = array('Slot własnego tekstu #2<br />{PHP.cfg.freetext2} we wszystkich plikach tpl', '');
$L['cfg_freetext3'] = array('Slot własnego tekstu #3<br />{PHP.cfg.freetext3} we wszystkich plikach tpl', '');
$L['cfg_freetext4'] = array('Slot własnego tekstu #4<br />{PHP.cfg.freetext4} we wszystkich plikach tpl', '');
$L['cfg_freetext5'] = array('Slot własnego tekstu #5<br />{PHP.cfg.freetext5} we wszystkich plikach tpl', '');
$L['cfg_freetext6'] = array('Slot własnego tekstu #6<br />{PHP.cfg.freetext6} we wszystkich plikach tpl', '');
$L['cfg_freetext7'] = array('Slot własnego tekstu #7<br />{PHP.cfg.freetext7} we wszystkich plikach tpl', '');
$L['cfg_freetext8'] = array('Slot własnego tekstu #8<br />{PHP.cfg.freetext8} we wszystkich plikach tpl', '');
$L['cfg_freetext9'] = array('Slot własnego tekstu #9<br />{PHP.cfg.freetext9} we wszystkich plikach tpl', '');

$L['cfg_menu1'] = array('Menu slot #1<br />{PHP.cfg.menu1} we wszystkich plikach tpl', '');
$L['cfg_menu2'] = array('Menu slot #2<br />{PHP.cfg.menu2} we wszystkich plikach tpl', '');
$L['cfg_menu3'] = array('Menu slot #3<br />{PHP.cfg.menu3} we wszystkich plikach tpl', '');
$L['cfg_menu4'] = array('Menu slot #4<br />{PHP.cfg.menu4} we wszystkich plikach tpl', '');
$L['cfg_menu5'] = array('Menu slot #5<br />{PHP.cfg.menu5} we wszystkich plikach tpl', '');
$L['cfg_menu6'] = array('Menu slot #6<br />{PHP.cfg.menu6} we wszystkich plikach tpl', '');
$L['cfg_menu7'] = array('Menu slot #7<br />{PHP.cfg.menu7} we wszystkich plikach tpl', '');
$L['cfg_menu8'] = array('Menu slot #8<br />{PHP.cfg.menu8} we wszystkich plikach tpl', '');
$L['cfg_menu9'] = array('Menu slot #9<br />{PHP.cfg.menu9} we wszystkich plikach tpl', '');

/**
 * Config Section
 * Performance Subsection
 */

$L['cfg_gzip'] = array('Gzip', 'Kompresja Gzip wyjściowego HTML-a');
$L['cfg_headrc_consolidate'] = array('Konsolidacja zasobów nagłówka i stopki (JS/CSS)');
$L['cfg_headrc_minify'] = array('Minimalizacja skonsolidowanego JS/CSS');
$L['cfg_jquery_cdn'] = array('Używaj jQuery z tego adresu URL', 'Np.: https://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js');

/**
 * Config Section
 * Security Subsection
 */

$L['cfg_captchamain'] = array('Główna captcha');
$L['cfg_captcharandom'] = array('Losowa captcha');
$L['cfg_cookiedomain'] = array('Domena dla cookies', 'Domyślnie: puste');
$L['cfg_cookielifetime'] = array('Czas życia cookies', 'W sekundach');
$L['cfg_cookiepath'] = array('Ścieżka dla cookies', 'Domyślnie: puste');
$L['cfg_referercheck'] = array('Sprawdzanie formularzy odsyłających', 'Zapobiega atakom cross-domain');
$L['cfg_shieldenabled'] = array('Włącz tarczę ochronną', 'Anty-spamowa i anty-uderzeniowa');
$L['cfg_shieldtadjust'] = array('Ustawienia mocy tarczy (w %)', 'Im wyższa, tym trudniej spamować');
$L['cfg_shieldzhammer'] = array('Anty-uderzenie po * szybkich wyświetleniach', 'Im niższe, tym szybciej zostanie nałożony auto-ban na 3 minuty');

/**
 * Config Section
 * Themes Subsection
 */

$L['cfg_charset'] = array('Kodowanie HTML', '');
$L['cfg_disablesysinfos'] = array('Wyłącz czas generowania strony', '(w pliku footer.tpl)');
$L['cfg_doctypeid'] = array('Typ dokumentu', '&lt;!DOCTYPE&gt; z nagłówka HTML');
$L['cfg_forcedefaulttheme'] = array('Wymuś domyślną skórkę dla wszystkich użytkowników', '');
$L['cfg_homebreadcrumb'] = array('Wyświetlaj Dom w nawigacji', 'Umieszcza lik do strony głównej na początku nawigacji');
$L['cfg_keepcrbottom'] = array('Zachowaj notkę o prawach autorskich w tagu {FOOTER_BOTTOMLINE}', '(w pliku footer.tpl)');
$L['cfg_metakeywords'] = array('Słowa kluczowe', '(oddzielone przecinkami)');
$L['cfg_msg_separate'] = array('Wyświetl wiadomości oddzielnie dla każdego źródła', '');
$L['cfg_separator'] = array('Domyślny separator', '(używany w nawigacji itp.)');
$L['cfg_showsqlstats'] = array('Wyświetl statystyki zapytań SQL', '(w pliku footer.tpl)');

/**
 * Config Section
 * Title Subsection
 */

$L['cfg_maintitle'] = array('Tytuł strony', 'Główny tytuł strony, wymagany');
$L['cfg_subtitle'] = array('Opis', 'Opcjonalny, będzie wyświetlany po tytule strony');
$L['cfg_title_header'] = array('Tytuł nagłówka', 'Opcje: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_header_index'] = array('Tytuł nagłówka strony głównej', 'Opcje: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_users_details'] = array('Tytuł strony ze szczegółami użytkownika', 'Opcje: {USER}, {NAME}');
$L['cfg_subject_mail'] = array('Temat emaila', 'Opcje: {SITE_TITLE}, {SITE_DESCRIPTION}, {MAIL_SUBJECT}');
$L['cfg_body_mail'] = array('Tytuł emaila', 'Opcje: {SITE_TITLE}, {SITE_DESCRIPTION}, {SITE_URL}, {ADMIN_EMAIL}, {MAIL_BODY}, {MAIL_SUBJECT}');

/**
 * Config Section
 * Users Subsection
 */

$L['cfg_forcerememberme'] = array('Wymuś &quot;pamiętaj mnie&quot;', 'Użyj go na stronach z wieloma domenami lub jeżeli występują nagłe wylogowania');
$L['cfg_timedout'] = array('Czas aktywności, w sekundach', 'Po tym okresie użytkownik będzie uznany za nieobecnego');
$L['cfg_usertextimg'] = array('Zezwól na obrazki i HTML w podpisach użytkowników', '\'Nie\' zalecane, ze względów bezpieczeństwa');

/**
 * Config Section
 * Common strings
 */
$L['cfg_css'] = array('Włącz CSS dla modułów/wtyczek');
$L['cfg_editor'] = array('Zaawansowany edytor tekstu', '');
$L['cfg_markup'] = array('Włącz znaczniki', 'Włącza HTML/BBcode lub inne parsery zainstalowane w systemie');

/**
 * Extension management
 */

$L['ext_already_installed'] = 'To rozszerzenie jest już zainstalowane: {$name}';
$L['ext_auth_installed'] = 'Zainstalowano domyślne uprawnienia';
$L['ext_auth_locks_updated'] = 'Zaktualizowano blokady uprawnień';
$L['ext_auth_uninstalled'] = 'Usunięto opcje uprawnień';
$L['ext_bindings_installed'] = 'Zainstalowano {$cnt} dowiązań do haków';
$L['ext_bindings_uninstalled'] = 'Usunięto {$cnt} dowiązań do haków';
$L['ext_config_error'] = 'Proces konfiguracji zakończony niepowodzeniem';
$L['ext_config_installed'] = 'Zainstalowano konfigurację';
$L['ext_config_uninstalled'] = 'Usunięto konfigurację';
$L['ext_config_updated'] = 'Zaktualizowano opcje konfiguracji';
$L['ext_config_struct_error'] = 'Proces konfiguracji struktury zakończony niepowodzeniem';
$L['ext_config_struct_installed'] = 'Zainstalowano konfigurację struktury';
$L['ext_config_struct_updated'] = 'Zaktualizowano opcje konfiguracji struktury';
$L['ext_dependency_error'] = '{$dep_type} &quot;{$dep_name}&quot; wymagane przez {$type} &quot;{$name}&quot; nie jest zainstalowany lub zaznaczony do instalacji';
$L['ext_dependency_uninstall_error'] = '{$type} &quot;{$name}&quot; wymaga tego rozszerzenia i musi by odinstalowane najpierw';
$L['ext_executed_php'] = 'Wykonano część obsługi dla PHP: {$ret}';
$L['ext_executed_sql'] = 'Wykonano część obsługi dla SQL: {$ret}';
$L['ext_installing'] = 'Instalacja {$type} &quot;{$name}&quot;';
$L['ext_invalid_format'] = 'To nie jest rozszerzenie dla Cotonti >= 0.9. Proszę skontaktować się z deweloperem';
$L['ext_old_format'] = 'To jest rozszerzenie dla Genoa/Seditio. Może nie działać poprawnie lub nie działać wcale.';
$L['ext_patch_applied'] = 'Zastosowano łatkę {$f}: {$msg}';
$L['ext_patch_error'] = 'Błąd podczas zastosowywania łatki {$f}: {$msg}';
$L['ext_requires_modules'] = 'Wymagane moduły';
$L['ext_requires_plugins'] = 'Wymagane wtyczki';
$L['ext_recommends_modules'] = 'Polecane moduły';
$L['ext_recommends_plugins'] = 'Polecane wtyczki';
$L['ext_setup_not_found'] = 'Plik instalacyjny nie znaleziony: {$path}';
$L['ext_uninstall_confirm'] = 'Na pewno chcesz odinstalować to rozszerzenie? Wszelkie dane powiązane z tym rozszerzeniem zostaną usunięte i nie będą mogły być odtworzone.<br/><a href="{$url}">TAK, odinstaluj i usuń dane.</a>';
$L['ext_uninstalling'] = 'Usuwanie {$type} &quot;{$name}&quot;';
$L['ext_up2date'] = '{$type} &quot;{$name}&quot; jest aktualne';
$L['ext_update_error'] = 'Błąd aktualizacji {$type} &quot;{$name}&quot;';
$L['ext_updated'] = '{$type} &quot;{$name}&quot; zostało zaktualizowane do wersji {$ver}';
$L['ext_updating'] = 'Aktualizacja {$type} &quot;{$name}&quot;';

/**
 * Extension categories 
 */
$L['ext_cat']['administration-management'] = 'Administracja i Zarządzanie';
$L['ext_cat']['commerce'] = 'Handel elektroniczny i Zakupy';
$L['ext_cat']['community-social'] = 'Społeczności';
$L['ext_cat']['customization-i18n'] = 'Personalizacja i Języki';
$L['ext_cat']['data-apis'] = 'Kanały danych i API';
$L['ext_cat']['development-maintenance'] = 'Rozbudowa i Konserwacja';
$L['ext_cat']['editor-parser'] = 'Edytory i Znaczniki';
$L['ext_cat']['files-media'] = 'PLiki i Media';
$L['ext_cat']['forms-feedback'] = 'Forms &amp; Feedback';
$L['ext_cat']['gaming-clans'] = 'Rozgrywki i Klany';
$L['ext_cat']['intranet-groupware'] = 'Intranet i Praca grupowa';
$L['ext_cat']['misc-ext'] = 'Różne';
$L['ext_cat']['mobile-geolocation'] = 'Urządzenia mobilne i Geolokacja';
$L['ext_cat']['navigation-structure'] = 'Nawigacja i Struktura';
$L['ext_cat']['performance-seo'] = 'Wydajność i SEO';
$L['ext_cat']['publications-events'] = 'Publikacje i Wydarzenia';
$L['ext_cat']['security-authentication'] = 'Bezpieczeństwo i Uwierzytelnianie';
$L['ext_cat']['utilities-tools'] = 'Narzędzia';
$L['ext_cat']['post-install'] = 'Skrypty poinstalacyjne';

/**
 * Structure Section
 */

$L['adm_cat_exists'] = 'Kategoria z podanym kodem już istnieje';
$L['adm_tpl_mode'] = 'Typ szablonu';
$L['adm_tpl_empty'] = 'Domyślny';
$L['adm_tpl_forced'] = 'Taki jak';
$L['adm_tpl_parent'] = 'Taki jak kategoria nadrzędna';
$L['adm_tpl_quickcat'] = 'Własny kod kategorii';
$L['adm_tpl_resyncalltitle'] = 'Przelicz wszystkie liczniki strony';
$L['adm_tpl_resynctitle'] = 'Przelicz wszystkie liczniki kategorii';
$L['adm_help_structure'] = 'Strony należące do kategorii &quot;system&quot; nie będą wyświetlane w listingach, służą do tworzenia samodzielnych stron.';

/**
 * Structure Section
 * Extrafields Subsection
 */

$L['adm_extrafields_desc'] = 'Dodaj/Zmień dodatkowe pola';
$L['adm_extrafields_all'] = 'Wyświetl wszystkie tabele z bazy danych';
$L['adm_extrafields_table'] = 'Tabela';
$L['adm_extrafields_help_notused'] = 'nie używany';
$L['adm_extrafields_help_variants'] = '{wariant1},{wariant2},{wariant3},...';
$L['adm_extrafields_help_range'] = '{min_wartość},{max_wartość}';
$L['adm_extrafields_help_data'] = '{min_rok},{max_rok},{format_daty}. Jeśli pusty {format_daty}, będzie użyty znacznik czasu';
$L['adm_extrafields_help_regex'] = 'Wyrażenie regularne do sprawdzenia';
$L['adm_extrafields_help_file'] = 'Katalog przesyłania pliku';
$L['adm_extrafields_help_separator'] = 'Separator';
$L['adm_help_info'] = '<b>Bazowy HTML</b> ustawiany automatycznie, jeśli pole pozostanie puste';
$L['adm_help_newtags'] = '<br /><br /><bNowe tagi w plikach tpl:</b>';

/**
 * Users Section
 */

$L['adm_rightspergroup'] = 'Uprawnienia dla grup';
$L['adm_maxsizesingle'] = 'Maks. rozmiar pojedynczego pliku w '.$L['PFS'].' (KB)';
$L['adm_maxsizeallpfs'] = 'Maks. rozmiar wszystkich plików w '.$L['PFS'].' (KB)';
$L['adm_copyrightsfrom'] = 'Ustaw takie same uprawnienia jak dla grupy';
$L['adm_rights_maintenance'] = 'Dostęp do strony w trybie moderacji';
$L['adm_skiprights'] = 'Pomiń uprawnienia dla tej grupy';

/**
 * Plug Section
 */

$L['adm_defauth_guests'] = 'Domyślne uprawnienia dla gości';
$L['adm_deflock_guests'] = 'Maska blokad dla gości';
$L['adm_defauth_members'] = 'Domyślne uprawnienia dla użytkowników';
$L['adm_deflock_members'] = 'Maska blokad dla użytkowników';

$L['adm_present'] = 'Obecne';
$L['adm_missing'] = 'Brak';
$L['adm_paused'] = 'Pauza';
$L['adm_running'] = 'Włączone';
$L['adm_partrunning'] = 'Częściowo włączone';
$L['adm_partstopped'] = 'Częściowo zatrzymane';
$L['adm_installed'] = 'Zainstalowane';
$L['adm_notinstalled'] = 'Nie zainstalowane';

$L['adm_plugsetup'] = 'Instalacja wtyczki';
$L['adm_override_guests'] = 'Nadpisanie wart. systemowych, goście i nieaktywni nie mają możliwości administracji';
$L['adm_override_banned'] = 'Nadpisanie wart. systemowych, Zbanowani';
$L['adm_override_admins'] = 'Nadpisanie wart. systemowych, Administratorzy';

$L['adm_opt_install'] = 'Instaluj';
$L['adm_opt_install_explain'] = 'Ta opcja wykona nową instalację rozszerzenia';
$L['adm_opt_pause'] = 'Pauzuj';
$L['adm_opt_pauseall'] = 'Pauzuj wszystko';
$L['adm_opt_pauseall_explain'] = 'Ta opcja zatrzyma (wyłączy) wszystkie części rozszerzenia.';
$L['adm_opt_update'] = 'Uaktualnij';
$L['adm_opt_update_explain'] = 'Ta opcja uaktualni konfigurację i dane rozszerzenia, jeżeli pliki rozszerzenia zostały uaktualnione na dysku';
$L['adm_opt_uninstall'] = 'Odinstaluj';
$L['adm_opt_uninstall_explain'] = 'Ta opcja wyłączy wszystkie części rozszerzenia, oraz usunie wszelkie dane i konfigurację, ale nie usunie fizycznie plików.';
$L['adm_opt_unpause'] = 'Odpauzuj';
$L['adm_opt_unpauseall'] = 'Odpauzuj wszystko';
$L['adm_opt_unpauseall_explain'] = 'Ta opcja odpauzuje (włączy) wszystkie części rozszerzenia.';

$L['adm_opt_setup_missing'] = 'Błąd: brak pliku instalacyjnego!';

$L['adm_sort_alphabet'] = 'Alfabetycznie';
$L['adm_sort_category'] = 'Widok kategorii';

/**
 * Tools Section
 */

$L['adm_listisempty'] = 'Lista jest pusta';

/**
 * Other Section
 * Cache Subsection
 */

$L['adm_delcacheitem'] = 'Pozycja usunięta z pamięci podręcznej';
$L['adm_internalcache'] = 'Wewnętrzna pamięć podręczna';
$L['adm_purgeall_done'] = 'Pamięć podręczna wyczyszczona';
$L['adm_diskcache'] = 'Dyskowa pamięć podręczna';
$L['adm_cache_showall'] = 'Wyświetl wszystko';

/**
 * Other Section
 * Log Subsection
 */

$L['adm_log'] = 'Logi systemowe';
$L['adm_infos'] = 'Informacje';
$L['adm_versiondclocks'] = 'Wersje i zegary';
$L['adm_checkcorethemes'] = 'Sprawdź pliki systemowe i skórki';
$L['adm_checkcorenow'] = 'Sprawdź pliki systemowe teraz!';
$L['adm_checkingcore'] = 'Sprawdzanie plików systemowych...';
$L['adm_checkthemes'] = 'Sprawdź, czy wszystkie pliki skórki są obecne';
$L['adm_checktheme'] = 'Sprawdź pliki TPL dla skórki';
$L['adm_checkingtheme'] = 'Sprawdzanie skórki...';
$L['adm_check_ok'] = 'Ok';
$L['adm_check_missing'] = 'Brak';

/**
 * Other Section
 * Infos Subsection
 */

$L['adm_phpver'] = 'Wersja silnika PHP';
$L['adm_zendver'] = 'Wersja silnika Zend';
$L['adm_interface'] = 'Interfejs pomiędzy serwerem a PHP';
$L['adm_cachedrivers'] = 'Sterowniki pamięci podręcznej';
$L['adm_os'] = 'System operacyjny';
$L['adm_clocks'] = 'Zegary';
$L['adm_time1'] = '#1: Czas serwera';
$L['adm_time2'] = '#2: Czas GMT zwrócony przez serwer';
$L['adm_time3'] = '#3: Czas GMT + przesunięcie serwera (ustawiony w Cotonti)';
$L['adm_time4'] = '#4: Twój czas lokalny, ustawiony w Twoim profilu';
$L['adm_help_versions'] = 'Ustaw strefę czasową serwera, aby mieć dobrze ustawiony zegar #3.<br />
Zegar #4 zależ od ustawień w Twoim profilu.<br />
Zegary #1 i #2 są ignorowane przez Cotonti.';

/**
 * Common Entries
 */

$L['adm_area'] = 'Strefa';
$L['adm_clicktoedit'] = '(Kliknij aby zmienić)';
$L['adm_confirm'] = 'Kliknij ten przycisk aby potwierdzić: ';
$L['adm_done'] = 'Gotowe';
$L['adm_failed'] = 'Nieudane';
$L['adm_from'] = 'Od';
$L['adm_more'] = 'Więcej narzędzi...';
$L['adm_purgeall'] = 'Wyczyść wszystko';
$L['adm_queue_unvalidated'] = 'Nie zaakceptowane';
$L['adm_queue_validated'] = 'Zaakceptowane';
$L['adm_required'] = '(Wymagane)';
$L['adm_setby'] = 'Ustawione przez';
$L['adm_to'] = 'Do';
$L['adm_totalsize'] = 'Całkowity rozmiar';
$L['adm_warnings'] = 'Ostrzeżenia';

$L['editdeleteentries'] = 'Zmień lub usuń wpisy';
$L['viewdeleteentries'] = 'Wyświetl lub usuń wpisy';

$L['alreadyaddnewentry'] = 'Nowy wpis dodany';
$L['alreadyupdatednewentry'] = 'Wpis zmieniony';
$L['alreadydeletednewentry'] = 'Wpis usunięty';

/**
 * Extra Fields (Common Entries for Pages & Structure & Users)
 */

$L['adm_extrafields'] = 'Dodatkowe pola';
$L['adm_extrafield_added'] = 'Pomyślnie dodano nowe dodatkowe pole.';
$L['adm_extrafield_not_added'] = 'Błąd! Nowe dodatkowe pole nie zostało dodane.';
$L['adm_extrafield_updated'] = 'Pomyślnie zmieniono dodatkowe pole - \'%1$s\'.';
$L['adm_extrafield_not_updated'] = 'Błąd! Dodatkowe pole \'%1$s\' nie zostało zmienione.';
$L['adm_extrafield_removed'] = 'Pomyślnie usunięto dodatkowe pole.';
$L['adm_extrafield_not_removed'] = 'Błąd! Dodatkowe pole nie zostało usunięte.';
$L['adm_extrafield_confirmdel'] = 'Na pewno chcesz usunąć to dodatkowe pole? Wszelkie dane powiązane z tym polem zostaną usunięte!';
$L['adm_extrafield_confirmupd'] = 'Na pewno chcesz zmienić to dodatkowe pole? Część danych powiązanych z tym polem może zostać usunięta!';
$L['adm_extrafield_default'] = 'Domyślna wartość';
$L['adm_extrafield_required'] = 'Pole wymagane';
$L['adm_extrafield_parse'] = 'Parser';
$L['adm_extrafield_enable'] = 'Włącz pole';
$L['adm_extrafield_params'] = 'Parametry pola';

$L['extf_Name'] = 'Nazwa';
$L['extf_Type'] = 'Typ pola';
$L['extf_Base_HTML'] = 'Bazowy HTML';
$L['extf_Page_tags'] = 'Tagi';
$L['extf_Description'] = 'Opis (_TITLE)';

$L['adm_extrafield_new'] = 'Nowe dodatkowe pole';
$L['adm_extrafield_noalter'] = 'Nie dodawaj pola do bazy danych, zarejestruj tylko jako dodatkowe';
$L['adm_extrafield_selectable_values'] = 'Opcje dla select, radio i checklistbox (oddziel. przecin.)';
$L['adm_help_extrafield'] = 'Wskazówka: Pole &quot;Bazowy HTML&quot; jest stawiany automatycznie, jeżeli pole pozostanie puste.';

/**
 * Help messages that still don't work
 */

$L['adm_help_cache'] = 'Niedostępne';
$L['adm_help_check1'] = 'Niedostępne';
$L['adm_help_check2'] = 'Niedostępne';
$L['adm_help_config']= 'Niedostępne';

?>