<?PHP

/* ====================
Seditio - Website engine
Copyright Neocrome
http://www.neocrome.net
[BEGIN_SED]
File=plugins/faq/inc/install.php
Version=2.5
Updated=2008-Apr-21
Type=Plugin
Author=T3-Design
Description=T3 Faq Install
[END_SED]
==================== */

if (!defined('SED_CODE')) { die('Wrong URL.'); }

function T3_FAQ_SETUP($core)
{
	global $db_faq_cats, $db_faq_quest, $db_faq_parsed, $db_auth, $sed_groups, $db_stats;

	switch($core) // States the current version and updates to the next case 2.2b will update to 2.2d
	{
	case '2.2d':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest CHANGE faq_question faq_question varchar(255) default NULL");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats ADD faq_cat_total INT(10) UNSIGNED NOT NULL DEFAULT '0'");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD faq_comments INT(10) UNSIGNED NOT NULL DEFAULT '0'");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD faq_ratings DECIMAL(5,2) UNSIGNED NOT NULL DEFAULT '0.00'");
	
	$sql = sed_sql_query("CREATE TABLE $db_faq_parsed (
						answer_id INT(11) UNSIGNED NOT NULL DEFAULT '0',
						answer_html TEXT NOT NULL ,
						PRIMARY KEY (answer_id)
						) TYPE = MyISAM");
	
	/* Rebuild Or Add Fulltext index */			
	$sql = @mysql_query("ALTER TABLE $db_faq_quest DROP INDEX faq_question");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD FULLTEXT(faq_question)");
	/* Rebuild Or Add Fulltext index */	
	
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD INDEX (faq_comments)");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD INDEX (faq_ratings)");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD INDEX (faq_views)");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD INDEX (faq_date)");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD INDEX (faq_cat_id)"); 
	$sql = sed_sql_query("INSERT INTO $db_stats (stat_name, stat_value) VALUES ('t3faq_ver', '250')");
	
	faq_update_comments();
	faq_update_rating();
	faq_update_counters('all');
	sed_cache_clearall();
	break;	

	case '2.2c':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD FULLTEXT(faq_question)");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest CHANGE faq_question faq_question varchar(255) default NULL");
	break;	

	case '2.2b':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest CHANGE faq_updated_flag faq_edit_flag tinyint(1) NOT NULL default '0'");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_asked_flag tinyint(1) NOT NULL default '0' AFTER faq_edit_flag");
	$sql = sed_sql_query("UPDATE $db_faq_quest SET faq_authorid=1 WHERE faq_authorid=0");
	break;			
		
	case '2.2a':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_views mediumint(8) unsigned default '0' AFTER faq_state");
	break;	

	case '2.1':
	$sql = sed_sql_query("DELETE FROM $db_auth WHERE auth_code = 'faq'"); // just in case //
	$sql_get_faq_cats = sed_sql_query("SELECT faq_cat_id FROM $db_faq_cats ORDER BY faq_cat_id ASC");
	while ($row = sed_sql_fetcharray($sql_get_faq_cats))
	{
		foreach($sed_groups as $k => $v)
		{
			if ($v['id']==1 || $v['id']==2)
			{
				$ins_auth = 1;
				$ins_lock = 254;
			}
			elseif ($v['id']==3)
			{
				$ins_auth = 0;
				$ins_lock = 255;
			}
			elseif ($v['id']==5)
			{
				$ins_auth = 255;
				$ins_lock = 255;
			}
			else
			{
				$ins_auth = 3;
				$ins_lock = ($k==4) ? 128 : 0;
			}	
			$sql = sed_sql_query("INSERT into $db_auth 
					(auth_groupid, 
					auth_code, 
					auth_option, 
					auth_rights, 
					auth_rights_lock, 
					auth_setbyuserid) VALUES (".(int)$v['id'].", 
					'faq', 
					'".(int)$row['faq_cat_id']."', 
					".(int)$ins_auth.", 
					".(int)$ins_lock.", 
					1)");
		}
	}
	sed_auth_reorder();
	sed_auth_clear('all');
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_alias varchar(24) NOT NULL default '' AFTER faq_answer");	
	break;

	case '2.0':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_updated_flag tinyint(1) NOT NULL default '0' AFTER faq_type");
	break;

	case '1.0.x':
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest CHANGE faq_cat_id faq_cat_id INT( 11 ) UNSIGNED NULL DEFAULT NULL");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats CHANGE faq_cat_id faq_cat_id INT( 11 ) UNSIGNED NOT NULL AUTO_INCREMENT");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats CHANGE faq_parentid faq_parentid INT( 11 ) UNSIGNED NOT NULL DEFAULT '0'");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_type tinyint(1) NOT NULL default '0' AFTER faq_answer");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_state tinyint(1) unsigned NOT NULL default '0' AFTER faq_order");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_date int(11) NOT NULL default '0' AFTER faq_answer");
	$sql = sed_sql_query("ALTER TABLE $db_faq_quest ADD COLUMN faq_authorid int(11) NOT NULL default '0' AFTER faq_answer");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats ADD COLUMN faq_cat_path varchar(64) NOT NULL default '1' AFTER faq_cat_icon");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats DROP faq_parentid");
	$sql = sed_sql_query("ALTER TABLE $db_faq_cats DROP faq_cat_order");
	$sql = sed_sql_query("UPDATE $db_faq_quest SET faq_type=1 WHERE faq_type=0");
	break;

	case 'new':
	$sql = sed_sql_query("CREATE TABLE IF NOT EXISTS sed_faq_cats (
						  faq_cat_id int(11) unsigned NOT NULL auto_increment,
						  faq_cat_title varchar(64) default NULL,
						  faq_cat_desc varchar(255) default NULL,
						  faq_cat_icon varchar(128) default NULL,
						  faq_cat_path varchar(64) NOT NULL default '1',
						  faq_cat_total int(10) unsigned NOT NULL default '0',
						  PRIMARY KEY  (faq_cat_id)
						  ) TYPE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");

	$sql = sed_sql_query("CREATE TABLE IF NOT EXISTS sed_faq_parsed (
						  answer_id int(11) unsigned NOT NULL default '0',
						  answer_html text NOT NULL,
						  PRIMARY KEY  (answer_id)
						  ) TYPE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");

	$sql = sed_sql_query("CREATE TABLE IF NOT EXISTS sed_faq_quest (
						  faq_id int(11) unsigned NOT NULL auto_increment,
						  faq_cat_id int(11) unsigned default NULL,
						  faq_question varchar(255) default NULL,
						  faq_answer text,
						  faq_alias varchar(24) NOT NULL default '',
						  faq_authorid int(11) NOT NULL default '0',
						  faq_date int(11) NOT NULL default '0',
						  faq_type tinyint(1) NOT NULL default '0',
						  faq_edit_flag tinyint(1) NOT NULL default '0',
						  faq_asked_flag tinyint(1) NOT NULL default '0',
						  faq_order smallint(5) NOT NULL default '0',
						  faq_state tinyint(1) unsigned NOT NULL default '0',
						  faq_views mediumint(8) unsigned default '0',
						  faq_comments int(10) unsigned NOT NULL default '0',
						  faq_ratings decimal(5,2) unsigned NOT NULL default '0.00',
						  PRIMARY KEY  (faq_id),
						  KEY faq_comments (faq_comments),
						  KEY faq_ratings (faq_ratings),
						  KEY faq_views (faq_views),
						  KEY faq_date (faq_date),
						  KEY faq_cat_id (faq_cat_id),
						  FULLTEXT KEY faq_question (faq_question)
						  ) TYPE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
						  
	$sql = sed_sql_query("INSERT INTO $db_stats (stat_name, stat_value) VALUES ('t3faq_ver', '250')");
	break;

	default:
		//MAYBE die(); i have to think about it// 
	break;
	}
	
	force_settings_update();						
	header("Location: admin.php?m=tools&p=faq");
	exit;
}
?>