<?php
/**
 * Personal File Storage, main usage script.
 *
 * @package pfs
 * @version 0.9.12
 * @author Cotonti Team && Dragonzap Team
 * @copyright Copyright (c) 2008-2012 Cotonti Team
 * @license BSD License
 */

defined('COT_CODE') or die('Wrong URL');

$id = cot_import('id','G','INT');			// id (delete file/folder) id
$type = cot_import('t','G','ALP');			// edit type ***
$f = cot_import('f','G','INT');				// folder id
$c1 = cot_import('c1','G','ALP');			// form name
$c2 = cot_import('c2','G','ALP');			// input name
$parser = cot_import('parser', 'G', 'ALP');		// custom parser
$userid = cot_import('userid','G','INT');		// User ID or 0
$gd_supported = array('jpg', 'jpeg', 'png', 'gif');

list($pg, $d, $durl) = cot_import_pagenav('d', $cfg['pfs']['maxpfsperpage']);   // Page number files
//list($pgf, $df) = cot_import_pagenav('df', $cfg['pfs']['maxpfsperpage']);   // page number folders

list($usr['auth_read'], $usr['auth_write'], $usr['isadmin']) = cot_auth('pfs', 'a');
cot_block($usr['auth_read']);

$sys['parser'] = empty($parser) ? $cfg['parser'] : $parser;

$pn_c1 = empty($c1) ? '' : '&c1=' . $c1;
$pn_c2 = empty($c2) ? '' : '&c2=' . $c2;

if (!$usr['isadmin'] || $userid=='')
{
	$userid = $usr['id'];
}
else
{
	$more = 'userid='.$userid;
}

$type = (empty($type) || empty($id)) ? '' : $type;	// none | editfolder | editfile | view
//$userid = (empty($userid)) ? 0 : $userid; // NEW

//$files_count = 0;
//$folders_count = 0;
$standalone = FALSE;
$user_info = cot_userinfo($userid);

$pfs_base_href = $sys['abs_url'];
$pfs_dir_user = cot_pfs_path($userid);
$thumbs_dir_user = cot_pfs_thumbpath($userid);
$rel_dir_user = cot_pfs_relpath($userid);

$sql_pfs_max = $db->query("
	SELECT
		MAX(grp_pfs_maxfile) AS maxfile,
		SUM(grp_pfs_maxtotal) AS maxtotal
	FROM $db_groups
	WHERE grp_id IN (
		SELECT gru_groupid
		FROM $db_groups_users
		WHERE gru_userid = $userid
	)
")->fetch();

$maxfile = min((int)$sql_pfs_max['maxfile'], cot_get_uploadmax()) * 1024; // KiB -> Bytes
$maxtotal = (int)$sql_pfs_max['maxtotal'] * 1024; // KiB -> Bytes

//cot_block(($maxfile > 0 && $maxtotal > 0) || $usr['isadmin']);

if (!empty($c1) || !empty($c2))
{
	$more .= empty($more) ? 'c1='.$c1.'&c2='.$c2 : '&c1='.$c1.'&c2='.$c2;
	if (!empty($parser))
	{
		$more .= '&parser='.$parser;
	}
	$standalone = TRUE;
}

foreach ($cot_extensions as $k => $line)
{
	$icon[$line[0]] = cot_rc('pfs_icon_type', array('type' => $line[2], 'name' => $line[1]));
	$filedesc[$line[0]] = $line[1];
}

$L['pfs_title'] = ($userid==0) ? $L['SFS'] : $L['pfs_title'];
$title[] = array(cot_url('pfs', $more), $L['pfs_title']);

if ($userid!=$usr['id'])
{
	($userid == 0) || $title[] = array(cot_url('users', 'm=details&id='.$user_info['user_id']), $user_info['user_name']);
}

/* === Hook === */
foreach (cot_getextplugins('pfs.first') as $pl)
{
	include $pl;
}
/* ===== */

$u_totalsize=0;
$sql_pfs_totalsize = $db->query("SELECT SUM(pfs_size) FROM $db_pfs WHERE pfs_userid=$userid ");
$pfs_totalsize = $sql_pfs_totalsize->fetchColumn();

$err_msg = array();

if ($a=='upload')
{
	cot_block($usr['auth_write']);
	$folderid = cot_import('folderid','P','INT');
	$ndesc = cot_import('ndesc','P','ARR');

	/* === Hook === */
	foreach (cot_getextplugins('pfs.upload.first') as $pl)
	{
		include $pl;
	}
	/* ===== */

	if (!empty($folderid))
	{
		$sql_pfs_pff = $db->query("SELECT pff_id FROM $db_pfs_folders WHERE pff_userid=$userid AND pff_id=$folderid");
		cot_die($sql_pfs_pff->rowCount()==0);
	}

	for ($ii = 0; $ii < $cfg['pfs']['pfsmaxuploads']; $ii++)
	{
		$disp_errors = '';
		$u_tmp_name = $_FILES['userfile']['tmp_name'][$ii];
		$u_type = $_FILES['userfile']['type'][$ii];
		$u_name = $_FILES['userfile']['name'][$ii];
		$u_size = $_FILES['userfile']['size'][$ii];
		$u_name  = str_replace("\'",'',$u_name );
		$u_name  = trim(str_replace("\"",'',$u_name ));

		if (!empty($u_name))
		{
			$disp_errors .= $u_name . ' : ';
			$u_name = mb_strtolower($u_name);
			$dotpos = mb_strrpos($u_name,".")+1;
			$f_extension = mb_substr($u_name, $dotpos);
			$f_extension_ok = 0;
			$desc = $ndesc[$ii];
			if($cfg['pfs']['pfstimename'])
			{
				$u_newname = time() . '_' . cot_unique(6) . '_' . $userid . '.' . $f_extension;
			}
			else
			{
				$u_newname = cot_safename($u_name, true, '_' . $userid);
			}
			$u_sqlname = $db->prep($u_newname);

			if ($f_extension!='php' && $f_extension!='php3' && $f_extension!='php4' && $f_extension!='php5')
			{
				foreach ($cot_extensions as $k => $line)
				{
					if (mb_strtolower($f_extension) == $line[0])
					{ $f_extension_ok = 1; }
				}
			}

			if (is_uploaded_file($u_tmp_name) && $u_size>0 && $u_size<$maxfile && $f_extension_ok && ($pfs_totalsize+$u_size)<$maxtotal)
			{
				$fcheck = cot_file_check($u_tmp_name, $u_name, $f_extension);
				if($fcheck == 1)
				{
					if (!file_exists($pfs_dir_user.$u_newname))
					{
						$is_moved = true;

						if ($cfg['pfs']['pfsuserfolder'])
						{
							if (!is_dir($pfs_dir_user))
							{ $is_moved &= mkdir($pfs_dir_user, $cfg['dir_perms']); }
							if (!is_dir($thumbs_dir_user))
							{ $is_moved &= mkdir($thumbs_dir_user, $cfg['dir_perms']); }
						}

						$is_moved &= move_uploaded_file($u_tmp_name, $pfs_dir_user.$u_newname);
						$is_moved &= chmod($pfs_dir_user.$u_newname, $cfg['file_perms']);

						$u_size = filesize($pfs_dir_user.$u_newname);

						if ($is_moved && (int)$u_size > 0)
						{
							/* === Hook === */
							foreach (cot_getextplugins('pfs.upload.moved') as $pl)
							{
								include $pl;
							}
							/* ===== */

							$db->insert($db_pfs, array(
								'pfs_userid' => (int)$userid,
								'pfs_date' => (int)$sys['now'],
								'pfs_file' => $u_sqlname,
								'pfs_extension' => $f_extension,
								'pfs_folderid' => (int)$folderid,
								'pfs_desc' => $desc,
								'pfs_size' => (int)$u_size,
								'pfs_count' => 0
								));
							
							$db->update($db_pfs_folders, array('pff_updated' => $sys['now']), 'pff_id="'.$folderid.'"');

							$disp_errors .= $L['Yes'];
							$pfs_totalsize += $u_size;

							/* === Hook === */
							foreach (cot_getextplugins('pfs.upload.done') as $pl)
							{
								include $pl;
							}
							/* ===== */

							if (in_array($f_extension, $gd_supported) && $cfg['pfs']['th_amode']!='Disabled' && file_exists($pfs_dir_user.$u_newname))
							{
								@unlink($thumbs_dir_user.$u_newname);
								$th_colortext = array(hexdec(substr($cfg['pfs']['th_colortext'],0,2)), hexdec(substr($cfg['pfs']['th_colortext'],2,2)), hexdec(substr($cfg['pfs']['th_colortext'],4,2)));
								$th_colorbg = array(hexdec(substr($cfg['pfs']['th_colorbg'],0,2)), hexdec(substr($cfg['pfs']['th_colorbg'],2,2)), hexdec(substr($cfg['pfs']['th_colorbg'],4,2)));
								cot_imageresize($pfs_dir_user . $u_newname, $thumbs_dir_user  . $u_newname,
									$cfg['pfs']['th_x'], $cfg['pfs']['th_y'], 'fit', $th_colorbg,
									$cfg['pfs']['th_jpeg_quality'], true);
							}
						}
						else
						{
							@unlink($pfs_dir_user.$u_newname);
							$disp_errors .= $L['pfs_filenotmoved'];
						}
					}
					else
					{
						$disp_errors .= $L['pfs_fileexists'];
					}
				}
				elseif($fcheck == 2)
				{
					$disp_errors .= sprintf($L['pfs_filemimemissing'], $f_extension);
				}
				else
				{
					$disp_errors .= sprintf($L['pfs_filenotvalid'], $f_extension);
				}
			}
			else
			{
				$disp_errors .= $L['pfs_filetoobigorext'];
			}
			$err_msg[] = $disp_errors;
		}
	}
}
elseif ($a=='delete')
{
	cot_block($usr['auth_write']);
	cot_check_xg();
	$sql_pfs_delete = $db->query("SELECT pfs_file, pfs_folderid FROM $db_pfs WHERE pfs_userid=$userid AND pfs_id=$id LIMIT 1");

	if ($row = $sql_pfs_delete->fetch())
	{
		$pfs_file = $row['pfs_file'];
		$f = $row['pfs_folderid'];
		$ff = $pfs_dir_user.$pfs_file;

		if (file_exists($ff))
		{
			@unlink($ff);
			if (file_exists($thumbs_dir_user.$pfs_file))
			{
				@unlink($thumbs_dir_user.$pfs_file);
			}
		}
		$sql_pfs_delete = $db->delete($db_pfs, "pfs_id='".(int)$id."'");
	}
}
elseif ($a=='newfolder')
{
	cot_block($usr['auth_write']);
	$ntitle = cot_import('ntitle','P','TXT');
	$ndesc = cot_import('ndesc','P','TXT');
	$nispublic = cot_import('nispublic','P','BOL');
	$nisgallery = cot_import('nisgallery','P','BOL');
	$ntitle = (empty($ntitle)) ? '???' : $ntitle;

	$db->insert($db_pfs_folders, array(
		'pff_userid' => (int)$userid,
		'pff_title' => $ntitle,
		'pff_date' => (int)$sys['now'],
		'pff_updated' => (int)$sys['now'],
		'pff_desc' => $ndesc,
		'pff_ispublic' => (int)$nispublic,
		'pff_isgallery' => (int)$nisgallery,
		'pff_count' => 0,
		'pff_parent' => (int)$f// NEW
	));
		
	cot_redirect(cot_url('pfs', 'f='.$f.'&'.$more, '', true));
}
elseif ($a=='deletefolder') // NEW
{
	cot_block($usr['auth_write']);
	cot_check_xg();
	$sql_pfs_delete = $db->delete($db_pfs_folders, "pff_userid=$userid AND pff_id=$id");
	// Remove all contained files
	$pfs_res = $db->query("SELECT pfs_file, pfs_folderid FROM $db_pfs WHERE pfs_userid=$userid AND pfs_folderid=$id");
	foreach ($pfs_res->fetchAll() as $row)
	{
		$pfs_file = $row['pfs_file'];
		$ff = $pfs_dir_user.$pfs_file;

		if (file_exists($ff))
		{
			@unlink($ff);
			if (file_exists($thumbs_dir_user.$pfs_file))
			{
				@unlink($thumbs_dir_user.$pfs_file);
			}
		}
	}
	$db->delete($db_pfs, "pfs_userid=$userid AND pfs_folderid=$id");
}
elseif ($a=='updatefolder' && !empty($f)) // NEW
{
	$rtitle = cot_import('rtitle','P','TXT');
	$rdesc = cot_import('rdesc','P','TXT');
	$folderid = cot_import('folderid','P','INT');
	$rispublic = (int) cot_import('rispublic','P','BOL');
	$risgallery = (int) cot_import('risgallery','P','BOL');
	$sql_pfs_pffcount = $db->query("SELECT pff_id FROM $db_pfs_folders WHERE pff_userid=$userid AND pff_id=$f");
	cot_die($sql_pfs_pffcount->rowCount()==0);

	$sql_pfs_update = $db->query("UPDATE $db_pfs_folders SET
		pff_title='".$db->prep($rtitle)."',
		pff_updated='".$sys['now']."',
		pff_desc='".$db->prep($rdesc)."',
		pff_ispublic=$rispublic,
		pff_isgallery=$risgallery
		WHERE pff_userid=$userid AND pff_id=$f" );

	cot_redirect(cot_url('pfs', $more, '', true));
}
elseif ($a=='updatefile' && !empty($id)) // NEW
{
	$rdesc = cot_import('rdesc','P','TXT');
	if ($f>0)
	{
		$sql_pfs_pffcount = $db->query("SELECT pff_id FROM $db_pfs_folders WHERE pff_userid=$userid AND pff_id=$f");
		cot_die($sql_pfs_pffcount->rowCount()==0);
	}
	else {
		$f = 0;
	}

	$sql_pfs_update = $db->query("UPDATE $db_pfs SET
		pfs_desc='".$db->prep($rdesc)."',
		pfs_folderid=$f
		WHERE pfs_userid=$userid AND pfs_id=$id");

	cot_redirect(cot_url('pfs', "f=$f&".$more, '', true));
}

$f = (empty($f)) ? 0 : $f;


$title = ($userid==0) ? $L['SFS'] : $L['pfs_title']; // NEW
$item_count = 0; // NEW
if ($f>0)
{
	$sql = $db->query("SELECT * FROM $db_pfs_folders WHERE pff_id=$f");
	if ($row = $sql->fetch())
	{
		$title = $row['pff_title'];
		$subtitle = $row['pff_desc'];
		
		$out['subtitle'] = $title;
		if (!$standalone) require_once $cfg['system_dir'] . '/header.php';
		$mskin = ($standalone) ? cot_tplfile(array('pfs', 'standalone')) : cot_tplfile('pfs');
		$t = new XTemplate($mskin);
						
		if ($row['pff_userid'] == $userid) /* Back */
		{			
			$t->assign(array(
				'PFF_ROW_TITLE' => $L['Fold'],
				'PFF_ROW_COUNT' => '0',
				'PFF_ROW_DELETE_URL' => '',
				'PFF_ROW_EDIT_URL' => '',
				'PFF_ROW_URL' => cot_url('pfs', 'f='.$row['pff_parent'].'&'.$more),
				'PFF_ROW_ICON' => $R['icon_undo']
			));
			$t->parse('MAIN.PFF_ROW');
			$item_count += 1;
		}
		elseif ($row['pff_ispublic'] == 1)
		{
			$count = (INT)$row['pff_count'] + 1;
			$sql_pfs_update = $db->query("UPDATE $db_pfs_folders SET pff_count=$count WHERE pff_id=$f" );
		}
		else
		{ cot_die(); }
	}
	else
	{ cot_die(); }
}

if (empty($t))
{
	$out['subtitle'] = $title;
	if (!$standalone) require_once $cfg['system_dir'] . '/header.php';
	$mskin = ($standalone) ? cot_tplfile(array('pfs', 'standalone')) : cot_tplfile('pfs');
	$t = new XTemplate($mskin);
}

if ($type=='editeditfolder') // NEW
{
	$sql = $db->query("SELECT * FROM $db_pfs_folders WHERE pff_id=$id AND pff_userid=$userid");
	if ($row = $sql->fetch())
	{
		$f = $row['pff_parent'];
	}
	else
	{ $type = ''; }
	$sql->closeCursor();
}
else if ($type=='editfile') // NEW
{
	$sql = $db->query("SELECT * FROM $db_pfs WHERE pfs_id=$id AND pfs_userid=$userid");
	if ($row = $sql->fetch())
	{
		$f = $row['pfs_folderid'];
	}
	else
	{ $type = ''; }
	$sql->closeCursor();
}

/* Counter */
$sql = $db->query("SELECT * FROM $db_pfs_folders WHERE (pff_userid=$userid OR pff_ispublic=1) AND pff_parent=$f ORDER BY pff_isgallery ASC, pff_title ASC");
$tile_all = $sql->rowCount();

/* Folders */
$sql = $db->query("SELECT * FROM $db_pfs_folders WHERE (pff_userid=$userid OR pff_ispublic=1) AND pff_parent=$f ORDER BY pff_isgallery ASC, pff_title ASC LIMIT $d, ".$cfg['pfs']['maxpfsperpage']);
foreach ($sql->fetchAll() as $row)
{
	$sql2 = $db->query("SELECT pfs_file AS pfs_firstimg, 
		(SELECT pfs_file FROM $db_pfs WHERE (pfs_extension='jpg' OR pfs_extension='png' OR pfs_extension='gif') AND pfs_folderid='".$row['pff_id']."' ORDER BY RAND() LIMIT 1) AS pfs_randimg 
		FROM $db_pfs WHERE pfs_folderid='".$row['pff_id']."' ORDER BY pfs_id ASC LIMIT 1");
	
	$gallery = true;
	if (!$row['pff_isgallery'])
	{
		$gallery = false;
	}
	
	$row2 = $sql2->fetch();

	$path = ($cfg['pfsuserfolder']) ? $row['pff_userid'].'/'.$row['pff_path'].'/' : '';
	$pff_id = $row['pff_id'];
	$pff_title = $row['pff_title'];
	$pff_desc = $row['pff_desc'];
	$pff_ispublic = $row['pff_ispublic'];
	$pff_isgallery = $row['pff_isgallery'];
	$pff_count = $row['pff_count'];
	$pff_fcount = $pff_filescount[$pff_id];
	$pff_fsize = floor($pff_filessize[$pff_id]/1024);
	$pff_fcount = (empty($pff_fcount)) ? "0" : $pff_fcount;
	$pff_fssize = (empty($pff_fsize)) ? "0" : $pff_fsize;
	$icon_f = ($gallery && $path.$row2['pfs_randimg'] != '') ? '<img class="image" src="datas/thumbs/'.$path.$row2['pfs_randimg'].'" cropratio="4:3"/>' : $R['icon_folder'];
	if (!$standalone)
	{
		$pff_delete = ($row['pff_userid'] == $userid) ? cot_confirm_url(cot_url('pfs', 'a=deletefolder&'.cot_xg().'&id='.$pff_id.'&'.$more), 'pfs', 'pfs_confirm_delete_folder') : '';
		$pff_edit = ($row['pff_userid'] == $userid) ? cot_url('pfs', "t=editfolder&id=".$pff_id.'&f='.$f.'&'.$more) : '';
	}
	
	if ($type == 'editfolder' and $row['pff_userid'] == $userid and $pff_id == $id)
	{
		$icon_f = ($gallery && $path.$row2['pfs_randimg'] != '') ? '<img class="image" src="datas/users/'.$path.$row2['pfs_randimg'].'" cropratio="4:3"/>' : $icon_f;
		$t->assign(array(
			'PFF_EDIT_ICON' => $icon_f,
			'PFF_EDIT_EDIT_URL' => 'EDIT',
			'PFF_EDIT_ACTION' => cot_url('pfs', 'a=updatefolder&f=' . $pff_id . '&' . $more),
			'PFF_EDIT_TITLE' => cot_inputbox('text', 'rtitle', htmlspecialchars($pff_title), 'size="56" maxlength="255"'),
			'PFF_EDIT_DESC' => cot_inputbox('text', 'rdesc',  htmlspecialchars($pff_desc), 'size="56" maxlength="255"'),
			'PFF_EDIT_ISPUBLIC' => cot_checkbox($pff_ispublic, 'rispublic', ''),
			'PFF_EDIT_ISGALLERY' => cot_checkbox($pff_isgallery, 'risgallery', ''),
			'PFF_EDIT_DATE' => cot_date('datetime_medium', $row['pff_date']),
			'PFF_EDIT_UPDATED' => cot_date('datetime_medium', $row['pff_updated']),
			'PFF_EDIT_COUNT' => $pff_count,
			'PFF_EDIT_FCOUNT' => $pff_fcount,
			'PFF_EDIT_FSIZE' => $pff_fssize
		));
		cot_display_messages($t);
	}
	else
	{
		$t->assign(array(
			'PFF_ROW_TITLE' => $pff_title,
			'PFF_ROW_COUNT' => $pff_count,
			'PFF_ROW_DELETE_URL' => $pff_delete,
			'PFF_ROW_EDIT_URL' => $pff_edit,
			'PFF_ROW_URL' => cot_url('pfs', 'f='.$pff_id.'&'.$more),
			'PFF_ROW_ICON' => $icon_f
		));
		$t->parse('MAIN.PFF_ROW');
	}
	$item_count++;
	$sql2->closeCursor();	
}
$sql->closeCursor();

/* Counter */
if($f>0)
	$sql = $db->query("SELECT * FROM $db_pfs AS p INNER JOIN $db_pfs_folders AS f ON p.pfs_folderid = $f WHERE (p.pfs_userid=$userid OR f.pff_ispublic=1) AND f.pff_id=$f ORDER BY p.pfs_file ASC");
else
	$sql = $db->query("SELECT * FROM $db_pfs WHERE pfs_userid=$userid AND pfs_folderid = $f ORDER BY pfs_file ASC");
$tile_all += $sql->rowCount();
	
if($f>0)
	$sql = $db->query("SELECT * FROM $db_pfs AS p INNER JOIN $db_pfs_folders AS f ON p.pfs_folderid = $f WHERE (p.pfs_userid=$userid OR f.pff_ispublic=1) AND f.pff_id=$f ORDER BY p.pfs_file ASC LIMIT $d, ".((INT)$cfg['pfs']['maxpfsperpage'] - (INT)$item_count));
else
	$sql = $db->query("SELECT * FROM $db_pfs WHERE pfs_userid=$userid AND pfs_folderid = $f ORDER BY pfs_file ASC LIMIT $d, ".((INT)$cfg['pfs']['maxpfsperpage'] - (INT)$item_count));


	
foreach ($sql->fetchAll() as $row)
{
	$pfs_id = $row['pfs_id'];
	$pfs_file = $row['pfs_file'];
	$pfs_date = $row['pfs_date'];
	$pfs_extension = $row['pfs_extension'];
	$pfs_desc = htmlspecialchars($row['pfs_desc']);
	$pfs_fullfile = $pfs_dir_user.$pfs_file;
	$pfs_filesize = floor($row['pfs_size']/1024);
	$pfs_icon = (in_array($pfs_extension, $gd_supported)) ? '<img class="image" src="'.$thumbs_dir_user.$pfs_file.'" cropratio="4:3"/>' : $icon[$pfs_extension];
	$pfs_image = (in_array($pfs_extension, $gd_supported)) ? true : false;
	
	$dotpos = mb_strrpos($pfs_file, ".")+1;
	$pfs_realext = mb_strtolower(mb_substr($pfs_file, $dotpos, 5));

	if ($pfs_extension!=$pfs_realext)
	{
		$db->update($db_pfs, array('pfs_extension' => $pfs_realext), "pfs_id=$pfs_id");
		$pfs_extension = $pfs_realext;
	}

	if (in_array($pfs_extension, $gd_supported) && $cfg['pfs']['th_amode'] != 'Disabled')
	{
		if (!file_exists($thumbs_dir_user.$pfs_file) && file_exists($pfs_dir_user.$pfs_file))
		{
			$th_colortext = array(hexdec(mb_substr($cfg['pfs']['th_colortext'],0,2)), hexdec(mb_substr($cfg['pfs']['th_colortext'],2,2)), hexdec(mb_substr($cfg['pfs']['th_colortext'],4,2)));
			$th_colorbg = array(hexdec(mb_substr($cfg['pfs']['th_colorbg'],0,2)), hexdec(mb_substr($cfg['pfs']['th_colorbg'],2,2)), hexdec(mb_substr($cfg['pfs']['th_colorbg'],4,2)));
			cot_imageresize($pfs_dir_user.$pfs_file, $thumbs_dir_user.$pfs_file,
				$cfg['pfs']['th_x'], $cfg['pfs']['th_y'], 'fit', $th_colorbg,
				$cfg['pfs']['th_jpeg_quality'], true);
		}
	}
	if ($standalone)
	{
		if ($pfs_image)
		{
			$pfs_delete = cot_rc('pfs_link_addthumb');
			$pfs_edit = cot_rc('pfs_link_addpix');
		}
		else
			$pfs_edit = cot_rc('pfs_link_addfile');
	}
	else
	{
		$pfs_delete = ($row['pfs_userid'] == $userid) ? cot_confirm_url(cot_url('pfs', 'a=delete&'.cot_xg().'&id='.$pfs_id.'&'.$more), 'pfs', 'pfs_confirm_delete_file') : '';
		$pfs_edit = ($row['pfs_userid'] == $userid) ? cot_url('pfs', 't=editfile&id='.$pfs_id.'&f='.$f.'&'.$more) : '';
	}
	
	if ($type=='editfile' and $row['pfs_userid'] == $userid and $id == $pfs_id)
	{
		if ($pfs_image){
			$pfs_icon = '<img class="image" src="'.$pfs_fullfile.'" cropratio="4:3"/>';
		}
		$t-> assign(array(
			
			'PFS_EDIT_ID' => $pfs_id,
			'PFS_EDIT_ACTION' => cot_url('pfs', 'f='.$f.'&a=updatefile&id='.$pfs_id.'&'.$more),
			'PFS_EDIT_FILE' => $pfs_file,
			'PFS_EDIT_DATE' =>  cot_date('datetime_medium', $pfs_date),
			'PFS_EDIT_DATE_STAMP' => $pfs_date,
			'PFS_EDIT_EXT' => $pfs_extension,
			'PFS_EDIT_DESC' => cot_inputbox('text', 'rdesc', $pfs_desc, 'size="56" maxlength="255"'),
			'PFS_EDIT_TYPE' => $filedesc[$pfs_extension],
			'PFS_EDIT_SIZE' => $pfs_filesize,
			'PFS_EDIT_ICON' => $pfs_icon,
			'PFS_EDIT_EDIT_URL' => 'EDIT',
			'PFS_EDIT_COUNT' => $row['pfs_count']
		));
	}
	else
	{
		$t-> assign(array(
			'PFS_ROW_ID' => $pfs_id,
			'PFS_ROW_FILE' => $pfs_file,
			'PFS_ROW_DATE' => cot_date('datetime_medium', $pfs_date),
			'PFS_STANDALONE' => $standalone,
			'PFS_ROW_EXT' => $pfs_extension,
			'PFS_ROW_DESC' => $pfs_desc,
			'PFS_ROW_TYPE' => $filedesc[$pfs_extension],
			'PFS_ROW_FILE_URL' => $pfs_fullfile,
			'PFS_ROW_SIZE' => $pfs_filesize,
			'PFS_ROW_ICON' => $pfs_icon,
			'PFS_ROW_DELETE_URL' => $pfs_delete,
			'PFS_ROW_EDIT_URL' => $pfs_edit,
			'PFS_ROW_IMG' => $pfs_image,
			'PFS_ROW_COUNT' => $row['pfs_count']
		));
		$t->parse('MAIN.PFS_ROW');
	}
	$item_count++;
}
$sql->closeCursor();

if ($item_count > 0 )
{
	$pagenav = cot_pagenav('pfs', 'f='.$f.'&userid='.$usr['id'].$pn_c1.$pn_c2, $d,
	$tile_all, $cfg['pfs']['maxpfsperpage']);

	$filesinfolder .= ($f>0) ? $L['pfs_filesinthisfolder'] : $L['pfs_filesintheroot'];
	$t->assign(array(
		'PFS_FILESCOUNT' => $tile_all,
		'PFS_INTHISFOLDER' => $filesinfolder,
		'PFS_PAGING_PREV' => $pagenav['prev'],
		'PFS_PAGING_CURRENT' => $pagenav['main'],
		'PFS_PAGING_NEXT' => $pagenav['next']
	));
}

if ($usr['auth_write'])
{
// ========== Statistics =========
	$t->assign(array(
		'PFS_TOTALSIZE' => cot_build_filesize($pfs_totalsize, 1),
		'PFS_TOTALSIZE_BYTES' => $pfs_totalsize,
		'PFS_TOTALSIZE_KB' => floor($pfs_totalsize / 1024), // in KiB; deprecated but kept for compatibility
		'PFS_MAXTOTAL' => cot_build_filesize($maxtotal, 1),
		'PFS_MAXTOTAL_BYTES' => $maxtotal,
		'PFS_MAXTOTAL_KB' => $maxtotal / 1024, // in KiB; deprecated but kept for compatibility
		'PFS_PERCENTAGE' => $maxtotal > 0 ? round($pfs_totalsize/$maxtotal*100) : 0,
		'PFS_MAXFILESIZE' => cot_build_filesize($maxfile, 1),
		'PFS_MAXFILESIZE_BYTES' => $maxfile,
		'PFS_MAXFILESIZE_KB' => $maxfile / 1024, // in KiB; deprecated but kept for compatibility
	));
// ========== Upload =========
	$t->assign(array(
		'PFS_UPLOAD_FORM_MAX_SIZE' => $maxfile,
		'PFS_UPLOAD_FORM_USERID' => $userid,
		'PFS_UPLOAD_FORM_ACTION' => cot_url('pfs', "f=$f&a=upload&$more"),
	));
	$t->parse('MAIN.PFS_UPLOAD_FORM');
// ========== Allowed =========
}

reset($cot_extensions);
sort($cot_extensions);
foreach ($cot_extensions as $k => $line)
{
	$t->assign(array(
		'ALLOWED_ROW_ICON' => $icon[$line[0]],
		'ALLOWED_ROW_EXT' => $line[0],
		'ALLOWED_ROW_DESC' => $filedesc[$line[0]]
	));
	$t->parse('MAIN.ALLOWED_ROW');
}

// ========== Create a new folder =========

if ($usr['auth_write'])
{
	$t->assign(array(
		'NEWFOLDER_FORM_ACTION' => cot_url('pfs', 'a=newfolder&f='.$f.'&$more'), // NEW
//		'NEWFOLDER_FORM_INPUT_PARENT' => cot_selectbox_folders($userid, '', $f, 'nparentid'),
		));
	$t->parse('MAIN.PFS_NEWFOLDER_FORM');
}

$t->assign('PFS_TITLE', $title); // New
$t->assign('PFS_SUBTITLE', $subtitle); // New

if ($standalone)
{
	if($c1 == 'newpage' && $c2 == 'newpageurl' || $c1 == 'update' && $c2 == 'rpageurl')
	{
		$addthumb = "'".$thumbs_dir_user."' + gfile";
		$addpix = 'gfile';
		$addfile = "'".$pfs_dir_user."' + gfile";
	}
	else
	{
		$addthumb = $R['pfs_code_addthumb'];
		$addpix = $R['pfs_code_addpix'];
		$addfile = $R['pfs_code_addfile'];
	}
	$winclose = $cfg['pfs']['pfs_winclose'] ? "\nwindow.close();" : '';

	$pfs_code_addfile = cot_rc('pfs_code_addfile');
	$pfs_code_addthumb = cot_rc('pfs_code_addthumb');
	$pfs_code_addpix = cot_rc('pfs_code_addpix');

	cot_sendheaders();

	cot_rc_output();

	$t->assign(array(
		'PFS_HEAD' => $out['head_head'],
		'PFS_HEADER_JAVASCRIPT' => cot_rc('pfs_code_header_javascript'),
		'PFS_C1' => $c1,
		'PFS_C2' => $c2,
		'PFS_ADDTHUMB' => $addthumb,
		'PFS_ADDPIX' => $addpix,
		'PFS_ADDFILE' => $addfile,
		'PFS_WINCLOSE' => $winclose
	));

	$t->parse('MAIN.STANDALONE_HEADER');
	$t->parse('MAIN.STANDALONE_FOOTER');

	/* === Hook === */
	foreach (cot_getextplugins('pfs.standalone') as $pl)
	{
		include $pl;
	}
	/* ===== */
}
else
{
	/* === Hook === */
	foreach (cot_getextplugins('pfs.tags') as $pl)
	{
		include $pl;
	}
	/* ===== */
}

if (count($err_msg) > 0)
{
	foreach ($err_msg as $msg)
	{
		$t->assign('PFS_ERRORS_ROW_MSG', $msg);
		$t->parse('MAIN.PFS_ERRORS.PFS_ERRORS_ROW');
	}
	$t->parse('MAIN.PFS_ERRORS');
}

$t->parse('MAIN');
$t->out('MAIN');

if(!$standalone)
{
	require_once $cfg['system_dir'] . '/footer.php';
}

?>
