<?php

defined('COT_CODE') or die('Wrong URL');

global $cfg;

// How long (in seconds) the web browser should use its cached copy of the image
// before checking with the server for a new version
define('SLIR_BROWSER_CACHE_EXPIRES_AFTER_SECONDS',	$cfg['plugin']['slir']['cache_time'] * 60 * 60);

// Whether we should use the faster, symlink-based request cache as a first line cache
define('SLIR_USE_REQUEST_CACHE',					TRUE);

// Whether EXIF information should be copied from the source image
define('SLIR_COPY_EXIF',							(bool)$cfg['plugin']['slir']['copy_exif']);

// How much memory to allocate for memory-intensive processes such as rendering
define('SLIR_MEMORY_TO_ALLOCATE',					$cfg['plugin']['slir']['memory'].'M');

// Default quality setting to use if quality is not specified in the request.
// Ranges from 0 (worst quality, smaller file) to 100 (best quality, biggest file).
define('SLIR_DEFAULT_QUALITY',						$cfg['plugin']['slir']['quality']);

// Default crop mode setting to use if crop mode is not specified in the request.
// Possible values are SLIR::CROP_MODE_CENTERED and SLIR::CROP_MODE_SMART.
define('SLIR_DEFAULT_CROP_MODE',					SLIR::CROP_MODE_CENTERED);

// Default setting for whether JPEGs should be progressive JPEGs (interlaced) or not.
define('SLIR_DEFAULT_PROGRESSIVE_JPEG',				(bool)$cfg['plugin']['slir']['progressive']);

// Whether SLIR should log errors
define('SLIR_LOG_ERRORS',							(bool)$cfg['plugin']['slir']['log_errors']);

// Whether SLIR should generate and output images from error messages
define('SLIR_ERROR_IMAGES',							(bool)$cfg['plugin']['slir']['show_errors']);

// Absolute path to the web root (location of files when visiting http://domainname.com/) (no trailing slash)
define('SLIR_DOCUMENT_ROOT',						preg_replace('/\/$/', '', $_SERVER['DOCUMENT_ROOT']));

// Path to SLIR (no trailing slash)
define('SLIR_DIR',									'/plugins/slir');

// Name of directory to store cached files in (no trailing slash)
define('SLIR_CACHE_DIR_NAME',						'/slir');

// Absolute path to cache directory. This directory must be world-readable,
// writable by the web server, and must end with SLIR_CACHE_DIR_NAME (no
// trailing slash). Ideally, this should be located outside of the web tree.
define('SLIR_CACHE_DIR',							$cfg['cache_dir'] . SLIR_CACHE_DIR_NAME);

// Path to the error log file. Needs to be writable by the web server. Ideally,
// this should be located outside of the web tree.
define('SLIR_ERROR_LOG_PATH',						SLIR_DOCUMENT_ROOT . SLIR_DIR . '/slir-error-log');

// If TRUE, forces SLIR to always use the query string for parameters instead of mod_rewrite.
define('SLIR_FORCE_QUERY_STRING',					(bool)$cfg['plugin']['slir']['force_qs']);

?>