<?php
/**
 * Reactions resources
 *
 * @package reactions
 * @version 1.0.0
 * @author Rootali / Slaweally
 * @copyright Copyright (c) 2025 Rootali / Slaweally
 * @license BSD
 */

defined('COT_CODE') or die('Wrong URL');

$R['reactions_divider'] = ', ';
$R['reactions_bracket_open'] = ' (';
$R['reactions_bracket_close'] = ')';
$R['reactions_quote_open'] = '&laquo;';
$R['reactions_quote_close'] = '&raquo;';

// Reaction icons
$R['reaction_like_icon'] = '<i class="fas fa-thumbs-up"></i>';
$R['reaction_love_icon'] = '<i class="fas fa-heart"></i>';
$R['reaction_laugh_icon'] = '<i class="fas fa-laugh"></i>';
$R['reaction_wow_icon'] = '<i class="fas fa-surprise"></i>';
$R['reaction_sad_icon'] = '<i class="fas fa-sad-tear"></i>';
$R['reaction_angry_icon'] = '<i class="fas fa-angry"></i>';

// Notification templates
$R['reactions_pm_notification'] = '{$intro} <br /> <a href="{$link}">' . $L['ReadMore'] . '</a>';
$R['reactions_email_notification'] = '{$intro}
{$link}';

// UI elements
$R['reactions_more_link'] = '<a href="{$link}" class="btn btn-sm btn-secondary">{$icon}<span>{$text}</span></a>';
$R['reactions_delete_link'] = '<a href="{$link}" class="btn btn-sm btn-danger confirmLink">{$icon}<span>{$text}</span></a>';
$R['reactions_button'] = '<button type="button" class="reaction-btn {$class} {$active}" data-reaction="{$type}" data-ext="{$ext}" data-item="{$item}">{$icon}</button>';
$R['reactions_count'] = '<span class="reaction-count" data-reaction="{$type}" data-ext="{$ext}" data-item="{$item}">{$count}</span>';
$R['reactions_tooltip'] = '<span class="reaction-users" data-toggle="tooltip" data-placement="top" title="{$users}">{$count}</span>';