<?PHP
/**
 * English Language File for Admin Area (admin.lang.php)
 *
 * @package Cotonti
 * @version 0.1.0
 * @author Cotonti Translators Team
 * @copyright Copyright (c) Cotonti Team 2008-2009
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Config Section
 */

$L['core_comments'] = &$L['Comments'];
$L['core_forums'] = &$L['Forums'];
$L['core_lang'] = &$L['Language'];
$L['core_main'] = 'Main Settings';
$L['core_menus'] = &$L['Menus'];
$L['core_page'] = &$L['Pages'];
$L['core_parser'] = &$L['Parser'];
$L['core_pfs'] = &$L['PFS'];
$L['core_plug'] = &$L['Plugins'];
$L['core_pm'] = &$L['Private_Messages'];
$L['core_polls'] = &$L['Polls'];
$L['core_ratings'] = &$L['Ratings'];
$L['core_skin'] = &$L['Skins'];
$L['core_time'] = 'Time and Date';
$L['core_title'] = 'Titles (&lt;naslov&gt; tag)';
$L['core_trash'] = &$L['Trashcan'];
$L['core_users'] = &$L['Korisnici'];

/**
 * Config Section
 * Comments Subsection
 */

$L['cfg_countcomments'] = array('Broji komentare', 'Prikazuje broj komentara pokraj ikone');
$L['cfg_disable_comments'] = array('Isključi komentare', '');
$L['cfg_expand_comments'] = array('Proširi komentare', 'Zadani prikaz komentara je proširen');	// New in N-0.0.2
$L['cfg_maxcommentsperpage'] = array('Max. komentara po stranici', ' ');   // New in N-0.0.6
$L['cfg_commentsize'] = array('Max. veličina komentara', 'U bitovima (nula za neograničeno). Zadano: 0');   // New in N-0.0.6

/**
 * Config Section
 * Forums Subsection
 */

$L['cfg_antibumpforums'] = array('Onemogući Šutni me', 'Korisnici neće moći pisati dva puta za redom u istoj temi');	// New in N-0.1.0
$L['cfg_disable_forums'] = array('Isključi forum', '');
$L['cfg_hideprivateforums'] = array('Sakrij privatne forume', '');
$L['cfg_hottopictrigger'] = array('Broj odgovora za \'vruću\' temu', '');
$L['cfg_maxtopicsperpage'] = array('Maksimalno tema po stranici', '');
$L['cfg_mergeforumposts'] = array('Spoji odgovore', 'Spojit će odgovore ako su napisani od istog korisnika dva puta za redom, opcija Šutni me mora biti isključena');	// New in N-0.1.0
$L['cfg_mergetimeout'] = array('Vrijeme spajanja odgovora', 'Neće spojiti odgovore korisnika koji su napisani dva puta za redom nakon ovog vremena(u satima), opcija Spoji odgovore mora biti uključena(nula za isključivanje ove opcije)');	// New in N-0.1.0
$L['cfg_maxpostsperpage'] = array('Max. odgovora po stranici', ' '); // New in N-0.0.6

/**
 * Config Section
 * Lang Subsection
 */

$L['cfg_forcedefaultlang'] = array('Zadani jezik obavezan za sve', '');

/**
 * Config Section
 * Main Subsection
 */

$L['cfg_adminemail'] = array('E-mail administratora', 'Obavezno');
$L['cfg_turnajax'] = array('Isključi AJAX', 'Radi samo kada je jQuery uključen');
$L['cfg_cache'] = array('Interni cache', 'Uključite za bolje performanse');
$L['cfg_clustermode'] = array('Grupa servera', 'Set to yes if it\'s a load balanced setup.');
$L['cfg_cookiedomain'] = array('Domena za cookie', 'Zadano: prazno');
$L['cfg_cookielifetime'] = array('Maksimalno vrijeme trajanja cookiea', 'U sekundama');
$L['cfg_cookiepath'] = array('Putanja za cookie', 'Zadano: prazno');
$L['cfg_devmode'] = array('Traženje greške', 'Ne uključujte na živim stranicama');
$L['cfg_disablehitstats'] = array('Isključi statistike posjeta', 'Referali i posjete po danu');
$L['cfg_gzip'] = array('Gzip', 'Gzip kompresija HTMLa');
$L['cfg_hostip'] = array('IP servera', 'IP servera, nije obavezno.');
$L['cfg_jquery'] = array('Uključi jQuery', '');	// New in N-0.0.1
$L['cfg_maintenance'] = array('Održavanje', 'Pristup stranici omogućuen samo autoriziranim korisnicima');	// New in N-0.0.2
$L['cfg_maintenancereason'] = array('Razlog održavanja', 'Neobavezno, trebalo bi biti kratko');	// New in N-0.0.2
$L['cfg_shieldenabled'] = array('Uključi Štit', 'Anti-spam i anti-zakucavanje');
$L['cfg_shieldtadjust'] = array('Postavi vrijeme Štita(u %)', 'Što više, to je teže spamati');
$L['cfg_shieldzhammer'] = array('Protu-zakucavanje nakon * brzih posjeta', 'Što niže, to brže će se aktivirati 3 minutno isključenje');

/**
 * Config Section
 * Menus Subsection
 */

$L['cfg_banner'] = array('Banner<br />{HEADER_BANNER} u header.tpl', '');
$L['cfg_bottomline'] = array('Bottom line<br />{FOOTER_BOTTOMLINE} u footer.tpl', '');
$L['cfg_topline'] = array('Top line<br />{HEADER_TOPLINE} u header.tpl', '');

$L['cfg_freetext1'] = array('Tekst Položaj #1<br />{PHP.cfg.freetext1} u svim tpl datotekama', '');
$L['cfg_freetext2'] = array('Tekst Položaj #2<br />{PHP.cfg.freetext2} u svim tpl datotekama', '');
$L['cfg_freetext3'] = array('Tekst Položaj #3<br />{PHP.cfg.freetext3} u svim tpl datotekama', '');
$L['cfg_freetext4'] = array('Tekst Položaj #4<br />{PHP.cfg.freetext4} u svim tpl datotekama', '');
$L['cfg_freetext5'] = array('Tekst Položaj #5<br />{PHP.cfg.freetext5} u svim tpl datotekama', '');
$L['cfg_freetext6'] = array('Tekst Položaj #6<br />{PHP.cfg.freetext6} u svim tpl datotekama', '');
$L['cfg_freetext7'] = array('Tekst Položaj #7<br />{PHP.cfg.freetext7} u svim tpl datotekama', '');
$L['cfg_freetext8'] = array('Tekst Položaj #8<br />{PHP.cfg.freetext8} u svim tpl datotekama', '');
$L['cfg_freetext9'] = array('Tekst Položaj #9<br />{PHP.cfg.freetext9} u svim tpl datotekama', '');

$L['cfg_menu1'] = array('Izbornik Položaj #1<br />{PHP.cfg.menu1} u svim tpl datotekama', '');
$L['cfg_menu2'] = array('Izbornik Položaj #2<br />{PHP.cfg.menu2} u svim tpl datotekama', '');
$L['cfg_menu3'] = array('Izbornik Položaj #3<br />{PHP.cfg.menu3} u svim tpl datotekama', '');
$L['cfg_menu4'] = array('Izbornik Položaj #4<br />{PHP.cfg.menu4} u svim tpl datotekama', '');
$L['cfg_menu5'] = array('Izbornik Položaj #5<br />{PHP.cfg.menu5} u svim tpl datotekama', '');
$L['cfg_menu6'] = array('Izbornik Položaj #6<br />{PHP.cfg.menu6} u svim tpl datotekama', '');
$L['cfg_menu7'] = array('Izbornik Položaj #7<br />{PHP.cfg.menu7} u svim tpl datotekama', '');
$L['cfg_menu8'] = array('Izbornik Položaj #8<br />{PHP.cfg.menu8} u svim tpl datotekama', '');
$L['cfg_menu9'] = array('Izbornik Položaj #9<br />{PHP.cfg.menu9} u svim tpl datotekama', '');

/**
 * Config Section
 * Page Subsection
 */

$L['cfg_allowphp_pages'] = array('Omogući PHP u stranicama', 'Umetanje PHP koda u stranice, oprezno s time!');
$L['cfg_autovalidate'] = array('Autovalidacija stranica', 'Automatski objavi stranicu ako autor ima administratorska prava za kategoriju');	// New in N-0.0.2
$L['cfg_count_admin'] = array('Ubroji posjete administratora', '');	// New in N-0.0.1
$L['cfg_disable_page'] = array('Isključi stranice', '');
$L['cfg_maxrowsperpage'] = array('Max. redova u listi', ' ');
$L['cfg_maxlistsperpage'] = array('Max. listi po stranici', ' '); // New in N-0.0.6

/**
 * Config Section
 * Parser Subsection
 */

$L['cfg_parsebbcodecom'] = array('Analiziraj BBkod u komentarima i privatnim porukama', '');
$L['cfg_parsebbcodeforums'] = array('Analiziraj BBkod u forumima', '');
$L['cfg_parsebbcodepages'] = array('Analiziraj BBkod u stranicama', '');
$L['cfg_parsebbcodeusertext'] = array('Analiziraj BBkod u potpisima korisnika', '');
$L['cfg_parser_cache'] = array('Uključi HTML cache', '');	// New in N-0.0.1
$L['cfg_parser_custom'] = array('Uključi posebni analizator', '');	// New in N-0.0.1
$L['cfg_parser_disable'] = array('Isključi standardni analizator', '');	// New in N-0.0.3
$L['cfg_parsesmiliescom'] = array('Analiziraj emotikone u komentarima i privatnim porukama', '');
$L['cfg_parsesmiliesforums'] = array('Analiziraj emotikone u forumima', '');
$L['cfg_parsesmiliespages'] = array('Analiziraj emotikone u stranicama', '');
$L['cfg_parsesmiliesusertext'] = array('Analiziraj emotikone u potpisima korisnika', '');

/**
 * Config Section
 * PFS Subsection
 */

$L['cfg_disable_pfs'] = array('Isključi '.$L['PFS'], '');
$L['cfg_maxpfsperpage'] = array('Max. elemenata po stranici', ' ');
$L['cfg_pfsfilecheck'] = array('Provjera datoteka', 'Provjera svake postavljene datoteke koriseći '.$L['PFS'].', ili slike preko profila. Služi za provjeru ispravnosti datoteke. &quot;Da&quot; preporučeno, iz sigurnosnih razloga.');	// New in N-0.0.2
$L['cfg_pfsnomimepass'] = array('MIMEtype neobavezan', 'Ako je uključeno, uploadane datoteke će proći provjeru iako nemaju mimetype u svojoj konfiguraciji.');	// New in N-0.0.2
$L['cfg_pfstimename'] = array('Vremenski nazivi datoteka', 'Stvori naziv datoteke koristeći trenutno vrijeme. Standardna postavka sastoji se od originalnog naziva datoteke zajedno sa nekim potrebnim pretvorbama znakova.');	// New in N-0.0.2
$L['cfg_pfsuserfolder'] = array('Folder storage mode', 'Ako je uključeno, spremat će datoteke korisnika u podmape /datas/users/ID-KORISNIKA/... umjesto stavljnja ID-KORISNIKA u ime datoteke. Mora biti postavljeno pri PRVOJ instalaciji. Ako je već neka datoteka uploadana, prekasno je da ovo mijenjate. Trenutno ne preporučamo aktiviranje ove postavke.');
$L['cfg_pfs_winclose'] = array('Zatvori popup prozor nakon umetanja bbkoda');
$L['cfg_th_amode'] = array('Generiranje sličica', '');
$L['cfg_th_border'] = array('Sličice, veličina okvira', 'Zadano: 4 pixela');
$L['cfg_th_colorbg'] = array('Sličice, boja okvira', 'Zadano: 000000, hex kod ');
$L['cfg_th_colortext'] = array('Sličice, boja teksta', 'Zadano: FFFFFF, hex kod');
$L['cfg_th_dimpriority'] = array('Sličice, prioritetna dimenzija kod generiranja', '');
$L['cfg_th_jpeg_quality'] = array('Sličice, kvaliteta JPEGa', 'Zadano: 85');
$L['cfg_th_keepratio'] = array('Sličica, sačuvaj omjer?', '');
$L['cfg_th_textsize'] = array('Sličice, veličina teksta', '');
$L['cfg_th_x'] = array('Sličice, širina', 'Zadano: 112 pixela');
$L['cfg_th_y'] = array('Sličice, visina', 'Zadano: 84 pixela, preporučeno: širina x 0.75');

/**
 * Config Section
 * Plugins Subsection
 */

$L['cfg_disable_plug'] = array('Isključi pluginove', '');

/**
 * Config Section
 * Private Messages Subsection
 */

$L['cfg_disable_pm'] = array('Isključi privatne poruke', '');
$L['cfg_pm_allownotifications'] = array('Dozvoli obavijesti o PP na e-mail', '');
$L['cfg_pm_maxsize'] = array('Maksimalna dužina poruke', 'Zadano: 10000 znakova');
$L['cfg_maxpmperpage'] = array('Max. poruka po stranici', ' ');  // New in N-0.0.6

/**
 * Config Section
 * Polls Subsection
 */

$L['cfg_del_dup_options'] = array('Brisanje duplih opcija', ' Briše duple opcije iako se već nalaze u bazi');	// New in N-0.0.2
$L['cfg_disable_polls'] = array('Isključi ankete', '');
$L['cfg_ip_id_polls'] = array('Način brojanja glasova', '');	// New in N-0.0.2
$L['cfg_max_options_polls'] = array('Max broj izbora', 'Automatski će se brisati izbori koji su premašili ovo ograničenje');	// New in N-0.0.2

/**
 * Config Section
 * Ratings Subsection
 */

$L['cfg_disable_ratings'] = array('Isključi ocjene', '');
$L['cfg_ratings_allowchange'] = array('Dozvoli promjenu ocjene?', 'Korisnik će moći promijeniti svoju ocjenu.');	// New in N-0.0.2

/**
 * Config Section
 * Skins Subsection
 */

$L['cfg_charset'] = array('HTML charset', '');
$L['cfg_disablesysinfos'] = array('Isključi vrijeme kreiranja stranice', 'Za footer.tpl');
$L['cfg_doctypeid'] = array('Tip dokumenta', '&lt;!DOCTYPE&gt;  HTML formata');
$L['cfg_forcedefaultskin'] = array('Zadana tema obavezna za sve korisnike', '');
$L['cfg_homebreadcrumb'] = array('Prikaži Početna u Mrvicama', 'Postavi link na glavnu stranicu na početku Mrvica');	// New in N-0.0.2
$L['cfg_keepcrbottom'] = array('Prikaži autorska prava pri korištenju taga {FOOTER_BOTTOMLINE}', 'Za footer.tpl');
$L['cfg_metakeywords'] = array('HTML Meta keywords (odvojeni zarezom)', 'Pretraživači');
$L['cfg_separator'] = array('Opći separator', 'Zadano:>');
$L['cfg_showsqlstats'] = array('Prikaži statistike SQL upita', 'U footer.tpl');

/**
 * Config Section
 * Time Subsection
 */

$L['cfg_dateformat'] = array('Glavni oblik datuma', 'Zadano: Y-m-d H:i');
$L['cfg_formatmonthday'] = array('Kratki oblik datuma', 'Zadano: m-d');
$L['cfg_formatyearmonthday'] = array('Srednji oblik datuma', 'Zadano: Y-m-d');
$L['cfg_formatmonthdayhourmin'] = array('Oblik datuma na forumu', 'Zadano: m-d H:i');
$L['cfg_servertimezone'] = array('Vremenska zona server', 'Offset of the server from the GMT+00');
$L['cfg_defaulttimezone'] = array('Zadana vremenska zona', 'Za goste i nove članove, od -12 do +12');
$L['cfg_timedout'] = array('Idle delay, in seconds', 'After this delay, user is away');

/**
 * Config Section
 * Title Subsection
 */

$L['cfg_maintitle'] = array('Naziv stranice', 'Glavni naziv stranice, obavezno');
$L['cfg_subtitle'] = array('Opis', 'Nije obavezno, prikazat će se nakon naziva stranice');
$L['cfg_title_forum_editpost'] = array('Forum - Uredi Odgovor - naslov', 'Opcije: {FORUM}, {SECTION}, {EDIT}');
$L['cfg_title_forum_main'] = array('Glavni naziv foruma', 'Opcije: {FORUM}');
$L['cfg_title_forum_newtopic'] = array('Forum - Nova Tema - naslov', 'Opcije: {FORUM}, {SECTION}, {NEWTOPIC}');
$L['cfg_title_forum_posts'] = array('Forum - Odgovori - naslov', 'Opcije: {FORUM}, {TITLE}');
$L['cfg_title_forum_topics'] = array('Forum  - Teme - naslov', 'Opcije: {FORUM}, {SECTION}');
$L['cfg_title_header'] = array('Naslov zaglavlja', 'Opcije: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_header_index'] = array('Naslov zaglavlja Indexa', 'Opcije: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_list'] = array('Naslov liste', 'Opcije: {TITLE}');
$L['cfg_title_page'] = array('Naslov stranice', 'Opcije: {TITLE}, {CATEGORY}');
$L['cfg_title_pfs'] = array($L['PFS'].' naslov', 'Opcije: {PFS}');
$L['cfg_title_pm_main'] = array('Naslov PP', 'Opcije: {PM}, {INBOX}, {ARCHIVES}, {SENTBOX}');
$L['cfg_title_pm_send'] = array('PP - Slanje - naslov', 'Opcije: {PM}, {SEND_NEW}');
$L['cfg_title_users_details'] = array('Korisnici - Detalji - naslov', 'Opcije: {USER}, {NAME}');
$L['cfg_title_users_edit'] = array('Korisnici - Uredi - naslov', 'Opcije: {EDIT}, {NAME}');
$L['cfg_title_users_main'] = array('Korisnici - Glavno - naslov', 'Opcije: {USERS}');
$L['cfg_title_users_profile'] = array('Korisnici - Profil - naslov', 'Opcije: {PROFILE}, {NAME}');

/**
 * Config Section
 * Trash Subsection
 */

$L['cfg_trash_comment'] = array('Koristi smeće za komentare', '');
$L['cfg_trash_forum'] = array('Koristi smeće za forum', '');
$L['cfg_trash_page'] = array('Koristi smeće za stranice', '');
$L['cfg_trash_pm'] = array('Koristi smeće za privatne poruke', '');
$L['cfg_trash_prunedelay'] = array('Trajno obriši predmete iz smeća nakon * dana (Nula ako ne želite brisati nikada)', '');
$L['cfg_trash_user'] = array('Koristi smeće za korisnike', '');

/**
 * Config Section
 * Korisnici Subsection
 */

$L['cfg_av_maxsize'] = array('Avatar, maksimalna velična datoteke', 'Zadano: 8000 bita');
$L['cfg_av_maxx'] = array('Avatar, maksimalna širina', 'Zadano: 64 pixela');
$L['cfg_av_maxy'] = array('Avatar, maksimalna visina', 'Zadano: 64 pixela');
$L['cfg_disablereg'] = array('Onemogući registraciju', 'Ne dopusti registraciju novih korisnika');
$L['cfg_disablewhosonline'] = array('Isključi Trenutno online', 'Automatski uključeno ako uključite Štit');
$L['cfg_maxusersperpage'] = array('Maksimalno redova u listi korisnika', '');
$L['cfg_ph_maxsize'] = array('Slika, maksimalna veličina datoteke', 'Zadano: 8000 bita');
$L['cfg_ph_maxx'] = array('Slika, maksimalna širina', 'Zadano: 96 pixela');
$L['cfg_ph_maxy'] = array('Slika, maksimalna visina', 'Zadano: 96 pixela');
$L['cfg_regnoactivation'] = array('Preskoči provjeru e-mail adrese novih korisnika', '\'Ne\'preporučeno, iz sigurnosnih razloga');
$L['cfg_regrequireadmin'] = array('Administrator mora potvrditi nove korisnike', '');
$L['cfg_sig_maxsize'] = array('Potpis, maksimalna veličina datoteke', 'Zadano: 50000 bita');
$L['cfg_sig_maxx'] = array('Potpis, maksimalna širina', 'Zadano: 468 pixela');
$L['cfg_sig_maxy'] = array('Potpis, maksimalna visina', 'Zadano: 60 pixela');
$L['cfg_user_email_noprotection'] = array('Isključi osiguranje lozinkom kod promjene e-maila', '\'Ne\' preporučeno, iz sigurnosnih razloga');
$L['cfg_useremailchange'] = array('Dopusti korisnicima promjenu e-mail adrese', '\'Ne\' preporučeno, iz sigurnosnih razloga');
$L['cfg_usertextimg'] = array('Dozvoli upotrebu HTML koda i slika u potpisima', '\'Ne\' preporučeno, iz sigurnosnih razloga');
$L['cfg_usertextmax'] = array('Maksimalna dužina potpisa korisnika', 'Zadano: 300 znakova');

/**
  * Page Section
 */

$L['addnewentry'] = 'Dodaj novi unos';
$L['adm_valqueue'] = 'Čeka na validaciju';
$L['adm_structure'] = 'Strukture stranica (kategorije)';
$L['adm_extrafields_desc'] = 'Dodaj/Uredi dodatna polja';
$L['adm_sortingorder'] = 'Postavi način sortiranja za kategorije';
$L['adm_showall'] = 'Prikaži sve';
$L['adm_help_page'] = 'Stranice koje pripadaju kategoriji &quot;system&quot; nisu prikazane u javnim listama, koriste se za izradu samostalnih stranica.';

/**
  * Page Section
  * Structure Subsection
 */

$L['adm_tpl_mode'] = 'Tip teme';
$L['adm_tpl_empty'] = 'Zadano';
$L['adm_tpl_forced'] = 'Isto kao';
$L['adm_tpl_parent'] = 'Isto kao izvorna kategorija';
$L['adm_enablecomments'] = 'Omogući komentare';	// New in N-0.1.0
$L['adm_enableratings'] = 'Omogući ocjenjivanje';	// New in N-0.1.0

/**
 * Page Section
 * Extrafields Subsection
 */

$L['adm_help_pages_extrafield'] = '<b>Osnovni HTML</b> će biti automatski postavljen ako ga ostavite praznog<br /><br />
<b>Novi tagovi u tpl datotekama:</b><br /><br />
page.tpl: {PAGE_XXXXX}, {PAGE_XXXXX_TITLE}<br /><br />
page.add.tpl: {PAGEADD_FORM_XXXXX}, {PAGEADD_FORM_XXXXX_TITLE}<br /><br />
page.edit.tpl: {PAGEEDIT_FORM_XXXXX}, {PAGEEDIT_FORM_XXXXX_TITLE}<br /><br />
list.tpl: {LIST_ROW_XXXXX}, {LIST_TOP_XXXXX}<br />';

/**
  * Page Section
  * CatOrder Subsection
 */

$L['adm_fileyesno'] = 'Datoteka (da/ne)';
$L['adm_fileurl'] = 'URL datoteke';
$L['adm_filecount'] = 'Preuzimanja datoteke';
$L['adm_filesize'] = 'Veličina datoteke';

/**
 * Forums Section
 */

$L['adm_forum_structure'] = 'Struktura foruma (kategorije)';
$L['adm_forum_emptytitle'] = 'Greška: nema naslova';	// New in N-0.1.0

/**
  * Forums Section
  * Structure Subsection
 */

$L['adm_defstate'] = 'Zadano stanje';
$L['adm_defstate_0'] = 'Omotano';
$L['adm_defstate_1'] = 'Razmotano';

/**
  * Forums Section
  * Forum Edit Subsection
 */

$L['adm_forums_master'] = 'Glavna sekcija';	// New in N-0.0.1
$L['adm_diplaysignatures'] = 'Prikaži potpise';
$L['adm_enablebbcodes'] = 'Uključi BBkodove';
$L['adm_enablesmilies'] = 'Uključi emotikone';
$L['adm_enableprvtopics'] = 'Dozvoli privatne teme';
$L['adm_enableviewers'] = 'Uključi Promatrače';	// New in N-0.0.2
$L['adm_enablepolls'] = 'Uključi Ankete';	// New in N-0.0.2
$L['adm_countposts'] = 'Broji odgovore';
$L['adm_autoprune'] = 'Automatski smanji teme nakon * dana';
$L['adm_postcounters'] = 'Prekontroliraj brojila';

/**
 * Korisnici Section
 */

$L['adm_rightspergroup'] = 'Prava grupe';
$L['adm_maxsizesingle'] = 'Max veličina jedne datoteke u '.$L['PFS'].' (KB)';
$L['adm_maxsizeallpfs'] = 'Max veličina svih datoteki zajedno u '.$L['PFS'].' (KB)';
$L['adm_copyrightsfrom'] = 'Postavi ista prava kao i kod grupe';
$L['adm_rights_maintenance'] = 'Pristup stranici za vrijeme održavanja';	// New in N-0.0.2

/**
 * Korisnici Section
 * Extrafields Subsection
 */

$L['adm_help_users_extrafield'] = '<b>Osnovni HTML</b> se postavlja automatski ako ga ostavite prazno<br /><br />
<b>Novi tagovi u tpl datotekama:</b><br /><br />
users.profile.tpl: {USERS_PROFILE_XXXXX}, {USERS_PROFILE_XXXXX_TITLE}<br /><br />
users.edit.tpl: {USERS_EDIT_XXXXX}, {USERS_EDIT_XXXXX_TITLE}<br /><br />
users.details.tpl: {USERS_DETAILS_XXXXX}, {USERS_DETAILS_XXXXX_TITLE}<br /><br />
user.register.tpl: {USERS_REGISTER_XXXXX}, {USERS_REGISTER_XXXXX_TITLE}<br /><br />
forums.posts.tpl: {FORUMS_POSTS_ROW_USERXXXXX}, {FORUMS_POSTS_ROW_USERXXXXX_TITLE}<br />';

/**
 * Plug Section
 */

$L['adm_defauth_guests'] = 'Zadana prava gostiju';
$L['adm_deflock_guests'] = 'Lock mask for the guests';
$L['adm_defauth_members'] = 'Zadana prava članova';
$L['adm_deflock_members'] = 'Lock mask for the members';

$L['adm_present'] = 'Prisutno';
$L['adm_missing'] = 'Nedostaje';
$L['adm_paused'] = 'Pauzirano';
$L['adm_running'] = 'Radi';
$L['adm_partrunning'] = 'Djelomično radi';
$L['adm_partstopped'] = 'Djelomično zaustavljeno';
$L['adm_installed'] = 'Instalirano';	// New in N-0.0.6
$L['adm_notinstalled'] = 'Nije instalirano';

$L['adm_plugsetup'] = 'Plugin Postavke';	// New in N-0.0.6
$L['adm_override_guests'] = 'System override, gosti i neaktivni ne mogu administrirati';	// New in N-0.0.6
$L['adm_override_banned'] = 'System override, Blokirani';	// New in N-0.0.6
$L['adm_override_admins'] = 'System override, Administratori';	// New in N-0.0.6

$L['adm_opt_installall'] = 'Instaliraj sve';
$L['adm_opt_installall_explain'] = 'Ovo će instalirati ili resetirati sve dijelove plugina.';
$L['adm_opt_uninstallall'] = 'De-instaliraj sve</a></td>';
$L['adm_opt_uninstallall_explain'] = 'Ovo će isključiti sve dijelove plugina ali neće fizički ukloniti datoteke sa servera.';
$L['adm_opt_pauseall'] = 'Pauziraj sve';
$L['adm_opt_pauseall_explain'] = 'Ovo će pauzirati(isključiti) sve dijelove plugina.';
$L['adm_opt_unpauseall'] = 'Pokreni sve';
$L['adm_opt_unpauseall_explain'] = 'Ovo će od-pauzirati (ponovno pokrenuti/omogućiti) sve dijelove plugina.';

$L['adm_opt_setoption_warn'] = 'Postavke pronađene za ovaj plugin. Želite li instalirati sa sačuvanim postavkama?';	// New in N-0.0.2
$L['adm_opt_uninstall_warn'] = 'Možete obrisati ovaj plugin bez brisanja starih postavki(prava i opcija). Kliknite ako to želite.';	// New in N-0.0.2
$L['adm_opt_setup_missing'] = 'Greška: setup datoteka nedostaje!';	// New in N-0.0.6

$L['adm_pluginstall_msg01'] = 'Brišem prethodnu instalaciju ovog plugina...';	// New in N-0.0.6
$L['adm_pluginstall_msg02'] = 'Brišem prethodnu konfiguraciju...';	// New in N-0.0.6
$L['adm_pluginstall_msg03'] = 'Tražim setup datoteku...';	// New in N-0.0.6
$L['adm_pluginstall_msg04'] = 'Tražim dijelove...';	// New in N-0.0.6
$L['adm_pluginstall_msg05'] = 'Instaliram djelove...';	// New in N-0.0.6
$L['adm_pluginstall_msg06'] = 'Tražim konfiguracijske unose u setup datoteki...';	// New in N-0.0.6
$L['adm_pluginstall_msg07'] = 'Nisu pronađeni! Instalacija nije uspjela!';	// New in N-0.0.6
$L['adm_pluginstall_msg08'] = 'Brišem sva prethodna prava za ovaj plugin...';	// New in N-0.0.6
$L['adm_pluginstall_msg09'] = 'Postavljam prava za grupe korisnika...';	// New in N-0.0.6
$L['adm_pluginstall_msg10'] = 'Resetiram autorizacijsku kolonu za sve korisnike...';	// New in N-0.0.6
$L['adm_pluginstall_msg11'] = 'Pokrećem on-install dio setup skripte...';	// New in N-0.0.6

/**
 * Tools Section
 */

$L['adm_listisempty'] = 'Lista je prazna';

/**
  * TrashCan Section
 */

$L['adm_help_trashcan'] = 'Ovdje su prikazani podaci koji su nedavno obrisani od strane moderatora i korisnika.<br />
Izbriši: Izbriši zauvijek<br />
Obnovi: Vrati podatak natrag na korištenje<br />
<b>Pažnja</b>:<br />
- obnavljanjem teme u forumu, obnovit ćete sve odgovore koji pripadaju toj temi<br />
- obnavljanje odgovora u obrisanoj temi će obnoviti cijelu temu(ako je to moguće) i sve pripadajuće odgovore.<br />';

/**
 * Other Section
 * Comments Subsection
 */

$L['adm_comm_already_del'] = 'Komentar obrisan';		// New in N-0.0.2

/**
 * Other Section
 * PFS Subsection
 */

$L['adm_gd'] = 'GD graphical library';
$L['adm_allpfs'] = 'Sve '.$L['PFS'];
$L['adm_allfiles'] = 'Sve datoteke';
$L['adm_thumbnails'] = 'Sličice';
$L['adm_orphandbentries'] = 'Samostalni unosi u bazi';
$L['adm_orphanfiles'] = 'Samostalne datoteke';
$L['adm_delallthumbs'] = 'Izbriši sve sličice';
$L['adm_rebuildallthumbs']= 'Izbriši i ponovno stvori sve sličice';
$L['adm_help_allpfs'] = $L['PFS'].' svih registriranih korisnika';
$L['adm_nogd'] = 'GD graphical library nije podržano na ovom hostu, Cotonti neće moći stvoriti male sličice od slika. Otvorite '.$L['Configuration'].' &gt; '.$L['PFS'].' i postavite &quot;Generiranje sličica&quot; na &quot;'.$L['Disabled'].'&quot;.';

/**
 * Other Section
 * Polls Subsection
 */

$L['adm_help_polls'] = 'Ispuni obrazac i stisni &quot;Stvori&quot; gumb kako bi pokrenuli novu anketu. Prazne opcije će biti zanemarene i obrisane. Nije preporučeno uređivati anketu nakon što je započeta jer može utjecati na rezultate ankete.';	// New in N-0.0.2
$L['adm_polls_forumpolls'] = 'Ankete sa foruma (zadnje na vrhu):';	// New in N-0.0.1
$L['adm_polls_indexpolls'] = 'Ankete sa Indexa (zadnje na vrhu):';	// New in N-0.0.1
$L['adm_polls_msg916_bump'] = 'Uspješno šutnuto!';	// New in N-0.0.3
$L['adm_polls_msg916_deleted'] = 'Uspješno obrisano!';	// New in N-0.0.3
$L['adm_polls_msg916_reset'] = 'Uspješno resetirano!';	// New in N-0.0.3
$L['adm_polls_on_page'] = 'na stranici';	// New in N-0.0.2
$L['adm_polls_polltopic'] = 'Tema ankete';	// New in N-0.0.1

/**
 * Other Section
 * PM Subsection
 */

$L['adm_pm_totaldb'] = 'Privatnih poruka u bazi';
$L['adm_pm_totalsent'] = 'Ukupno PP poslano ikad';

/**
 * Other Section
 * Ratings Subsection
 */

$L['adm_ratings_already_del'] = 'Ocjena obrisana';	// New in N-0.0.3
$L['adm_ratings_totalitems'] = 'Ukupno ocjenjenih stranica';
$L['adm_ratings_totalvotes'] = 'Ukupno glasova';
$L['adm_help_ratings'] = 'Ako želite resetirati ocjenu, jednostavno je izbrišite. Bit će ponovno kreirana sa prvim novim glasom.';

/**
 * Other Section
 * Cache Subsection
 */

$L['adm_delcacheitem'] = 'Podatak izbrisan iz Cachea';	// New in N-0.0.2
$L['adm_internalcache'] = 'Interni cache';
$L['adm_purgeall_done'] = 'Cache kompletno pobrisan';	// New in N-0.0.2

/**
 * Other Section
 * BBCode Subsection
 */

$L['adm_bbcode'] = 'BBKod';
$L['adm_bbcodes'] = 'BBKodovi';
$L['adm_bbcodes_added'] = 'Uspješno dodan novi bbkod.';
$L['adm_bbcodes_clearcache'] = 'Obriši HTML cache';
$L['adm_bbcodes_clearcache_confirm'] = 'Ovo će obrisati cache za sve stranice i odgovore, nastaviti?';
$L['adm_bbcodes_clearcache_done'] = 'HTML cache je počišćen.';
$L['adm_bbcodes_confirm'] = 'Zaista želite obrisati ovaj bbkod?';
$L['adm_bbcodes_container'] = 'Container';
$L['adm_bbcodes_mode'] = 'Način';
$L['adm_bbcodes_new'] = 'Novi BBKod';
$L['adm_bbcodes_pattern'] = 'Uzorak';
$L['adm_bbcodes_postrender'] = 'Post-render';
$L['adm_bbcodes_priority'] = 'Prioritet';
$L['adm_bbcodes_removed'] = 'Uspješno uklonjen bbkod.';
$L['adm_bbcodes_replacement'] = 'Zamjena';
$L['adm_bbcodes_updated'] = 'Uspješno obnovljen bbkod.';
$L['adm_help_bbcodes'] = <<<HTM
<ul>
<li><strong>Name</strong> - Naziv BBkoda (alfanumerički znakovi i povlaka)</li>
<li><strong>Mode</strong> - Način analiziranja, jedan od slijedećih: 'str' (str_replace), 'ereg' (eregi_replace), 'pcre' (preg_replace) i 'callback' (preg_replace_callback)</li>
<li><strong>Pattern</strong> - BBkod niz ili cijelokupni izraz</li>
<li><strong>Replacement</strong> - Zamjenski niz ili regular substitution or callback body</li>
<li><strong>Container</strong> - U slučaju da je bbkod spremnik (kao npr. [bbcode]Nekakav tekst[/bbcode])</li>
<li><strong>Priority</strong> - Prioritet BBkoda od 0 do 255. BBkodovi sa nižim prioritetom su analizirani prvi, 128 je standardni prioritet.</li>
<li><strong>Plugin</strong> - Naziv plugina/dijela kojem ovaj BBKod pripada. Ostavite prazno, ovo je samo za pluginove.</li>
<li><strong>Post-render</strong> - Whether this bbcode must be applied on a pre-rendered HTML cache. Use only if your callback does some per-request calculations.</li>
</ul>
HTM;

/**
 * Other Section
 * URLs Subsection
 */

$L['adm_urls'] = 'URLs';
$L['adm_urls_area'] = 'Area';
$L['adm_urls_error_dat'] = 'Greška: datas/urltrans.dat nije moguće uređivati!';
$L['adm_urls_format'] = 'Format';
$L['adm_urls_htaccess'] = 'Presnimi .htaccess?';
$L['adm_urls_new'] = 'New Rule';
$L['adm_urls_parameters'] = 'Parameters';
$L['adm_urls_rules'] = 'URL Transformation Rules';
$L['adm_urls_save'] = 'Spremi';
$L['adm_urls_your'] = 'Your';
$L['adm_urls_callbacks'] = 'Rule contains callbacks';
$L['adm_urls_errors'] = 'You will have to add rewrite options for them manually.';
$L['adm_help_urls'] = 'On this page you can customize your URLs using simple URL Transformation Rules. Please make sure the rules are correct and there are no duplicates. Do not use spaces, tabs and other special characters in the rules. Sections and parameters are explained below.
<ol>
<li><strong>Area</strong> is script name the rule belongs to. The metasymbol (*) stands for &quot;any script&quot;.</li>
<li><strong>Parameters</strong> is a condition matched against URL parameters. It is a string, containing name-value pairs separated with &amp; and = sign used between parameter name and value. Ne ? sign in the beginning is needed. If you specify some variable here, it must be present in the URL to match the rule. You can use * which means &quot;any value&quot;, a single value, or a list of possible values separated with | sign. All values should be urlencoded. <em>Example: name=Val|Josh&amp;id=124&amp;page=*</em>.</li>
<li><strong>Format</strong> sets format of the URLs matching this rule. It is a string containing special sequences substituded with their values. Normal sequence looks like {$name} where &quot;name&quot; is the name of URL parameter (GET variable), value of which will be inserted instead of this sequence. There are several special sequences which are not from URL parameters (&quot;query string&quot;):
	<ul>
		<li><em>{$_area}</em> - script name;</li>
		<li><em>{$_host}</em> - host name from your site Main URL;</li>
		<li><em>{$_rhost}</em> - host name from the current HTTP request;</li>
		<li><em>{$_path}</em> - server-related path of your site, / if your site is in server root.</li>
	</ul>
You can also use parametrized subdomains by specifying absolute URL format like: <em>http://{$c}.site.com/{$al}.html</em>. Currently subdomains are supported for Apache webservers only.</li>
<li><strong>New Rule</strong> appends a new rule line to the table.</li>
<li><strong>Order</strong> - keep in mind that order of the rules in the table is important. URL Transformation algorithm looks up a rule for a link this way: first it fetches all rules defined for the area, then it tries to find <em>the first</em> rule that matches the parameter condition; if no matching rules found, it will try to fall back to * area and look for the first matching rule there. It is preporučeno that your default rule (with * area and * parameters) is the last of the *-area rules, or even last in the table.<br />
You can change rule order by simply dragging the rows and dropping them at desired positions. It is preporučeno to save new rules before you can change their order with drag-and-drop.</li>
<li><strong>Query String</strong> is what you usually see in most links after the question mark. It is used to pass the rest of GET parameters that you have not used in the rest of the Format string and is appended automatically in that case.</li>
<li><strong>Save</strong> button will save rules and apply changes immediately. It will also apply changes on your .htaccess (if writable) and provide you with .htaccess/IsapiRewrite4.ini/nginx.conf (depending on your server type).</li>
</ol>';

/**
 * Other Section
 * Banlist Subsection
 */

$L['adm_ipmask'] = 'IP maska';
$L['adm_emailmask'] = 'E-mail maska';
$L['adm_neverexpire'] = 'Nikad ne ističe';
$L['adm_help_banlist'] = 'Primjer IP maski: 194.31.13.41, 194.31.13.*, 194.31.*.*, 194.*.*.*<br />Primjeri e-mail maski: @hotmail.com, @yahoo (Wildcards are not supported)<br />Dozvoljena je jedna IP maska ili jedna E-mail maska(ili oboje) po jednom unosu.<br />IP adrese su filtrirane za sve prikazane stranice dok e-mail maske vrijede samo kod registracije novih korisnika.';

$L['adm_searchthisuser'] = 'Traži ovu IP adresu u bazi korisnika';
$L['adm_dnsrecord'] = 'DNS podaci za ovu adresu';

$L['alreadyaddnewentry'] = 'Novi unos dodan';	//N-0.0.2
$L['alreadyupdatednewentry'] = 'Unos obnovljen';	//N-0.0.2
$L['alreadydeletednewentry'] = 'Unos obrisan';	//N-0.0.2

/**
 * Other Section
 * Hits Subsection
 */

$L['adm_byyear'] = 'Po godini';
$L['adm_bymonth'] = 'Po mjesecu';
$L['adm_byweek'] = 'Po tjednu';

$L['adm_ref_lowhits'] = 'Obriši unose koji imaju manje od 5 posjeta';
$L['adm_maxhits'] = 'Maksimalan broj posjeta koji je ostvaren je %1$s, %2$s stranica prikazano danas.';

/**
 * Other Section
 * Referers Subsection
 */

$L['adm_ref_prune'] = 'Očišćeno';
$L['adm_ref_prunelowhits'] = 'Referali sa brojem posjetitelja manjim od 5 su uspješno obrisani';

/**
 * Other Section
 * Log Subsection
 */

$L['adm_log'] = 'System log';
$L['adm_infos'] = 'Informacije';
$L['adm_versiondclocks'] = 'Verzije i satovi';
$L['adm_checkcoreskins'] = 'Provjeri datoteke jezgre i tema';
$L['adm_checkcorenow'] = 'Provjeri datoteke jezgre odmah!';
$L['adm_checkingcore'] = 'Provjeravam datoteke jezgre...';
$L['adm_checkskins'] = 'Provjeri prisutnost datoteka u temama';
$L['adm_checkskin'] = 'Provjeravam TPL datoteke za temu';
$L['adm_checkingskin'] = 'Provjeravam temu...';
$L['adm_hits'] = 'Posjeta';
$L['adm_check_ok'] = 'Ok';
$L['adm_check_missing'] = 'Nedostaje';

/**
 * Other Section
 * Infos Subsection
 */

$L['adm_phpver'] = 'PHP verzija';
$L['adm_zendver'] = 'Zend verzija';
$L['adm_interface'] = 'Sučelje između webservera i PHP-a';
$L['adm_os'] = 'Operacijski sustav';
$L['adm_clocks'] = 'Satovi';
$L['adm_time1'] = '#1: Raw server time';
$L['adm_time2'] = '#2: GMT vrijeme servera';
$L['adm_time3'] = '#3: GMT vrijeme + server naknadno (Cotonti veza)';
$L['adm_time4'] = '#4: Vaše lokalno vrijeme, namješteno prema vašem profilu';
$L['adm_help_versions'] = 'Namjesti vremensku zonu servera kako bi sat #3 bio pravilno postavljen.<br />
Sat #4 ovisi o vremenskoj zoni postavljenoj u vašem profilu.<br />
Satove #1 i #2  Cotonti ignorira.';

/**
 * Common Entries
 */

$L['adm_area'] = 'Area';
$L['adm_clicktoedit'] = '(Uredi)';
$L['adm_confirm'] = 'Pritisni ovaj gumb za potvrdu: ';
$L['adm_done'] = 'Gotovo';
$L['adm_failed'] = 'Neuspješno';
$L['adm_from'] = 'Od';
$L['adm_more'] = 'Više alata...';
$L['adm_purgeall'] = 'Obriši sve';
$L['adm_queue_unvalidated'] = 'Poslano na validaciju';	// New in N-0.0.3
$L['adm_queue_validated'] = 'Potvrđene';	// New in N-0.0.3
$L['adm_required'] = '(Obavezno)';
$L['adm_setby'] = 'Postavio';
$L['adm_to'] = 'Za';
$L['adm_totalsize'] = 'Ukupna veličina';
$L['adm_warnings'] = 'Upozorenja';

$L['editdeleteentries'] = 'Uredi ili obriši unose';
$L['viewdeleteentries'] = 'Pregledaj ili obriši unose';

/**
 * Extra Fields (Common Entries for Pages & Korisnici)
 */

$L['adm_extrafields'] = 'Dodatna polja';
$L['adm_extrafield_added'] = 'Uspješno dodano novo dodatno polje.';
$L['adm_extrafield_not_added'] = 'Greška! Novo dodatno polje nije dodano.';
$L['adm_extrafield_updated'] = 'Uspješno obnovljeno dodatno polje.';
$L['adm_extrafield_not_updated'] = 'Greška! Dodatno polje nije obnovljeno.';
$L['adm_extrafield_removed'] = 'Uspješno obrisano dodatno polje.';
$L['adm_extrafield_not_removed'] = 'Greška! Dodatno polje nije obrisano.';
$L['adm_extrafield_confirmdel'] = 'Zaista obriši ovo dodatno polje? Svi sadržani podaci će biti obrisani!';
$L['adm_extrafield_confirmupd'] = 'Zaista obnovi ovo dodatno polje? Neki podaci se mogu izgubiti!';

$L['extf_Name'] = 'Naziv';
$L['extf_Type'] = 'Vrsta polja';
$L['extf_Base_HTML'] = 'Osnovni HTML';
$L['extf_Page_tags'] = 'Tagovi';
$L['extf_Description'] = 'Opis (_TITLE)';

$L['adm_extrafield_new'] = 'Novo dodatno polje';
$L['adm_extrafield_noalter'] = 'Ne dodavajte polje u bazu, jednostavno ga registirajte kao dodatno';
$L['adm_extrafield_selectable_values'] = 'Opcije na izbor (odvojene zarezom):';
$L['adm_help_extrafield'] = 'Savjet: Polje &quot;Osnovni HTML&quot; je automatski postavljeno ako ga ostavite prazno i stisnete Obnovi.';

/**
 * Help messages that still don't work
 */

$L['adm_help_cache'] = 'Nije dostupno';
$L['adm_help_check1'] = 'Nije dostupno';
$L['adm_help_check2'] = 'Nije dostupno';
$L['adm_help_config']= 'Nije dostupno';
$L['adm_help_forums'] = 'Nije dostupno';
$L['adm_help_forums_structure'] = 'Nije dostupno';
$L['adm_help_pfsfiles'] = 'Nije dostupno';
$L['adm_help_pfsthumbs'] = 'Nije dostupno';

?>