<?php
/* ====================
Copyright (c) 2008, Vladimir Sibirov.
All rights reserved. Distributed under BSD License.
[BEGIN_SED_EXTPLUGIN]
Code=reviews
Part=page
File=reviews.page
Hooks=page.tags
Tags=page.tpl:{PAGE_REVIEWS_TOP},{PAGE_REVIEWS_TOP_COUNT},{PAGE_REVIEWS_TOP_LATEST_DATE},{PAGE_REVIEWS_TOP_RECOMMENDED},{PAGE_REVIEWS_TOP_AVG_PRICE},{PAGE_REVIEWS_TOP_RATING},{PAGE_REVIEWS_DISPLAY},{PAGE_REVIEWS_COUNT},{PAGE_REVIEWS_LATEST_DATE},{PAGE_REVIEWS_RECOMMENDED},{PAGE_REVIEWS_AVG_PRICE},{PAGE_REVIEWS_CURRENCY},{PAGE_REVIEWS_RATING},{PAGE_REVIEWS_STARS},{PAGE_REVIEWS_XRATE},{PAGE_REVIEWS_TOP_XRATE}
Order=10
[END_SED_EXTPLUGIN]
==================== */
defined('SED_CODE') or die('Wrong URL.');

$db_reviews = isset($db_reviews) ? $db_reviews : $db_x . 'reviews';

// Get rating types
$tmp = preg_split('#\r?\n#', $cfg['plugin']['reviews']['rates']);
$xrates = array();
foreach ($tmp as $xr)
{
	if (trim($xr, "\r\n\t ") != '')
		$xrates[] = trim($xr, "\r\n\t ");
}

require_once sed_langfile('reviews');

$d_rv = sed_import('drv', 'G', 'INT');
if (empty($d_rv))
	$d_rv = 0;
$perpage = $cfg['plugin']['reviews']['rows'];
$adm = sed_auth('plug', 'reviews', 'A');

$sql_ex = '';
for ($i = 1; $i <= count($xrates); $i++)
	$sql_ex .= ", AVG(rw_rate$i) AS rw_rate$i";

$rv_sql = sed_sql_query("SELECT COUNT(*) AS rw_cnt, MAX(rw_date) AS rw_max, COUNT(rw_recommend) AS rw_rec, AVG(rw_price) AS rw_price, AVG(rw_rating) AS rw_rating$sql_ex FROM $db_reviews");
$stat = sed_sql_fetcharray($rv_sql);

// Get review stats
$t->assign(array(
	'PAGE_REVIEWS_TOP' => $L['Reviews'],
	'PAGE_REVIEWS_TOP_COUNT' => $L['Total_reviews'],
	'PAGE_REVIEWS_TOP_LATEST_DATE' => $L['Latest_review_date'],
	'PAGE_REVIEWS_TOP_RECOMMENDED' => $L['Recommended'],
	'PAGE_REVIEWS_TOP_AVG_PRICE' => $L['Avg_price'],
	'PAGE_REVIEWS_TOP_RATING' => $L['Overall_rating'],
	'PAGE_REVIEWS_COUNT' => $stat['rw_cnt'],
	'PAGE_REVIEWS_LATEST_DATE' => @date($cfg['dateformat'], $stat['rw_max'] + $usr['timezone'] * 3600),
	'PAGE_REVIEWS_RECOMMENDED' => $stat['rw_cnt'] > 0 ? round($stat['rw_rec'] / $stat['rw_cnt'], 2) * 100 : 0,
	'PAGE_REVIEWS_AVG_PRICE' => round($stat['rw_price'], $cfg['plugin']['reviews']['ppc']),
	'PAGE_REVIEWS_CURRENCY' => $cfg['plugin']['reviews']['cur'],
	'PAGE_REVIEWS_RATING' => round($stat['rw_rating'], $cfg['plugin']['reviews']['rpc']),
	'PAGE_REVIEWS_STARS' => '<img src="skins/' . $skin . '/img/system/vote' . round($stat['rw_rating']) . '.gif" alt="" />'
));

for ($i = 0; $i < count($xrates); $i++)
{
	$t->assign(array(
		'PAGE_REVIEWS_TOP_XRATE' => $xrates[$i],
		'PAGE_REVIEWS_XRATE' => round($stat['rw_rate' . ($i + 1)], $cfg['plugin']['reviews']['rpc'])
	));
	$t->parse('MAIN.PAGE_REVIEWS_XROW');
}

// Render reviews on page
$rv_sql = sed_sql_query("SELECT r.*, u.user_name, u.user_text, u.user_maingrp, u.user_avatar, u.user_country, u.user_occupation, u.user_location, u.user_website, u.user_gender, u.user_birthdate, u.user_postcount
FROM $db_reviews AS r LEFT JOIN $db_users AS u ON r.rw_user = u.user_id
WHERE rw_page = $id ORDER BY rw_id {$cfg['plugin']['reviews']['order']} LIMIT $d_rv,$perpage");
$rv_t = new XTemplate(sed_skinfile('reviews', true));

$pag_url = empty($al) ? sed_url('page', "id=$id") : sed_url('page', "al=$al");
list($pag_prev, $pag_next) = sed_pagination_pn($pag_url, $d_rv, $stat['rw_cnt'], $perpage, 'drv');

$rv_t->assign(array(
	'REVIEWS_PAGNAV' => sed_pagination($pag_url, $d_rv, $stat['rw_cnt'], $perpage, 'drv'),
	'REVIEWS_PAGE_PREV' => $pag_prev,
	'REVIEWS_PAGE_NEXT' => $pag_next,
	'REVIEWS_TOP_CURRENCY' => $cfg['plugin']['reviews']['cur']
));

while ($row = sed_sql_fetcharray($rv_sql))
{
	if ($adm || $row['rw_user'] == $usr['id'])
		$pag_adm = '<a href="' . sed_url('plug', 'e=reviews&act=edit&id=' . $row['rw_id']) . '">' . $L['Edit']
		. '</a> <a href="' . sed_url('plug', 'e=reviews&act=del&id=' . $row['rw_id']) . '">' . $L['Delete'] . '</a>';
	else
		$pag_adm = '';
	$rv_t->assign(array(
		'REVIEWS_ROW_ID' => $row['rw_id'],
		'REVIEWS_ROW_DATE' => @date($cfg['dateformat'], $row['rw_date'] + $usr['timezone'] * 3600),
		'REVIEWS_ROW_RECOMMENDED' => $row['rw_recommend'] ? $L['Yes'] : $L['No'],
		'REVIEWS_ROW_TEXT' => sed_parse($row['rw_text']),
		'REVIEWS_ROW_PROS' => htmlspecialchars($row['rw_pros']),
		'REVIEWS_ROW_CONS' => htmlspecialchars($row['rw_cons']),
		'REVIEWS_ROW_PRICE' => round($row['rw_price'], 2),
		'REVIEWS_ROW_RATING' => $row['rw_rating'],
		'REVIEWS_ROW_STARS' => '<img src="skins/' . $skin . '/img/system/stars' . round($row['rw_rating']) . '.gif" alt="" />',
		'REVIEWS_ROW_POSTERNAME' => sed_build_user($row['rw_user'], htmlspecialchars($row['user_name'])),
		'REVIEWS_ROW_POSTERID' => $row['rw_user'],
		'REVIEWS_ROW_MAINGRP' => sed_build_group($row['user_maingrp']),
		'REVIEWS_ROW_MAINGRPID' => $row['user_maingrp'],
		'REVIEWS_ROW_MAINGRPSTARS' => sed_build_stars($sed_groups[$row['user_maingrp']]['level']),
		'REVIEWS_ROW_MAINGRPICON' => sed_build_userimage($sed_groups[$row['user_maingrp']]['icon']),
		'REVIEWS_ROW_USERTEXT' => $row['user_text'],
		'REVIEWS_ROW_AVATAR' => sed_build_userimage($row['user_avatar']),
		'REVIEWS_ROW_GENDER' => $row['user_gender'] = ($row['user_gender'] == '' || $row['user_gender'] == 'U') ? '' : $L["Gender_" . $row['user_gender']],
		'REVIEWS_ROW_COUNTRY' => $sed_countries[$row['user_country']],
		'REVIEWS_ROW_COUNTRYFLAG' => sed_build_flag($row['user_country']),
		'REVIEWS_ROW_WEBSITE' => sed_build_url($row['user_website'], 36),
		'REVIEWS_ROW_WEBSITERAW' => $row['user_website'],
		'REVIEWS_ROW_LOCATION' => htmlspecialchars($row['user_location']),
		'REVIEWS_ROW_OCCUPATION' => htmlspecialchars($row['user_occupation']),
		'REVIEWS_ROW_AGE' => $row['user_age'],
		'REVIEWS_ROW_POSTCOUNT' => $row['user_postcount'],
		'REVIEWS_ROW_ADMIN' => $pag_adm
	));
	for ($i = 0; $i < count($xrates); $i++)
	{
		$rv_t->assign(array(
			'REVIEWS_ROW_XROW_TOP' => $xrates[$i],
			'REVIEWS_ROW_XROW_XRATE' => $row['rw_rate' . ($i + 1)]
		));
		$rv_t->parse('MAIN.REVIEWS_ROW.REVIEWS_ROW_XROW');
	}
	$rv_t->parse('MAIN.REVIEWS_ROW');
}
sed_sql_freeresult($rv_sql);

$pag_selectbox = '<option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10" selected="selected">10</option>';

for ($i = 0; $i < count($xrates); $i++)
{
	$rv_t->assign(array(
		"REVIEWS_FORM_XROW_TOP" => $xrates[$i],
		"REVIEWS_FORM_XROW_XRATE" => '<select name="rate' . ($i + 1) . '">' . $pag_selectbox . '</select>'
	));
	$rv_t->parse('MAIN.REVIEWS_FORM.REVIEWS_FORM_XROW');
}

if ($usr['id'] > 0)
{
	// Review input form
	$rv_t->assign(array(
		'REVIEWS_FORM_ACTION' => sed_url('plug', 'e=reviews&act=add&id=' . $id),
		'REVIEWS_FORM_RATING' => '<select name="rating">' . $pag_selectbox . '</select>',
		'REVIEWS_FORM_RECOMMEND' => '<select name="recommend"><option value="1">' . $L['Yes'] . '</option><option value="0">' . $L['No'] . '</option></select>',
		'REVIEWS_FORM_TEXT' => '<textarea rows="12" cols="50" name="rtext" class="editor">' . htmlspecialchars($rtext) . '</textarea>'
	));
	$rv_t->parse('MAIN.REVIEWS_FORM');
}

$rv_t->parse('MAIN');
$t->assign('PAGE_REVIEWS_DISPLAY', $rv_t->text('MAIN'));

?>