<?PHP

/* ====================
Seditio - Website engine
Copyright Neocrome
http://www.neocrome.net
[BEGIN_SED]
File=plugins/faq/inc/functions.php
Version=2.5
Updated=2008-Apr-21
Type=Plugin
Author=T3-Design
Description=T3 Faq Functions
[END_SED]
==================== */

if (!defined('SED_CODE')) { die('Wrong URL.'); }

if (!$faq_cat)
{
	$faq_cat = faq_cache();
	sed_cache_store('faq_cat', $faq_cat, 99999);
}

/* ------------------ */

function faq_catcount($catid)
{
	global $faq_cat;

	$total		=	$faq_cat[$catid]['total'];
	$lastupdate	=	$faq_cat[$catid]['last_update'];
	$chck 		= 	$faq_cat[$catid]['path'];
	$chcklen 	=  	strlen($chck);
	
	foreach($faq_cat as $i => $x)
	{
		if (substr($x['path'], 0, $chcklen+1) == $chck.'.' AND $chck <> $x['path'])
		{
			$total += $x['total'];	
		}
	}
	return $total;
}

/* ------------------ */

function faq_update_counters($cats)
{
	global $db_faq_quest, $db_faq_cats, $faq_cat;
	
	if($cats == 'all')
	{
		foreach($faq_cat as $key => $value)
		{
			$categories[] = $key;
		}
	}
	elseif(!is_array($cats)) 
	{
		$categories = array($cats);
	}
	else
	{
		$categories = $cats;
	}
	$categories = array_unique($categories);
	
	foreach($categories as $cat)
	{
		if(intval($cat) > 0)
		{
			$sql = sed_sql_query("SELECT COUNT(*) FROM $db_faq_quest WHERE faq_cat_id = '".$cat."'");
			$total = sed_sql_result($sql, 0, "COUNT(*)");
			$faq_cat[$cat]['total'] = $total;
			sed_sql_query("UPDATE $db_faq_cats SET faq_cat_total = '".$faq_cat[$cat]['total']."' WHERE faq_cat_id = '".$cat."'");
		}
	}
	sed_cache_store('faq_cat', $faq_cat, 99999);
	return true;
}

/* ------------------ */

function faq_cache()
{
	global $db_faq_cats, $cfg, $L;

	$res = array();
	$sql = mysql_query("SELECT * FROM $db_faq_cats ORDER BY faq_cat_path ASC");

	while ($row = sed_sql_fetcharray($sql))
	{
		$path2 = strrpos($row['faq_cat_path'], '.');

		if ($path2>0)
		{
			$path1 = substr($row['faq_cat_path'],0,($path2));
			$path[$row['faq_cat_path']] 	= 	$path[$path1].'.'.$row['faq_cat_id']; //code
			$tpath[$row['faq_cat_path']] 	= 	$tpath[$path1].' '.$cfg['separator'].' '.$row['faq_cat_title'];
		}
		else
		{
			$path[$row['faq_cat_path']] 	= 	$row['faq_cat_id']; //code
			$tpath[$row['faq_cat_path']] 	= 	$row['faq_cat_title'];
		}

		$res[$row['faq_cat_id']] = array(
			'path' => $path[$row['faq_cat_path']],
			'tpath' => $tpath[$row['faq_cat_path']],
			'rpath' => $row['faq_cat_path'],
			'title' => $row['faq_cat_title'],
			'desc' => $row['faq_cat_desc'],
			'icon' => $row['faq_cat_icon'],
			'total' => $row['faq_cat_total'],
			);
	}
	return($res);
}

/* ------------------ */

function faq_catpath($id, $mask)
{
	global $faq_cat, $cfg;

	$pathcodes = explode('.', $faq_cat[$id]['path']);
	foreach($pathcodes as $k => $x)
		{ $tmp[]= sprintf($mask, $x, $faq_cat[$x]['title']); }
	$result = implode(' '.$cfg['separator'].' ', $tmp);
	return ($result);
}

/* ------------------ */

function faq_selectcat($check, $name, $size=1, $hideprivate=TRUE, $admin_cp=FALSE)
{
	global $faq_cat, $L;
	$is_there_any = 0;
	$result =  "<select name=\"$name\" size=\"$size\">";

	foreach($faq_cat as $i => $x)
	{
		$display = ($hideprivate) ? sed_auth('faq', $i, 'W') : TRUE;
		if (sed_auth('faq', $i, 'R') && $i!='all' && $display)
		{
			$selected = ($i==$check) ? "selected=\"selected\"" : '';
			$result .= "<option value=\"".$i."\" $selected> ".$x['tpath']."</option>";
			$is_there_any++;
		}
	}
	if($admin_cp==TRUE && $is_there_any==0) return;
	sed_block($is_there_any);
	$result .= "</select>";
	return($result);
}

/* ------------------ */

function faq_store_parsed($row)
{
	global $db_faq_parsed;
	
	if($row['faq_type'] == 0)
	{
		$row['faq_answer'] = str_replace('[more]', '[faqmore]', $row['faq_answer']);
		$row['faq_answer'] = sed_parse(sed_cc($row['faq_answer']), T3FAQ_BBCODE, T3FAQ_SMILIES, T3FAQ_LINEBRAKE);
		$row['faq_answer'] = str_replace('[faqmore]', '[more]', $row['faq_answer']);
		$sql = sed_sql_query("REPLACE INTO $db_faq_parsed (answer_id, answer_html) VALUES ('".$row['faq_id']."', '".sed_sql_prep($row['faq_answer'])."')");
		return $row['faq_answer'];
	}
}

/* ------------------ */

function faq_answer($row, $mode = 'list')
{
	global $L;
	
	if($row['faq_type'] == 1) //Parse Html
	{
		$answer = $row['faq_answer'];
	}
	else //BBcode Pre-Parsed 85% Of the performance boost in v2.5 is because of this.
	{
		
		$answer = empty($row['answer_html'])? faq_store_parsed($row) : $row['answer_html'];		
	}
	if($mode == 'list')
	{
		$readmore = strpos($answer, "[more]");
		if ($readmore > 0)
		{
			$answer  = substr($answer, 0, $readmore);
			$answer  .= '<br /><a href="'.$row['faq_url'].'">'.$L['ReadMore'].'</a>';
		}
	}
	else
	{
		$answer = str_replace('[more]', '', $answer);
	}
	return $answer;
}
/* ------------------ */

function faq_alias($al, $id)
{
	$result = (empty($al)) ? sed_url('plug', "e=faq&q=$id") : sed_url('plug', "e=faq&al=$al");
	return($result);
}

/* ------------------ */

function faq_author($user_id, $user_name, $asked_flag, $link=TRUE)
{
	global $L;
	$author = ($asked_flag==1) ? $L['faq_asked_by'] : $L['faq_submitted_by'];
	$author .= ($link) ? sed_build_user($user_id, sed_cc($user_name)) : sed_cc($user_name);
	return($author);
}

/* ------------------ */

function faq_date($faq_date, $edit_flaq, $case='full')
{
	global $L, $cfg, $usr, $sys;
	

	if($case=='full')
	{
		$date = @date(T3FAQ_DATELONG, $faq_date + $usr['timezone'] * 3600);
		$date_hint = ($edit_flaq>0) ? $L['faq_question_updated'].$date : $L['faq_question_created'].$date;
		$date_hint = ($faq_date==0) ? $L['faq_question_updated'].$L['faq_question_updated_never'] : $date_hint;
	}
	elseif($case=='hint')
	{
		$date_hint = ($faq_date+T3FAQ_NEWMARK*86400>$sys['now']) ? $L['faq_question_new_hint']: $L['faq_question_old_hint'];
		$date_hint = ($edit_flaq>0) ? $L['faq_question_updated_hint'] : $date_hint;
	}
	elseif($case=='date')
	{
		$date_hint = @date(T3FAQ_DATESHORT, $faq_date + $usr['timezone'] * 3600);
	}
	return($date_hint);
}

/* ------------------ */

function faq_pagination($totalitems, $perpage, $address, $pagenumber)
{	global $L, $sed_img_left, $sed_img_right;

	if($totalitems <= $perpage) return $pagnav;
	if ($pagenumber>0)
	{
		$prev = $pagenumber - $perpage;
		if ($prev<0) { $prev = 0; }
		$prev = "<a href=\"".$address."&amp;d=$prev\">".$L['Previous']." $sed_img_left</a>"; 
	}

	if (($pagenumber + $perpage)<$totalitems)
	{
		$next = $pagenumber + $perpage;
		$next = "<a href=\"".$address."&amp;d=$next\">$sed_img_right ".$L['Next']."</a>"; 
	}

	$totalpages = ceil($totalitems / $perpage);
	$currentpage = $pagenumber / $perpage;

	for ($i = 0; $i < $totalpages; $i++)
	{
		$j = $i * $perpage;
		if ($i==$currentpage)
		{ 
			$pagination .= "&gt; <a href=\"".$address.$j."\">".($i+1)."</a> &lt; "; 
		}
		elseif (is_int(($i+1)/5) || $i<10 || $i+1==$totalpages)
		{ 
			$pagination .= "[<a href=\"".$address.$j."\">".($i+1)."</a>] "; 
		}
	}

	$pagnav = $prev;
	$pagnav .= $pagination;
	$pagnav .= $next;

	return $pagnav;
}

/* ------------------ */

function faq_columns($ii)
{
	if (T3FAQ_COLUMNS==1)
	{
		$tr = '<tr>';
		$tr2 = '</tr>';
	}
	elseif ($ii==1)
	{
		$tr = '<tr>';
		$tr2 = '';
	}
	elseif ($ii==T3FAQ_COLUMNS)
	{
		$ii=0;
		$tr = '';
		$tr2 = '</tr>';
	}
	else
	{
		$tr = '';
		$tr2 = '';
	}

	return array($tr, $tr2, $ii);
}

/* ------------------ */

function faq_jumpbox()
{
	global $cid, $faq_cat, $L;	
	$jumpbox = "<form id=\"jump\" action=\"\" style=\"display:inline;\">";
	$jumpbox .= "<select name=\"jumpbox\" size=\"1\" onchange=\"redirect(this)\">";
	$jumpbox .= "<option value=\"".sed_url('plug', 'e=faq')."\">".$L['faq']."</option>";

	foreach($faq_cat as $i => $x)
		{
			if (sed_auth('faq', $i, 'R'))
			{
				unset($spaces);
				$selnav_levels = explode (".", $x['rpath']);
				$selnav_depth = count($selnav_levels);
				for ($de = 1; $de < $selnav_depth; $de++) $spaces .= "&nbsp;&nbsp;&nbsp;";
				$spaces .= "&raquo;";
				$selected = ($i==$cid) ? "selected=\"selected\"" : '';
				$jumpbox .= "<option value=\"".sed_url('plug', "e=faq&cid=".$i)."\" $selected>$spaces ".$x['title']."</option>";
			}
		}
	$jumpbox .= "</select></form>";
	return $jumpbox;
}

/* ------------------ */

function faq_sortform($o, $w, $cid)
{
	global $L;
	
	$sort_options	= array('order' => $L['faq_default'], 
							'date' 	=> $L['faq_date'], 
							'views' => $L['faq_views']);
	$order_options	= array('asc'	=> $L['faq_ascending'], 
							'desc' 	=> $L['faq_descending']);
	
	$res = $L['faq_sort_by']." <form action=\"".sed_url('plug')."\" method=\"get\" style=\"display:inline;\">";
	$res .= "<input type=\"hidden\" name=\"e\" value=\"faq\" />";
	$res .= "<input type=\"hidden\" name=\"cid\" value=\"$cid\" />";
	

	$res .= "<select name=\"o\">";	
	foreach ($sort_options as $k => $x)
	{
		$selected = ($k == $o) ? "selected=\"selected\"" : '';
		$res .= "<option value=\"$k\" $selected>$x</option>";
	}
	$res .= "</select> ";
	$res .= "<select name=\"w\">";
	foreach ($order_options as $k => $x)
	{
		$selected = ($k == $w) ? "selected=\"selected\"" : '';
		$res .= "<option value=\"$k\" $selected>$x</option>";
	}
	$res .= "</select> ";
	$res .= "<input type=\"submit\" class=\"button\" value=\"".$L['faq_go']."\" />";
	$res .= "</form>";
	return $res;
}

/* ------------------ */

function faq_update_comments($id = 'all')
{
	global $db_com, $db_faq_quest;

	$codes = array();
	
	if(intval($id) > 0)
	{
		$codes[] = 'f'.intval($id);
	}
	else
	{
		$sql = sed_sql_query("SELECT faq_id FROM $db_faq_quest WHERE 1");
		while ($row = sed_sql_fetcharray($sql))	{	$codes[] = 'f'.$row['faq_id'];	}
	}

	foreach($codes as $code)
	{
		$nbcomment = sed_sql_result(sed_sql_query("SELECT COUNT(*) FROM $db_com where com_code='$code'"), 0, "COUNT(*)");
		sed_sql_query("UPDATE $db_faq_quest SET faq_comments='".$nbcomment."' WHERE faq_id='".substr($code, 1)."'");
	}
	return true;
}

/* ------------------ */

function faq_update_rating($id = 'all')
{
	global $db_faq_quest, $db_ratings;
	
	if(intval($id) > 0)
	{
		$codes[] = 'f'.intval($id);
	}
	else
	{
		$sql = sed_sql_query("SELECT faq_id FROM $db_faq_quest WHERE 1");
		while ($row = sed_sql_fetcharray($sql))	{	$codes[] = 'f'.$row['faq_id'];	}
	}
	
	$sql = sed_sql_query("SELECT rating_average, rating_code FROM $db_ratings WHERE rating_code IN ('".implode("','", $codes)."')");
	while ($row = sed_sql_fetcharray($sql)) 
	{	
		sed_sql_query("UPDATE $db_faq_quest SET faq_ratings='".$row['rating_average']."' WHERE faq_id='".substr($row['rating_code'], 1)."'");
	}

	return true;
}

/* ------------------ */

function faq_fetch_quests($allowed, $mode, $count)
{
	if(empty($allowed)) return;
	if(!$count)			return;
	if($mode == 'most_ratings' AND !T3FAQ_RATINGS) return;
	if($mode == 'most_comment' AND !T3FAQ_COMMENTS) return;
	
	global $t, $db_faq_quest, $L, $usr, $faq_cat, $keyword, $faq_id;
	
	$sql = sed_sql_query("SELECT faq_id, faq_cat_id, faq_question, faq_alias, faq_date
	".($mode == 'most_viewed' 	? ', faq_views' 	: '')."
	".($mode == 'most_recent' 	? ', faq_edit_flag' : '')."
	".($mode == 'most_ratings' 	? ', faq_ratings' 	: '')."
	".($mode == 'most_comment' 	? ', faq_comments' 	: '')."
	".($mode == 'most_similar' 	? ', faq_views, MATCH(faq_question) AGAINST("'.$keyword.'") AS score' 	: '')."	
	FROM $db_faq_quest WHERE faq_cat_id IN ('".implode("','", $allowed)."') 
	AND faq_state = '0' 
	".($mode == 'most_ratings' 	? 'AND faq_ratings > 0' 	: '')."
	".($mode == 'most_comment' 	? 'AND faq_comments > 0' 	: '')."
	".($mode == 'most_similar' 	? 'AND faq_id <> '.$faq_id.' AND MATCH(faq_question) AGAINST("'.$keyword.'")' 	: '')."
	".($mode == 'most_viewed' 	? 'ORDER BY faq_views DESC ' 	: '')."
	".($mode == 'most_recent' 	? 'ORDER BY faq_date DESC ' : '')."
	".($mode == 'most_ratings' 	? 'ORDER BY faq_ratings DESC ' 	: '')."
	".($mode == 'most_comment' 	? 'ORDER BY faq_comments DESC ' 	: '')."
 	LIMIT ".intval($count)."");

	$jj=0;
	while ($row = sed_sql_fetcharray($sql)) 
	{
		$jj++;	
		$row['faq_url'] 	= 	faq_alias($row['faq_alias'], $row['faq_id']);
		

		switch($mode)
		{
			case 'most_viewed':
			case 'most_similar':
				$row['faq_extra'] = sprintf($L['faq_viewed'], $row['faq_views']);
			break;
		
			case 'most_recent':
				$row['faq_extra'] = faq_date($row['faq_date'], $row['faq_edit_flag'], 'hint');	
			break;
			
			case 'most_ratings':
				$row['faq_extra'] = '<a href="'.$row['faq_url'].'&amp;ratings=1"><img src="skins/'.$usr['skin'].'/img/system/vote'.round($row['faq_ratings'], 0).'.gif" alt="" /></a>';
			break;
			
			case 'most_comment':
				$row['faq_extra'] = '<a href="'.$row['faq_url'].'&amp;comments=1"><img src="skins/'.$usr['skin'].'/img/system/icon-comment.gif" alt="" /> ('.$row['faq_comments'].')</a>';
			break;
		}

		$t->assign(array(
			"QA_ROW_CAT" 		=> 	$faq_cat[$row['faq_cat_id']]['title'],
			"QA_ROW_CAT_ID"		=>	$row['faq_cat_id'],
			"QA_ROW_URL" 		=> 	$row['faq_url'],
			"QA_ROW_DATE" 		=> 	faq_date($row['faq_date'], $row['faq_edit_flag'], 'date'),
			"QA_ROW_EXTRA" 		=> 	$row['faq_extra'],
			"QA_ROW_ODDEVEN" 	=> 	sed_build_oddeven($jj),
			"QA_ROW_QUESTION" 	=>  $row['faq_question'],
			));
		$t->parse("MAIN.MODULE.MODULE_ROW");
	}
	if($jj>0)
	{ 
		$t->assign("MODULE_TITLE", $L['faq_module'][$mode]);
		$t->parse("MAIN.MODULE"); 
	}
}

/* ------------------ */

function T3_FAQ()
{
	global $fver;
	echo "\n<!--T3 Faq v$fver Copyright � T3-Design.com-->\n";
}

?>