<?php
/* ====================
 * [BEGIN_COT_EXT]
 * Hooks=standalone
 * [END_COT_EXT]
==================== */

/**
 * Browse Gallery files
 *
 * @package Cotonti
 * @version 1.0
 * @author 2basix automatisering (ez)
 * @credits and thanks: Gert Hengeveld for the browser part (browser plugin)
 */

defined('COT_CODE') or die('Wrong URL.');

require_once cot_incfile('pfs', 'module');
require_once $cfg['plugin']['ezgallery']['imgpath'].'/icons.php';

	/**
	 * Get readable filesize
	 *
	 * @param int $size Number of bytes
	 * @return string
	 */
	function getFileSize($size)
	{
		if ($size === 0) return "0 bytes";
		if (!$size) return '';
		$units = array ('B', 'KB', 'MB', 'GB', 'TB', 'PB');
		$i = min(floor(log($size, 1024)), count($units)-1);
		$size = $size/pow(1024, $i);
		$decs = max(2 - floor(log10($size)), 0);
		$shift = pow(10, $decs);
		$value = floor($size*$shift)/$shift;
		return (sprintf('%.'.$decs.'f %s', $value, $units[$i+1]));
	}

$folderid = cot_import('folderid', 'G', 'INT');

/* extra filter for public folders */
if ($usr['id']<=0) {
	/* if it is NOT a logged in user, show only the public galleries */
	$extrafilter=" AND pff_ispublic=1";
} else {
	/* show all folders ! */
	$extrafilter="";
}

if(!$folderid) {
	/* if no folder id is known, show the browser */
	$t = new XTemplate(cot_tplfile('ezgallery.browser', 'plug'));
} else {
	/* a folder is choosen, show the gallery */
	$t = new XTemplate(cot_tplfile('ezgallery', 'plug'));
}
	
if(!$folderid)
{
	/* Browser SECTION */
	$t->assign(array(
		'TITLE' => '<a href="'.cot_url('plug', 'e=ezgallery').'">'.$L['ezgal_browser'].'</a>',
		'FOLDERNAME' => $L['root'],
		'FOLDERDESC' => ''
	));
}
else
{
	/* gallery SECTION */
	/* a folder is choosen, so there are the MAIN tags */
	$sql = $db->query("SELECT * FROM $db_pfs_folders WHERE pff_id=".(int)$folderid." AND pff_isgallery=1".$extrafilter);
	if($res = $sql->fetch())
	{
		$t->assign(array(
			'TITLE' => '<a href="'.cot_url('plug', 'e=ezgallery').'">'.$L['Gallery'].'</a> '.$cfg['separator'].' <a href="'.cot_url('plug', 'e=ezgallery&folderid='.(int)$res['pff_id']).'">'.$res['pff_title'].'</a>',
			'FOLDERNAME' => $res['pff_title'],
			'FOLDERDESC' => $res['pff_desc']
		));
	}
	else
	{
		cot_redirect(cot_url('plug', 'e=ezgallery', '', true));
	}
}

if(!$folderid)
{
	/* Browser SECTION */
	/* Only browse for public gallery folders !! */																																					 
	$sql = $db->query("SELECT *, user_name, (SELECT COUNT(*) FROM $db_pfs WHERE pfs_folderid=pff_id) AS count FROM $db_pfs_folders LEFT JOIN $db_users ON pff_userid=user_id WHERE pff_isgallery=1".$extrafilter." ORDER BY pff_userid,pff_title");
	while($row = $sql->fetch())
	{
		$icon = 'folder';
		$t->assign(array(
			'FOLDER_ID' => $row['pff_id'],
			'FOLDER_OWNER' => $row['user_name'],
			'FOLDER_OWNERID' => $row['pff_userid'],
			'FOLDER_ADDED' => $row['pff_date'],
			'FOLDER_UPDATED' => $row['pff_updated'],
			'FOLDER_TITLE' => $row['pff_title'],
			'FOLDER_DESC' => $row['pff_desc'],
			'FOLDER_ISGALLERY' => $row['pff_isgallery'],
			'FOLDER_COUNT' => $row['count'],
			'FOLDER_URL' => cot_url('plug', 'e=ezgallery&folderid='.$row['pff_id']),
			'FOLDER_ICON' => $cfg['plugin']['ezgallery']['imgpath'].'/'.$icon.'.png'
		));
		$t->parse('MAIN.FOLDERS.FOLDER');
	}
	$numrows = $sql->rowCount();
	if($numrows > 0)
	{
		$t->assign('FOLDERCOUNT', $numrows);
		$t->parse('MAIN.FOLDERS');
	}
	else
	{
		$t->parse('MAIN.NOFOLDERS');
	}
}

/*
===================================
==--           FILES section
===================================*/
$sql = $db->query("SELECT p.*, u.user_name FROM $db_pfs AS p LEFT JOIN $db_users AS u ON p.pfs_userid=u.user_id WHERE p.pfs_folderid=".(int)$folderid." ORDER BY pfs_file");
$numrows = 0;
while($row = $sql->fetch())
{
	/* check for non image types.. and skip those files */
	$fext=strtolower($row['pfs_extension']);
	switch ($fext)
	{
		case "jpg":
		case "jpeg":
		case "gif":
		case "png":
			break;
		default:
			/* not a picture, so skip it !! */	
			continue;
	} 

	$numrows+=1;
	$icon = is_file($cfg['plugin']['ezgallery']['imgpath'].'/'.$fileicons[$row['pfs_extension']].'.png') ? $fileicons[$row['pfs_extension']] : 'unknown';
	$t->assign(array(
		'FILE_ID' => $row['pfs_id'],
		'FILE_OWNER' => $row['user_name'],
		'FILE_OWNERID' => $row['pfs_userid'],
		'FILE_ADDED' => $row['pfs_date'],
		'FILE_NAME' => $row['pfs_file'],
		'FILE_EXT' => $row['pfs_extension'],
		'FILE_DESC' => $row['pfs_desc'],
		'FILE_SIZE' => getFileSize($row['pfs_size']/1024),
		'FILE_URL' => cot_pfs_path($row['pfs_userid']).$row['pfs_file'],
		'FILE_THUMBURL' => cot_pfs_thumbpath($row['pfs_userid']).$row['pfs_file'],
		'FILE_ICON' => $cfg['plugin']['ezgallery']['imgpath'].'/'.$icon.'.png'
	));
	$t->parse('MAIN.GALLERY.EZGALIMAGES');
}

cot_rc_link_file($cfg['plugins_dir'] . '/ezgallery/css/ezgallery.css');
cot_rc_link_file($cfg['plugins_dir'] . '/ezgallery/js/jquery.ad-gallery.min.js');

if($numrows > 0)
{
	$t->assign(array(	"FILESCOUNT" 	=> $numrows,
						"EZGAL_BASEDIR"	=> $sys['site_uri'] . $cfg['plugins_dir']."/ezgallery" ));

	$t->parse('MAIN.GALLERY');
}
else
{
	$t->parse('MAIN.NOFILES');
}

?>