<?php
/* ====================
[BEGIN_SED_EXTPLUGIN]
Code=showcase
Part=main
File=showcase
Hooks=standalone
Tags=
Order=
[END_SED_EXTPLUGIN]
==================== */

defined('SED_CODE') && defined('SED_PLUG') or die('Wrong URL');

// Table name preset
$db_showcase = 'sed_showcase';

// Required files
require_once $cfg['plugins_dir'] . '/showcase/lib/stw.php';
require_once $cfg['plugins_dir'] . '/tags/inc/config.php';
require_once $cfg['plugins_dir'] . '/tags/inc/functions.php';

// Import a domain ID
$id = (int) sed_import('id', 'G', 'INT');

if ($id > 0)
{
	// Display domain details

	// First get domain data
	$res = sed_sql_query("SELECT s.*, u.user_name
		FROM $db_showcase AS s
			LEFT JOIN $db_users AS u ON u.user_id = s.sc_owner
		WHERE sc_id = $id");
	if (sed_sql_numrows($res) != 1)
	{
		// 404 not found
		sed_redirect(sed_url('message', 'msg=404', '', true));
		exit;
	}
	$row = sed_sql_fetchassoc($res);
	sed_sql_freeresult($res);
	$domain = $row['sc_domain'];

	$usr_edit = $usr['auth_write']
		&& ($usr['isadmin'] || $usr['id'] == $row['sc_owner']);

	if ($a == 'update' && $usr_edit)
	{
		$in = sc_import($domain);
		if ($in === false)
		{
			// Oops, the domain is no longer valid
			$error_string .= $L['Invalid_domain'] . '<br />';
		}
		else
		{
			// Update database record and variables
			if (sed_sql_update($db_showcase, "sc_id = $id", $in, 'sc_'))
			{
				$row['sc_title'] = $in['title'];
				$row['sc_date'] = $in['date'];
				$row['sc_descr'] = $in['descr'];
				// Update tags
				$tags = sed_tag_parse(sed_import('tags', 'P', 'TXT'));
				$old_tags = sed_tag_list($id, 'showcase');
				$kept_tags = array();
				$new_tags = array();
				// Find new tags, count old tags that have been left
				$cnt = 0;
				foreach($tags as $tag)
				{
					$p = array_search($tag, $old_tags);
					if($p !== false)
						$kept_tags[$cnt++] = $old_tags[$p];
					else
						$new_tags[] = $tag;
				}
				// Remove old tags that have been removed
				$rem_tags = array_diff($old_tags, $kept_tags);
				foreach($rem_tags as $tag)
					sed_tag_remove($tag, $id, 'showcase');
				// Add new tags
				$ncnt = count($new_tags);
				if ($cfg['plugin']['tags']['limit'] > 0
					&& $ncnt > $cfg['plugin']['tags']['limit'] - $cnt)
					$lim = $cfg['plugin']['tags']['limit'] - $cnt;
				else
					$lim = $ncnt;
				for($i = 0; $i < $lim; $i++)
					sed_tag($new_tags[$i], $id, 'showcase');
				
				$error_string .= $L['Updated_successfully'] . '<br />';
			}
			else
				$error_string .= $L['Database_error'] . '<br />';
		}
	}

	if ($a == 'remove' && $usr_edit)
	{
		// Item removal
		if (sed_sql_delete($db_showcase, "sc_id = $id"))
		{
			sed_sql_delete($db_com, "com_code = 'sc$id'");
			sed_sql_delete($db_rated, "rated_code = 'sc$id'");
			sed_sql_delete($db_ratings, "rating_code = 'sc$id'");
			sed_tag_remove_all($id, 'showcase');
			sed_redirect(sed_url('plug', 'e=showcase', '', true));
			exit;
		}
		else
			$error_string .= $L['Database_error'] . '<br />';
	}

	if ($a == 'validate' && $usr['isadmin'])
	{
		sed_sql_update($db_showcase, "sc_id = $id",
			array('active' => 1), 'sc_');
		$row['sc_active'] = 1;
	}

	// Display the item and comments
	$t = new XTemplate(sed_skinfile('showcase.display', true));

	if (!empty($error_string))
	{
		$t->assign('ERROR_MSG', $error_string);
		$t->parse('MAIN.ERROR');
	}

	sc_display($domain, $usr_edit, true);

	$t->assign(array(
		'TITLE' => '<a href="' . sed_url('plug', 'e=showcase') . '">'
			. $L['Site_showcase'] . '</a>: ' . $domain,
		'ACTION' => sed_url('plug', "e=showcase&id=$id&a=update")
	));
}
else
{
	// Display main page

	// Add a new item if submitted
	if ($a == 'add' && $usr['auth_write'])
	{
		// Import data
		$in = sc_import();
		if ($in === false)
			$error_string .= $L['Invalid_domain'] . '<br />';
		else
		{
			// Check if exists
			$query = "SELECT COUNT(*) FROM `$db_showcase`
				WHERE sc_domain = '{$in['domain']}'";
			$count = sed_sql_result(sed_sql_query($query), 0, 0);
			if ($count > 0)
				$error_string .= $L['Domain_registered'] . '<br />';
			else
			{
				// Register in database
				if (sed_sql_insert($db_showcase, $in, 'sc_'))
				{
					// Add tags
					$item_id = sed_sql_result(
						sed_sql_query("SELECT LAST_INSERT_ID()"), 0, 0);
					$tags = sed_tag_parse(sed_import('tags', 'P', 'TXT'));
					$cnt = 0;
					foreach($tags as $tag)
					{
						sed_tag($tag, $item_id, 'showcase');
						if($cfg['plugin']['tags']['limit'] > 0
							&& ++$cnt == $cfg['plugin']['tags']['limit'])
							break;
					}
					$error_string .= $L['Added_successfully'] . '<br />';
				}
				else
					$error_string .= $L['Database_error'] . '<br />';
			}
		}
	}

	// Import parameters
	$tag = sed_import('t', 'G', 'TXT');
	$o = sed_import('o', 'G', 'ALP');
	$d = (int) sed_import('d', 'G', 'INT');

	// Assemble the query
	if (!empty($tag))
	{
		$t_query = sed_tag_parse_query($tag);
		$t_from = "LEFT JOIN $db_tag_references AS r ON r.tag_item = s.sc_id";
		$t_where = "AND r.tag_area = 'showcase' AND ($t_query)";
	}

	if ($o == 'rate')
	{
		$r_fields = ', t.rating_average';
		$r_join = "LEFT JOIN $db_ratings AS t
				ON t.rating_code = CONCAT('sc', CAST(s.sc_id AS CHAR))";
		$order = 'rating_average DESC';
	}
	else
		$order = 'sc_date DESC';

	$totalitems = sed_sql_result(sed_sql_query("SELECT COUNT(*)
		FROM `$db_showcase` AS s $t_from
		WHERE sc_active = 1 $t_where"), 0, 0);

	$query = "SELECT s.*, u.user_name $r_fields
		FROM `$db_showcase` AS s
			LEFT JOIN $db_users AS u ON u.user_id = s.sc_owner
			$t_from
			$r_join
		WHERE sc_active = 1
			$t_where
		ORDER BY $order
		LIMIT $d, " . $cfg['plugin']['showcase']['per_page'];
	$res = sed_sql_query($query);

	// Display the items
	$t = new XTemplate(sed_skinfile('showcase', true));

	if (!empty($error_string))
	{
		$t->assign('ERROR_MSG', $error_string);
		$t->parse('MAIN.ERROR');
	}

	$perpage = $cfg['plugin']['showcase']['per_page'];
	$perrow = $cfg['plugin']['showcase']['per_row'];
	$i = 0;
	while ($row = sed_sql_fetchassoc($res))
	{
		sc_display($row['sc_domain']);
		$t->assign('ODDEVEN', sed_build_oddeven($i));
		$t->parse('MAIN.ROW.CELL');
		if (++$i % $perrow == 0)
			$t->parse('MAIN.ROW');
	}
	if ($i % $perrow != 0)
		$t->parse('MAIN.ROW');
	sed_sql_freeresult($res);

	// Build pagination
	if (!empty($tag))
	{
		$tag_u = sed_urlencode($tag, $cfg['plugin']['tags']['translit']);
		$tl = $lang != 'en' && $tag_u != urlencode($tag) ? '&tl=1' : '';
		$url_t = '&t=' . $tag_u . $tl;
	}
	$pag_o = $o == 'rate' ? '&o=rate' : '';
	$pagenav = sed_pagination(sed_url('plug','e=showcase' . $url_t . $pag_o),
		$d, $totalitems, $perpage);
	list($pagination_prev, $pagination_next)
		= sed_pagination_pn(sed_url('plug','e=showcase' . $url_t . $pag_o),
			$d, $totalitems, $perpage, true);

	// Build tag cloud
	$tcloud = sed_tag_cloud('showcase', $cfg['plugin']['tags']['order']);
	$tc_html = '<div class="tag_cloud">';
	foreach($tcloud as $tg => $cnt)
	{
		$tag_t = $cfg['plugin']['tags']['title'] ? sed_tag_title($tg) : $tg;
		$tag_u = sed_urlencode($tg, $cfg['plugin']['tags']['translit']);
		$tl = $lang != 'en' && $tag_u != urlencode($tg) ? '&tl=1' : '';
		foreach($tc_styles as $key => $val)
		{
			if($cnt <= $key)
			{
				$dim = $val;
				break;
			}
		}
		$tc_html .= '<a href="' . sed_url('plug', 'e=showcase&t='.$tag_u.$tl)
			. '" class="' . $dim . '">' . htmlspecialchars($tag_t) . '</a> ';
	}
	$tc_html .= '</div>';

	$t->assign(array(
		'TITLE' => '<a href="' . sed_url('plug', 'e=showcase') . '">'
			. $L['Site_showcase'] . '</a>'
			. (empty($tag) ? '' : ': ' . htmlspecialchars($tag)),
		'PAGEPREV' => $pagination_prev,
		'PAGENEXT' => $pagination_next,
		'PAGENAV' => $pagenav,
		'TAGCLOUD' => $tc_html,
		'BYRATE_URL' => sed_url('plug','e=showcase&o=rate' . $url_t),
		'BYDATE_URL' => sed_url('plug','e=showcase' . $url_t)
	));

	
	if ($usr['auth_write'])
	{
		// Validation queue
		if (!$usr['isadmin']) $q_where = 'AND sc_owner = ' . $usr['id'];
		$res = sed_sql_query("SELECT sc_id, sc_title FROM `$db_showcase`
			WHERE sc_active = 0 $q_where");
		if (sed_sql_numrows($res) > 0)
		{
			while ($row = sed_sql_fetchassoc($res))
			{
				$t->assign(array(
					'ITEM_LINK' => sed_url('plug', 'e=showcase&id='
						. $row['sc_id']),
					'ITEM_TITLE' => htmlspecialchars($row['sc_title'])
				));
				$t->parse('MAIN.VALIDATION.ROW');
			}
			sed_sql_freeresult($res);
			$t->parse('MAIN.VALIDATION');
		}

		// Display new domain submission form
		$t->assign('ACTION', sed_url('plug', 'e=showcase&a=add'));
		$t->parse('MAIN.FORM');
	}
}

/**
 * Imports an item from a POST form
 *
 * @global array $cfg Cotonti configuration
 * @global array $usr User account
 * @param string $domain Domain
 * @return mixed Input as associative array or false on error
 */
function sc_import($domain = '')
{
	global $cfg, $usr, $sys;

	if (empty($domain))
	{
		$domain = sed_import('domain', 'P', 'TXT');
		$domain = preg_replace('#[^\w\-\.]#', '', $domain);
		$in['owner'] = $usr['id'];
	}

	if (empty($domain)) return false;

	// Check if it is a valid domain
	$data = file_get_contents("http://$domain");
	if (!empty($data))
	{
		$in['domain'] = $domain;
		$in['title'] = sed_import('title', 'P', 'TXT');
		// Get title from page if empty
		if (empty($in['title'])
			&& preg_match('#<title>(.+?)</title>#i', $data, $mt))
			$in['title'] = mb_substr($mt[1], 0,
				$cfg['plugin']['showcase']['length']);
		$in['descr'] = sed_import('descr', 'P', 'TXT');
		$in['date'] = $sys['now_offset'];
		$in['active'] = $usr['isadmin'] ? 1 : 0;
		return $in;
	}
	else
		return false;
}

/**
 * Prepares item display and assigns XTemplate tags
 *
 * @global XTemplate $t Template object
 * @global array $row SQL result row
 * @global array $cfg Cotonti configuration
 * @param string $domain Domain
 * @param bool $edit Display editable fields
 */
function sc_display($domain, $edit = false, $comments = false)
{
	global $t, $row, $cfg, $L, $usr;

	$title = htmlspecialchars($row['sc_title']);
	$url = 'http://' . $domain;
	$item_code = $row['sc_id'];
	$page_url = sed_url('plug', 'e=showcase&id=' . $item_code);

	list($comments_link, $comments_display, $comments_count)
		= sed_build_comments('sc' . $item_code, $page_url, $comments);
	list($ratings_link, $ratings_display)
		= sed_build_ratings('sc' . $item_code, $page_url, true);

	// Clickable tag list
	$tags = sed_tag_list($item_code, 'showcase');
	if ($edit)
	{
		$tag_list = htmlspecialchars(implode(', ', $tags));
		$tag_list = '<input type="text" name="tags" value="'.$tag_list.'" />';
	}
	else
	{
		foreach ($tags as $tag)
		{
			if ($i++ > 0) $tag_list .= ', ';
			$tag_list .= '<a href="' . sed_url('plug', 'e=showcase&t=' . $tag)
				. '">' . htmlspecialchars($tag) . '</a>';
		}
	}

	// Assign tags
	$t->assign(array(
		'ITEM_ID' => $row['sc_id'],
		'ITEM_URL' => $url,
		'ITEM_LINK' => $page_url,
		'ITEM_DOMAIN' => $row['sc_domain'],
		'ITEM_TITLE' => $edit ?
			'<input type="text" name="title" maxlength="'
				. $cfg['plugin']['showcase']['length'] . '" value="'
				. $title . '" />' : $title,
		'ITEM_IMAGE' => STW::getScaledThumbnail($url,
			$cfg['plugin']['showcase']['width'],
			$cfg['plugin']['showcase']['height']),
		'ITEM_OWNER' => sed_build_user($row['sc_owner'], $row['user_name']),
		'ITEM_DESCR' => $edit ?
			'<textarea name="descr" maxlength="255">'
				. htmlspecialchars($row['sc_descr']) . '</textarea>'
			: htmlspecialchars($row['sc_descr']),
		'ITEM_COMMENTS' => $comments_link,
		'ITEM_COMMENTS_COUNT' => $comments_count,
		'ITEM_COMMENTS_DISPLAY' => $comments_display,
		'ITEM_RATINGS' => $ratings_link,
		'ITEM_TAGS' => $tag_list,
		'ITEM_SAVE' => $edit ?
			'<input type="submit" value="' . $L['Submit'] . '" />' : '',
		'ITEM_REMOVE' => $edit ? '<a href="'
			. sed_url('plug', 'e=showcase&id=' . $row['sc_id'] . '&a=remove')
			. '" onclick="return confirm(\'' . $L['Ensure_delete'] . '\')">'
			. $L['Delete'] . '</a>' : '',
		'ITEM_VALIDATE' => $usr['isadmin'] && !$row['sc_active'] ? '<a href="'
			. sed_url('plug', 'e=showcase&id=' . $row['sc_id'] . '&a=validate')
			. '">' . $L['Validate'] . '</a>' : ''
	));
}
?>
