<?PHP
/**
 * German Language File for Admin Area (admin.lang.php)
 *
 * @package Cotonti
 * @version 0.1.0
 * @author Steffen Schultz
 * @copyright Copyright (c) Cotonti Team 2008-2009
 * @license BSD
 */

defined('SED_CODE') or die('Wrong URL.');

/**
 * Config Section
 */

$L['core_comments'] = &$L['Comments'];
$L['core_forums'] = &$L['Forums'];
$L['core_lang'] = &$L['Language'];
$L['core_main'] = 'Haupteinstellungen';
$L['core_menus'] = &$L['Menus'];
$L['core_page'] = &$L['Pages'];
$L['core_parser'] = &$L['Parser'];
$L['core_pfs'] = &$L['PFS'];
$L['core_plug'] = &$L['Plugins'];
$L['core_pm'] = &$L['Private_Messages'];
$L['core_polls'] = &$L['Polls'];
$L['core_ratings'] = &$L['Ratings'];
$L['core_skin'] = &$L['Skins'];
$L['core_time'] = 'Zeit und Datum';
$L['core_title'] = 'Titel (&lt;title&gt;-Tag)';
$L['core_trash'] = &$L['Trashcan'];
$L['core_users'] = &$L['Users'];

/**
 * Config Section
 * Comments Subsection
 */

$L['cfg_countcomments'] = array('Kommentarzähler', 'Anzahl der Kommentare nahe dem Icon anzeigen');
$L['cfg_disable_comments'] = array('Kommentare ausschalten', '');
$L['cfg_expand_comments'] = array('Kommentare ausklappen', 'Kommentare standardmäßig ausgeklappt zeigen');	// New in N-0.0.2
$L['cfg_maxcommentsperpage'] = array('Max. Kommentare pro Seite', ' ');   // New in N-0.0.6
$L['cfg_commentminsize'] = array('Minimale Länge der Kommentare', 'Standard: 2');
$L['cfg_commentsize'] = array('Maximale Länge von Kommentaren', 'In Bytes (0für unbegrenzt). Standard: 0');   // New in N-0.0.6

/**
 * Config Section
 * Forums Subsection
 */

$L['cfg_antibumpforums'] = array('Anti-Bump-Schutz', 'Verhindert, dass Benutzer zweimal hintereinander in einem Thema schreiben können');	// New in N-0.1.0
$L['cfg_disable_forums'] = array('Foren ausschalten', '');
$L['cfg_hideprivateforums'] = array('Private Foren verstecken', '');
$L['cfg_hottopictrigger'] = array('Anzahl Beiträge bis ein Thema \'heiß\' wird', '');
$L['cfg_maxtopicsperpage'] = array('Themen pro Seite', '');
$L['cfg_mergeforumposts'] = array('Beiträge zusammenfassen', 'Fasst Benutzerbeiträge in einem Beitrag zusammen wenn sie nacheinander gesendet wurden. Anti-Bump muss ausgeschaltet sein');	// New in N-0.1.0
$L['cfg_mergetimeout'] = array('Timeout für Beitragszusammenfassung', 'Beiträge werden nach Ablauf dieser Zeit nicht mehr zusammengefasst. (Angabe in Stunden, 0 zum Ausschalten der Funktion. Beitragszusammenfassung muss eingeschaltet sein)');	// New in N-0.1.0
$L['cfg_minpostlength'] = array('Minimale Länge eines Beitrags', 'Standard: 2');
$L['cfg_maxpostsperpage'] = array('Beiträge pro Seite', ' '); // New in N-0.0.6

/**
 * Config Section
 * Lang Subsection
 */

$L['cfg_forcedefaultlang'] = array('Standardsprache für alle Benutzer erzwingen', '');

/**
 * Config Section
 * Main Subsection
 */

$L['cfg_adminemail'] = array('E-Mail des Administrators', 'Benötigt');
$L['cfg_turnajax'] = array('Ajax ausschalten', 'Funktioniert nur wenn jQuery eingeschaltet ist');
$L['cfg_cache'] = array('Interner Cache', 'Sollte für bessere Leistung eingeschaltet bleiben');
$L['cfg_clustermode'] = array('Server-Cluster', 'Funktion einschalten, falls dies eine über mehrere Server verteilte Installation ist.');
$L['cfg_cookiedomain'] = array('Domain für Cookies', 'Standard: nichts');
$L['cfg_cookielifetime'] = array('Maximale Cookie-Gültigkeit', 'In Sekunden');
$L['cfg_cookiepath'] = array('Pfad für Cookies', 'Standard: nichts');
$L['cfg_devmode'] = array('Debug-Modus', 'Nur zur Fehlerbehebung, ausschalten im Produktionseinsatz');
$L['cfg_disablehitstats'] = array('Zugrifsstatistiken ausschalten', 'Referer und Zugriffe pro Tag');
$L['cfg_gzip'] = array('Gzip', 'Gzip-Komprimierung für die HTML-Ausgabe');
$L['cfg_hostip'] = array('Server-IP', 'Die IP-Adresse des Servers (optional).');
$L['cfg_jquery'] = array('jQuery einschalten', '');	// New in N-0.0.1
$L['cfg_maintenance'] = array('Wartungsmodus', 'Nur authorisiertes Personal hat Zugriff auf die Seite');	// New in N-0.0.2
$L['cfg_maintenancereason'] = array('Grund für Wartungsmodus', 'Optionale Nachricht, sollte besser kurz gehalten bleiben');	// New in N-0.0.2
$L['cfg_shieldenabled'] = array('Schutzschild einschalten', 'Anti-Spamming und Anti-Hammering');
$L['cfg_shieldtadjust'] = array('Schutzschild-Zeiten einstellen (in %)', 'Je höher, desto schwerer haben es Spammer');
$L['cfg_shieldzhammer'] = array('Anti-Hammer nach * schnellen Zugriffen', 'Je kleiner der Wert, desto schneller greift die automatische Sperre für 3 Minuten');
$L['cfg_redirbkonlogin'] = array('Zurückführung nach Anmeldung', 'Auf die Seite weiterleiten, welche der Benutzer vor dem Login aufgerufen hat');	// New in N-0.6.1
$L['cfg_redirbkonlogout'] = array('Zurückführung nach Abmeldung', 'Auf die Seite weiterleiten, welche der Benutzer vor der Abmeldung aufgerufen hat');	// New in N-0.6.1

/**
 * Config Section
 * Menus Subsection
 */

$L['cfg_banner'] = array('Banner<br />{HEADER_BANNER} in header.tpl', '');
$L['cfg_bottomline'] = array('Fußzeile<br />{FOOTER_BOTTOMLINE} in footer.tpl', '');
$L['cfg_topline'] = array('Oberste Zeile<br />{HEADER_TOPLINE} in header.tpl', '');

$L['cfg_freetext1'] = array('Freitextbereich #1<br />{PHP.cfg.freetext1} in allen Tpl-Dateien', '');
$L['cfg_freetext2'] = array('Freitextbereich #2<br />{PHP.cfg.freetext2} in allen Tpl-Dateien', '');
$L['cfg_freetext3'] = array('Freitextbereich #3<br />{PHP.cfg.freetext3} in allen Tpl-Dateien', '');
$L['cfg_freetext4'] = array('Freitextbereich #4<br />{PHP.cfg.freetext4} in allen Tpl-Dateien', '');
$L['cfg_freetext5'] = array('Freitextbereich #5<br />{PHP.cfg.freetext5} in allen Tpl-Dateien', '');
$L['cfg_freetext6'] = array('Freitextbereich #6<br />{PHP.cfg.freetext6} in allen Tpl-Dateien', '');
$L['cfg_freetext7'] = array('Freitextbereich #7<br />{PHP.cfg.freetext7} in allen Tpl-Dateien', '');
$L['cfg_freetext8'] = array('Freitextbereich #8<br />{PHP.cfg.freetext8} in allen Tpl-Dateien', '');
$L['cfg_freetext9'] = array('Freitextbereich #9<br />{PHP.cfg.freetext9} in allen Tpl-Dateien', '');

$L['cfg_menu1'] = array('Menübereich #1<br />{PHP.cfg.menu1} in allen Tpl-Dateien', '');
$L['cfg_menu2'] = array('Menübereich #2<br />{PHP.cfg.menu2} in allen Tpl-Dateien', '');
$L['cfg_menu3'] = array('Menübereich #3<br />{PHP.cfg.menu3} in allen Tpl-Dateien', '');
$L['cfg_menu4'] = array('Menübereich #4<br />{PHP.cfg.menu4} in allen Tpl-Dateien', '');
$L['cfg_menu5'] = array('Menübereich #5<br />{PHP.cfg.menu5} in allen Tpl-Dateien', '');
$L['cfg_menu6'] = array('Menübereich #6<br />{PHP.cfg.menu6} in allen Tpl-Dateien', '');
$L['cfg_menu7'] = array('Menübereich #7<br />{PHP.cfg.menu7} in allen Tpl-Dateien', '');
$L['cfg_menu8'] = array('Menübereich #8<br />{PHP.cfg.menu8} in allen Tpl-Dateien', '');
$L['cfg_menu9'] = array('Menübereich #9<br />{PHP.cfg.menu9} in allen Tpl-Dateien', '');

/**
 * Config Section
 * Page Subsection
 */

$L['cfg_allowphp_pages'] = array('PHP-Code in Seiten', 'Erlaubt das Ausführen von PHP-code in Seiten.  Bitte Vorsicht bei dieser Funktion!');
$L['cfg_autovalidate'] = array('Seite automatisch freischalten', 'Seiten werden sofort veröffentlicht, falls der Benutzer Adminrechte in dieser Kategorie hat');	// New in N-0.0.2
$L['cfg_count_admin'] = array('Zugriffe des Administrators zählen', '');	// New in N-0.0.1
$L['cfg_disable_page'] = array('Seitenfunktion ausschalten', '');
$L['cfg_maxrowsperpage'] = array('Max. Zeilen in Listen', ' ');
$L['cfg_maxlistsperpage'] = array('Max. Listen pro Seite', ' '); // New in N-0.0.6

/**
 * Config Section
 * Parser Subsection
 */

$L['cfg_parsebbcodecom'] = array('BBcode in Kommentaren und privaten Nachrichten erlauben', '');
$L['cfg_parsebbcodeforums'] = array('BBcode in Foren erlauben', '');
$L['cfg_parsebbcodepages'] = array('BBcode in Seiten erlauben', '');
$L['cfg_parsebbcodeusertext'] = array('BBcode in Benutzersignatur erlauben', '');
$L['cfg_parser_cache'] = array('HTML-Cache einschalten', '');	// New in N-0.0.1
$L['cfg_parser_custom'] = array('Benutzerdefinierten Parser einschalten', '');	// New in N-0.0.1
$L['cfg_parser_disable'] = array('Standardparser ausschalten', '');	// New in N-0.0.3
$L['cfg_parser_vid'] = array('Erlaube BBCodes für eingebettete Videos', '');
$L['cfg_parsesmiliescom'] = array('Smilies in Kommentaren und privaten Nachrichten erlauben', '');
$L['cfg_parsesmiliesforums'] = array('Smilies in Foren erlauben', '');
$L['cfg_parsesmiliespages'] = array('Smilies in Seiten erlauben', '');
$L['cfg_parsesmiliesusertext'] = array('Smilies in Benutzersignatur erlauben', '');

/**
 * Config Section
 * PFS Subsection
 */

$L['cfg_disable_pfs'] = array('Persönliche Dateiablage ausschalten', '');
$L['cfg_maxpfsperpage'] = array('Elemente pro Seite', ' ');
$L['cfg_pfsfilecheck'] = array('Dateiprüfung', 'Falls eingeschaltet, werden alle Uploads in der persönlichen Dateiablagesowie Profilbilder auf ihre Gültigkeit geprüft. Sollte aus Sicherheitsgründen eingeschaltet werden.');	// New in N-0.0.2
$L['cfg_pfsnomimepass'] = array('Keine Mimetyp-Prüfung', 'Falls eingeschaltet, können auch Dateitypen hochgeladen werden, die nicht in der Mimetyp-Konfigurationsdatei definiert sind.');	// New in N-0.0.2
$L['cfg_pfstimename'] = array('Zeitstempel in Dateinamen', 'Erstellt Dateinamen basierend auf dem momentanen Zeitstempel. Standardmäßig werden die originalen Dateinamen verwendet und lediglich notwendige Zeichenkonvertierungen vorgenommen.');	// New in N-0.0.2
$L['cfg_pfsuserfolder'] = array('Ordnermodus', 'Falls eingeschaltet, werden die Benutzerdateien in Unterordnern abgelegt (/datas/users/Benutzer-ID/) anstatt die Benutzer-ID zum Dateinamen hinzuzufügen. Diese Option darf nur beim ersten Einrichten der Seite geändert werden. Sobald eine Datei hochgeladen wurde, ist es dafür zu spät. Diese Einstellung sollte für den Moment nicht geändert werden.');
$L['cfg_pfs_winclose'] = array('Popup-Fenster nach BBcode-Auswahl schließen');
$L['cfg_th_amode'] = array('Thumbnail-Erstellung', '');
$L['cfg_th_border'] = array('Thumbnails, Rahmenbreite', 'Standard: 4 Pixel');
$L['cfg_th_colorbg'] = array('Thumbnails, Rahmenfarbe', 'Standard: 000000, Hex-Farbcode');
$L['cfg_th_colortext'] = array('Thumbnails, Textfarbe', 'Standard: FFFFFF, Hex-Farbcode');
$L['cfg_th_dimpriority'] = array('Thumbnails, Dimensionen für Neuberechnung', '');
$L['cfg_th_jpeg_quality'] = array('Thumbnails, Jpeg-Qualität', 'Standard: 85');
$L['cfg_th_keepratio'] = array('Thumbnail, Seitenverhältnis beibehalten?', '');
$L['cfg_th_textsize'] = array('Thumbnails, Textgröße', '');
$L['cfg_th_x'] = array('Thumbnails, Breite', 'Standard: 112 Pixel');
$L['cfg_th_y'] = array('Thumbnails, Höhe', 'Standard: 84 Pixel, empfohlen: Breite x 0.75');

/**
 * Config Section
 * Plugins Subsection
 */

$L['cfg_disable_plug'] = array('Plugins ausschalten', '');

/**
 * Config Section
 * Private Messages Subsection
 */

$L['cfg_disable_pm'] = array('Private Nachrichten ausschalten', '');
$L['cfg_pm_allownotifications'] = array('PM-Benachrichtigungen via E-Mail erlauben', '');
$L['cfg_pm_maxsize'] = array('MAximale Nachrichtenlänge', 'Standard: 10000 Zeichen');
$L['cfg_maxpmperpage'] = array('Max. Nachrichten pro Seite', ' ');  // New in N-0.0.6

/**
 * Config Section
 * Polls Subsection
 */

$L['cfg_del_dup_options'] = array('Löschung doppelter Optionen erzwingen', 'Löscht doppelte Optionen, auch wenn sie bereits in der Datenbank sind');	// New in N-0.0.2
$L['cfg_disable_polls'] = array('Umfragen ausschalten', '');
$L['cfg_ip_id_polls'] = array('Stimmenzählungsmethode', '');	// New in N-0.0.2
$L['cfg_max_options_polls'] = array('Maximale Anzahl Optionen', 'Optionen oberhalb dieser Begrenzung werden automatisch entfernt');	// New in N-0.0.2

/**
 * Config Section
 * Ratings Subsection
 */

$L['cfg_disable_ratings'] = array('Bewertungen ausschalten', '');
$L['cfg_ratings_allowchange'] = array('Dürfen Bewertungen geändert werden?', 'Falls eingeschaltet, können Benutzer ihre abgegebenen Bewertungen nachträglich verändern.');	// New in N-0.0.2

/**
 * Config Section
 * Skins Subsection
 */

$L['cfg_charset'] = array('HTML-Zeichensatz', '');
$L['cfg_disablesysinfos'] = array('Seitenerstellungszeit abschalten', 'In footer.tpl');
$L['cfg_doctypeid'] = array('Dokument-Typ', '&lt;!DOCTYPE&gt; des HTML-Layouts');
$L['cfg_forcedefaultskin'] = array('Standardskin für alle Benutzer erzwingen', '');
$L['cfg_homebreadcrumb'] = array('Startseite in Wegweiser zeigen', 'Fügt einen Link zur Startseite an den Anfang der Wegweiser-Navigation');	// New in N-0.0.2
$L['cfg_keepcrbottom'] = array('Copyrightvermerk im {FOOTER_BOTTOMLINE}-Tag behalten', 'In footer.tpl');
$L['cfg_metakeywords'] = array('HTML-Schlüsselwörter (durch Komma getrennt)', 'Für Suchmaschinen');
$L['cfg_separator'] = array('Allgemeiner Trenner', 'Standard:>');
$L['cfg_showsqlstats'] = array('SQL-Abfragestatistik anzeigen', 'In footer.tpl');

/**
 * Config Section
 * Time Subsection
 */

$L['cfg_dateformat'] = array('Haupt-Datumsmaske', 'Standard: Y-m-d H:i');
$L['cfg_formatmonthday'] = array('Kurze Datumsmaske', 'Standard: m-d');
$L['cfg_formatyearmonthday'] = array('Mittellange Datumsmaske', 'Standard: Y-m-d');
$L['cfg_formatmonthdayhourmin'] = array('Forum-Datumsmaske', 'Standard: m-d H:i');
$L['cfg_servertimezone'] = array('Server-Zeitzone', 'Zeitunterschied des Servers zur GMT+00');
$L['cfg_defaulttimezone'] = array('Standard-Zeitzone', 'Für Gäste und neue Mitglieder, von -12 bis +12');
$L['cfg_timedout'] = array('Inaktivitätsverzögerung in Sekunden', 'Nach dieser Zeit wird der Benutzer inaktiv');

/**
 * Config Section
 * Title Subsection
 */

$L['cfg_maintitle'] = array('Seitentitel', 'Haupttitel für die Webseite, wird benötigt');
$L['cfg_subtitle'] = array('Beschreibung', 'Optional, wird nach dem Titel der Seite angezeigt');
$L['cfg_title_forum_editpost'] = array('Forum - Seitentitel für Beitragsbearbeitung', 'Optionen: {FORUM}, {SECTION}, {EDIT}');
$L['cfg_title_forum_main'] = array('Forum - Haupttitel', 'Optionen: {FORUM}');
$L['cfg_title_forum_newtopic'] = array('Forum - Titel für neues Thema', 'Optionen: {FORUM}, {SECTION}, {NEWTOPIC}');
$L['cfg_title_forum_posts'] = array('Forum - Titel für Beiträge', 'Optionen: {FORUM}, {TITLE}');
$L['cfg_title_forum_topics'] = array('Forum - Titel für Themen', 'Optionen: {FORUM}, {SECTION}');
$L['cfg_title_header'] = array('Header - Titel', 'Optionen: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_header_index'] = array('Header - Inhaltstitel', 'Optionen: {MAINTITLE}, {DESCRIPTION}, {SUBTITLE}');
$L['cfg_title_list'] = array('Listentitel', 'Optionen: {TITLE}');
$L['cfg_title_page'] = array('Seitentitel', 'Optionen: {TITLE}, {CATEGORY}');
$L['cfg_title_pfs'] = array('Titel - '.$L['PFS'], 'Optionen: {PFS}');
$L['cfg_title_pm_main'] = array('Titel - PM', 'Optionen: {PM}, {INBOX}, {ARCHIVES}, {SENTBOX}');
$L['cfg_title_pm_send'] = array('Titel - PM gesendet', 'Optionen: {PM}, {SEND_NEW}');
$L['cfg_title_users_details'] = array('Titel - Benutzerdetails', 'Optionen: {USER}, {NAME}');
$L['cfg_title_users_edit'] = array('Titel - Benutzer bearbeiten', 'Optionen: {EDIT}, {NAME}');
$L['cfg_title_users_main'] = array('Haupttitel - Benutzer', 'Optionen: {USERS}');
$L['cfg_title_users_profile'] = array('Titel - Benutzerprofil', 'Optionen: {PROFILE}, {NAME}');

/**
 * Config Section
 * Trash Subsection
 */

$L['cfg_trash_comment'] = array('Papierkorb für Kommentare aktivieren', '');
$L['cfg_trash_forum'] = array('Papierkorb für Foren aktivieren', '');
$L['cfg_trash_page'] = array('Papierkorb für Seiten aktivieren', '');
$L['cfg_trash_pm'] = array('Papierkorb für private Nachrichten aktivieren', '');
$L['cfg_trash_prunedelay'] = array('Einträge im papierkorb nach * Tagen entfernen (0 um sie für immer zu behalten)', '');
$L['cfg_trash_user'] = array('Papierkorb für Benutzer aktivieren', '');

/**
 * Config Section
 * Users Subsection
 */

$L['cfg_av_maxsize'] = array('Avatar, maximale Dateigröße', 'Standard: 8000 bytes');
$L['cfg_av_maxx'] = array('Avatar, maximale Breite', 'Standard: 64 Pixel');
$L['cfg_av_maxy'] = array('Avatar, maximale Höhe', 'Standard: 64 Pixel');
$L['cfg_disablereg'] = array('Registrierung abschalten', 'Hindert Benutzer daran neue Accounts zu erstellen');
$L['cfg_disablewhosonline'] = array('Wer ist online-Anzeige ausschalten', 'Automatisch aktiviert wenn der Schutzschild verwendet wird');
$L['cfg_forcerememberme'] = array('&quot;Erinnere dich an mich&quot;erzwingen', 'Benutze dies auf Multidomain-Seiten oder bei plötzlichen Logouts');
 
$L['cfg_maxusersperpage'] = array('Maximale Zeilen in der Benutzerliste', '');
$L['cfg_ph_maxsize'] = array('Foto, maximale Dateigröße', 'Standard: 8000 bytes');
$L['cfg_ph_maxx'] = array('Foto, maximale Breite', 'Standard: 96 Pixel');
$L['cfg_ph_maxy'] = array('Foto, maximale Höhe', 'Standard: 96 Pixel');
$L['cfg_regnoactivation'] = array('E-Mail-Überprüfung für neue Benutzer überspringen', '\'Nein\' wird aus Sicherheitsgründen empfohlen');
$L['cfg_regrequireadmin'] = array('Administratoren müssen neue Accounts freischalten', '');
$L['cfg_sig_maxsize'] = array('Signatur, maximale Dateigröße', 'Standard: 50000 bytes');
$L['cfg_sig_maxx'] = array('Signatur, maximale Breite', 'Standard: 468 Pixel');
$L['cfg_sig_maxy'] = array('Signatur, maximale Höhe', 'Standard: 60 Pixel');
$L['cfg_user_email_noprotection'] = array('Passwortschutz für Änderung der E-Mail-Adresse ausschalten', '\'Nein\' aus Sicherheitsgründen empfohlen');
$L['cfg_useremailchange'] = array('Benutzern erlauben ihre E-Mail-Adresse zu ändern', '\'Nein\' aus Sicherheitsgründen empfohlen');
$L['cfg_usertextimg'] = array('Bilder und HTML in Benutzersignatur erlauben', '\'Nein\' aus Sicherheitsgründen empfohlen');
$L['cfg_usertextmax'] = array('Maximale Länge für Benutzersignatur', 'Standard: 300 Zeichen');

/**
  * Page Section
 */

$L['addnewentry'] = 'Neuen Eintrag hinzufügen';
$L['adm_valqueue'] = 'Wartet auf Freischaltung';
$L['adm_structure'] = 'Seitenstruktur (Kategorien)';
$L['adm_extrafields_desc'] = 'Zusatzfelder Hinzufügen/Bearbeiten';
$L['adm_sortingorder'] = 'Setze eine Standardsortierung für die Kategorien';
$L['adm_showall'] = 'Alles zeigen';
$L['adm_help_page'] = 'Die Seiten der Kategorie &quot;system&quot; werden nicht in den öffentlichen Listen angezeigt, sie sind als Standalone-Seiten gedacht';

/**
  * Page Section
  * Structure Subsection
 */

$L['adm_tpl_mode'] = 'Vorlagenmodus';
$L['adm_tpl_empty'] = 'Standard';
$L['adm_tpl_forced'] = 'Genau wie';
$L['adm_tpl_parent'] = 'Genau wie die übergeordnete KAtegorie';
$L['adm_enablecomments'] = 'Kommentare einschalten';	// New in N-0.1.0
$L['adm_enableratings'] = 'Bewertungen einschalten';	// New in N-0.1.0

/**
 * Page Section
 * Extrafields Subsection
 */

$L['adm_help_pages_extrafield'] = '<b>Allgemeines HTML</b> Automatisch gewählt wenn du es leer lässt<br /><br />
<b>Neue Tags in Tpl-Dateien:</b><br /><br />
page.tpl: {PAGE_XXXXX}, {PAGE_XXXXX_TITLE}<br /><br />
page.add.tpl: {PAGEADD_FORM_XXXXX}, {PAGEADD_FORM_XXXXX_TITLE}<br /><br />
page.edit.tpl: {PAGEEDIT_FORM_XXXXX}, {PAGEEDIT_FORM_XXXXX_TITLE}<br /><br />
list.tpl: {LIST_ROW_XXXXX}, {LIST_TOP_XXXXX}<br />';

/**
  * Page Section
  * CatOrder Subsection
 */

$L['adm_fileyesno'] = 'Datei (Ja/Nein)';
$L['adm_fileurl'] = 'Datei-URL';
$L['adm_filecount'] = 'Datei-Aufrufzähler';
$L['adm_filesize'] = 'Dateigröße';
                             
/**
 * Forums Section
 */

$L['adm_forum_structure'] = 'Forenstruktur (Kategorien)';
$L['adm_forum_emptytitle'] = 'Fehler: Titel ist leer';	// New in N-0.1.0

/**
  * Forums Section
  * Structure Subsection
 */

$L['adm_defstate'] = 'Standardverhalten';
$L['adm_defstate_0'] = 'Eingeklappt';
$L['adm_defstate_1'] = 'Ausgeklappt';

/**
  * Forums Section
  * Forum Edit Subsection
 */

$L['adm_forums_master'] = 'Hauptbereich';	// New in N-0.0.1
$L['adm_diplaysignatures'] = 'Signaturen anzeigen';
$L['adm_enablebbcodes'] = 'BBcodes einschalten';
$L['adm_enablesmilies'] = 'Smilies einschalten';
$L['adm_enableprvtopics'] = 'Private Themen erlauben';
$L['adm_enableviewers'] = 'Betrachter einschalten';	// New in N-0.0.2
$L['adm_enablepolls'] = 'Umfragen einschalten';	// New in N-0.0.2
$L['adm_countposts'] = 'Beiträge zählen';
$L['adm_autoprune'] = 'Themen nach * Tagen automatisch aufräumen';
$L['adm_postcounters'] = 'Zähler überprüfen';

/**
 * Users Section
 */

$L['adm_rightspergroup'] = 'Rechte pro Gruppe';
$L['adm_maxsizesingle'] = 'Maximale Größe für eine einzelne Datei in persönlicher Dateiablage (KB)';
$L['adm_maxsizeallpfs'] = 'Maximale Größe aller Dateien insgesamt in persönlicher Dateiablage (KB)';
$L['adm_copyrightsfrom'] = 'Setze gleiche Rechte wie für die Gruppe';
$L['adm_rights_maintenance'] = 'Zugriff auf Webseite bei wartungsmodus';	// New in N-0.0.2

/**
 * Users Section
 * Extrafields Subsection
 */

$L['adm_help_users_extrafield'] = '<b>Allgemeines HTML</b> Automatisch gewählt, falls du das Feld leer lässt<br /><br />
<b>Neue Tags in Tpl-Dateien:</b><br /><br />
users.profile.tpl: {USERS_PROFILE_XXXXX}, {USERS_PROFILE_XXXXX_TITLE}<br /><br />
users.edit.tpl: {USERS_EDIT_XXXXX}, {USERS_EDIT_XXXXX_TITLE}<br /><br />
users.details.tpl: {USERS_DETAILS_XXXXX}, {USERS_DETAILS_XXXXX_TITLE}<br /><br />
user.register.tpl: {USERS_REGISTER_XXXXX}, {USERS_REGISTER_XXXXX_TITLE}<br /><br />
forums.posts.tpl: {FORUMS_POSTS_ROW_USERXXXXX}, {FORUMS_POSTS_ROW_USERXXXXX_TITLE}<br />';

/**
 * Plug Section
 */

$L['adm_defauth_guests'] = 'Standardrechte für Gäste';
$L['adm_deflock_guests'] = 'Sperrmaske für Gäste';
$L['adm_defauth_members'] = 'Standardrechte für Mitglieder';
$L['adm_deflock_members'] = 'Sperrmaske für Mitglieder';

$L['adm_present'] = 'Vorhanden';
$L['adm_missing'] = 'Fehlend';
$L['adm_paused'] = 'Pausiert';
$L['adm_running'] = 'In Betrieb';
$L['adm_partrunning'] = 'Teilweise laufend';
$L['adm_partstopped'] = 'Teilweise angehalten';
$L['adm_installed'] = 'Installiert';	// New in N-0.0.6
$L['adm_notinstalled'] = 'Nicht installiert';

$L['adm_plugsetup'] = 'Plugin-Setup';	// New in N-0.0.6
$L['adm_override_guests'] = 'System außer Kraft setzen, Gäste und inaktive Accounts dürfen nicht administrieren';	// New in N-0.0.6
$L['adm_override_banned'] = 'System außer Kraft setzen, gesperrt';	// New in N-0.0.6
$L['adm_override_admins'] = 'System außer Kraft setzen, Administratoren';	// New in N-0.0.6

$L['adm_opt_installall'] = 'Alles installieren';
$L['adm_opt_installall_explain'] = 'Dies wird alle Teile des Plugins installieren oder zurücksetzen.';
$L['adm_opt_uninstallall'] = 'Alles deinstallieren</a></td>';
$L['adm_opt_uninstallall_explain'] = 'Dies wird alle Teile des Plugins deaktivieren, die Dateien werden aber nicht entfernt.';
$L['adm_opt_pauseall'] = 'Alles pausieren';
$L['adm_opt_pauseall_explain'] = 'Dies wird alle Teile des Plugins pausieren (ausschalten).';
$L['adm_opt_unpauseall'] = 'Alles fortsetzen';
$L['adm_opt_unpauseall_explain'] = 'Dies wird alle Teile des Plugins fortsetzen (einschalten).';

$L['adm_opt_setoption_warn'] = 'Für dieses Plugin wurden Optionen gefunden. Soll das Plugin mit den gespeicherten Optionen installiert werden?';	// New in N-0.0.2
$L['adm_opt_uninstall_warn'] = 'Du kannst dieses Plugin löschen, ohne Dabei die alten Einstellungen (Optionen und Rechte) zu löschen. Bitte klicken, um dies zu bestätigen.';	// New in N-0.0.2
$L['adm_opt_setup_missing'] = 'Fehler: Setup-Datei fehlt!';	// New in N-0.0.6

$L['adm_pluginstall_msg01'] = 'Lösche alte Installation dieses Plugins...';	// New in N-0.0.6
$L['adm_pluginstall_msg02'] = 'Lösche alte Konfigurationseinträge...';	// New in N-0.0.6
$L['adm_pluginstall_msg03'] = 'Suche nach Setup-Datei...';	// New in N-0.0.6
$L['adm_pluginstall_msg04'] = 'Suche nach Komponenten...';	// New in N-0.0.6
$L['adm_pluginstall_msg05'] = 'Installiere Komponenten...';	// New in N-0.0.6
$L['adm_pluginstall_msg06'] = 'Suche nach Konfigurationseinträgen in der Setup-Datei...';	// New in N-0.0.6
$L['adm_pluginstall_msg07'] = 'Nicht gefunden! Installation fehlgeschlagen!';	// New in N-0.0.6
$L['adm_pluginstall_msg08'] = 'Lösche alle alten Rechte für dieses Plugin...';	// New in N-0.0.6
$L['adm_pluginstall_msg09'] = 'Füge Rechte den Benutzergruppen hinzu...';	// New in N-0.0.6
$L['adm_pluginstall_msg10'] = 'Setze die Auth-Spalte für alle Benutzer zurück...';	// New in N-0.0.6
$L['adm_pluginstall_msg11'] = 'Starte die On-Install-Komponente des Setup-Scripts...';	// New in N-0.0.6

/**
 * Tools Section
 */

$L['adm_listisempty'] = 'Liste ist leer';

/**
  * TrashCan Section
 */

$L['adm_help_trashcan'] = 'Hier sind die kürzlich von Benutzern und Moderatoren gelöschten Einträge aufgeführt.<br />
Wegputzen: löscht den Eintrag für immer<br />
Wiederherstellen: Verschiebt den Eintrag zurück an den Ursprung<br />
<b>Hinweis</b>:<br />
- beim Wiederherstellen eines Forenthemas werden ebenso alle dazugehörigen Beiträge wiederhergestellt<br />
- Beim Wiederherstellen eines Beitrags in einem gelöschten Thema wird das komplette Thema mit allen untergeordneten Beiträgen wiederhergestellt (falls verfügbar).<br />';
$L['adm_trashcan_deleted'] = "Eintrag gelöscht";
$L['adm_trashcan_prune'] = "Papierkorb geleert";
$L['adm_trashcan_restored'] = "Eintrag wiederhergestellt";

/**
 * Other Section
 * Comments Subsection
 */

$L['adm_comm_already_del'] = 'Kommentar gelöscht';		// New in N-0.0.2

/**
 * Other Section
 * PFS Subsection
 */

$L['adm_gd'] = 'GD-Grafikbibliothek';
$L['adm_allpfs'] = 'Alle persönlichen Dateiablagen';
$L['adm_allfiles'] = 'Alle Dateien';
$L['adm_thumbnails'] = 'Thumbnails';
$L['adm_orphandbentries'] = 'Verweiste Datenbankeinträge';
$L['adm_orphanfiles'] = 'Verweiste Dateien';
$L['adm_delallthumbs'] = 'Alle Thumbnails löschen';
$L['adm_rebuildallthumbs']= 'Alle Thumbnails löschen und neu erstellen';
$L['adm_help_allpfs'] = $L['PFS'].' aller registrierten Benutzer';
$L['adm_nogd'] = 'Die GD-Grafikbibliothek wird von diesem Host nicht unterstützt, daher kann cotonti keine Thumbnails erstellen. Gehe auf '.$L['Configuration'].' &gt; '.$L['PFS'].' und setze &quot;Thumbnailerstellung&quot; auf &quot;'.$L['Disabled'].'&quot;.';

/**
 * Other Section
 * Polls Subsection
 */

$L['adm_help_polls'] = 'Fülle das Formular aus und klicke auf &quot;Erstellen&quot;, um eine neue Umfrage zu beginnen. Leere Optionen werden ignoriert und entfernt. Es wird empfohlen, die Umfrage nach dem Erstellen nicht mehr zu bearbeiten, um die Ergebnisse nicht zu gefährden.';	// New in N-0.0.2
$L['adm_polls_forumpolls'] = 'Umfragen aus Foren (neuste zuerst):';	// New in N-0.0.1
$L['adm_polls_indexpolls'] = 'Startseiten-Umfragen (neuste zuerst):';	// New in N-0.0.1
$L['adm_polls_msg916_bump'] = 'Erfolgreich gebumped!';	// New in N-0.0.3
$L['adm_polls_msg916_deleted'] = 'Erfolgreich gelöscht!';	// New in N-0.0.3
$L['adm_polls_msg916_reset'] = 'Erfolgreich zurückgesetzt!';	// New in N-0.0.3
$L['adm_polls_on_page'] = 'Auf Seite';	// New in N-0.0.2
$L['adm_polls_polltopic'] = 'Umfragethema';	// New in N-0.0.1

/**
 * Other Section
 * PM Subsection
 */

$L['adm_pm_totaldb'] = 'Private Nachrichten in Datenbank';
$L['adm_pm_totalsent'] = 'Private Nachrichten insgesamt jemals gesendet';

/**
 * Other Section
 * Ratings Subsection
 */

$L['adm_ratings_already_del'] = 'Bewertung entfernt';	// New in N-0.0.3
$L['adm_ratings_totalitems'] = 'Seiten insgesamt bewertet';
$L['adm_ratings_totalvotes'] = 'Stimmen insgesamt';
$L['adm_help_ratings'] = 'Um eine Bewertung zurückzusetzen, lösche sie einfach. Sie wird mit der nächsten neuen Stimme wieder erstellt.';

/**
 * Other Section
 * Cache Subsection
 */

$L['adm_delcacheitem'] = 'Cache-Eintrag entfernt';	// New in N-0.0.2
$L['adm_internalcache'] = 'Interner Cache';
$L['adm_purgeall_done'] = 'Cache komplett geleert';	// New in N-0.0.2
$L['adm_diskcache'] = 'Festplatten-Cache';	// New in N-0.6.1

/**
 * Other Section
 * BBCode Subsection
 */

$L['adm_bbcode'] = 'BBCode';
$L['adm_bbcodes'] = 'BBCodes';
$L['adm_bbcodes_added'] = 'Neuer bbcode erfolgreich hinzugefügt.';
$L['adm_bbcodes_clearcache'] = 'HTML-Cache leeren';
$L['adm_bbcodes_clearcache_confirm'] = 'Dies wird den Cache für alle Seiten und Beiträge leeren. Weitermachen?';
$L['adm_bbcodes_clearcache_done'] = 'HTML-Cache wurde geleert.';
$L['adm_bbcodes_confirm'] = 'Diesen bbcode wirklich löschen?';
$L['adm_bbcodes_container'] = 'Container';
$L['adm_bbcodes_mode'] = 'Modus';
$L['adm_bbcodes_new'] = 'Neuer BBCode';
$L['adm_bbcodes_pattern'] = 'Muster';
$L['adm_bbcodes_postrender'] = 'Post-render'; 
$L['adm_bbcodes_priority'] = 'Priorität';
$L['adm_bbcodes_removed'] = 'bbcode erfolgreich entfernt.';
$L['adm_bbcodes_replacement'] = 'Ersetzung';
$L['adm_bbcodes_updated'] = 'bbcode erfolgreich aktualisiert.';
$L['adm_help_bbcodes'] = <<<HTM
<ul>
<li><strong>Name</strong> - BBcode-Nname (nur alphanumerische Zeichen und Unterstriche benutzen)</li>
<li><strong>Modus</strong> - einer der folgenden Parsing-Modi: 'str' (str_replace), 'ereg' (eregi_replace), 'pcre' (preg_replace) und 'callback' (preg_replace_callback)</li>
<li><strong>Muster</strong> - BBcode-Zeichenkette oder vollständiger regulärer Ausdruck</li>
<li><strong>Ersetzung</strong> - Ersetzungs-Zeichenkette, reguläre Ersetzung oder Callback-Body</li>
<li><strong>Container</strong> - Ist der Bbcode ein Container (z. B. [bbcode]irgendwas[/bbcode])</li>
<li><strong>Priorität</strong> - BBcode-Priorität von 0 bis 25. Niedrigere Prioritäten werden zuerst geparst, 128 ist Standard für mittlere Priorität.</li>
<li><strong>Plugin</strong> - Plugin/Komponentenname, zu welchem der BBCode gehört. Leer lassen, dies ist nur für Plugins notwendig.</li>
<li><strong>Post-render</strong> - Gibt an, ob dieser BBCode auf einen zuvor erstellten HTML-Cache angewandt werden muss. Benutze dies nur, falls dein Callback per-Request-Berechnungen benötigt.</li>
</ul>
HTM;

/**
 * Other Section
 * URLs Subsection
 */

$L['adm_urls'] = 'URLs';
$L['adm_urls_area'] = 'Bereich';
$L['adm_urls_error_dat'] = 'Fehler: datas/urltrans.dat ist nicht beschreibbar!';
$L['adm_urls_format'] = 'Format';
$L['adm_urls_htaccess'] = '.htaccess überschreiben?';
$L['adm_urls_new'] = 'Neue Regel';
$L['adm_urls_parameters'] = 'Parameter';
$L['adm_urls_rules'] = 'URL-Umwandlungsregeln';
$L['adm_urls_save'] = 'Speichern';
$L['adm_urls_your'] = 'Deine';
$L['adm_urls_callbacks'] = 'Regel beinhaltet callbacks';
$L['adm_urls_errors'] = 'Du musst die Rewrite-Optionen dafür manuell hinzufügen.';
$L['adm_help_urls'] = 'Auf dieser Seite kannst du deine URLs mit Hilfe einfacher Umwandlungsregeln anpassen. Bitte stelle sicher, dass die Regeln korrekt sind und keine doppelten Einträge existieren. Bitte benutze keine Leerzeichen, Tabstops und andere Sonderzeichen in den Regeln. Bereiche und Parameter sind wie folgt beschrieben.     
<ol>
<li><strong>Bereich</strong> Ist der Name des Scripts, zu welchem die Regel gehört. Das Symbol (*) bedeutet &quot;jedes Script&quot;</li>
<li><strong>Parameter</strong> ist eine auf die URL-Parameter angepasste BEdingung. Es ist eine Zeichenkette, die Name-Wert-Paare beinhaltet, getrennt durch ein &amp; und Gleichheitszeichen (=) zwischen Parameter-Name und dessen Wert. Ein Fragezeichen (?) am Anfang wird nicht benötigt. Falls du hier Variablen angibst, müssen diese in der URL vorhanden sein, um die Regel zu erfüllen. * bedeutet &quot;jeder Wert&quot;, ein einzelner Wert oder eine Liste mehrerer Möglichkeiten, getrennt durch einen senkrechten Strich (|). Alle Werte sollten URL-kodiert sein.<em>Beispiel: name=Val|Josh&amp;id=124&amp;page=*</em>.</li>
<li><strong>Format</strong> Gibt das Format der mit dieser Regel übereinstimmenden URL an. Es ist eine Zeichenkette, welche spezielle Sequenzen beinhaltet, die mit ihren Werten ersetzt werden. Eine normale Sequenz sieht z. B. so aus:{$name}, wobei &quot;name&quot; der Name des URL-Parameters ist (Get-Variable) und mit dessen Wert anstatt der Sequenz ersetzt wird. Es gibt spezielle URL-Parameter, die nicht aus Sequenzen stammen (&quot;Query-String&quot;):            
	<ul>
		<li><em>{$_area}</em> - Script-Name;</li>
		<li><em>{$_host}</em> - Hostname aus der Haupt-URL deiner Webseite;</li>
		<li><em>{$_rhost}</em> - Hostname aus dem aktuellen HTTP-Request;</li>
		<li><em>{$_path}</em> - Serverbezogener Pfad deiner Seite, / falls sich deine Seite im Server-Hauptverzeichnis befindet.</li>
	</ul>
Du kannst auch parameterisierte Subdomains nutzen, indem du absolute URL-Formate angibst: <em>http://{$c}.site.com/{$al}.html</em>. Wird momentan nur von Apache-Webservern unterstützt.</li>
<li><strong>Neue Regel</strong> Fügt der Tabelle eine neue Regel hinzu.</li>
<li><strong>Anordnung</strong> - bitte denke daran, dass die Anordnung der Regeln in der Tabelle wichtig ist.   Der URL-Umwandlungs-Algorythmus schaut wie folgt nach einer Regel: Zuerst werden alle für einen Bereich definierten Regeln eingelesen. Danach wird versucht, <em>die erste</em> Regel zu finden, welche der parameter-Bedingung entspricht. Wird keine Regel gefunden, erfolgt ein Rückfall auf den *-Bereich, um dort nach der Regel zu suchen. Es wird empfohlen, dass deine Standardregel (mit *        -Bereich und *-Parameter) die letzte der *-Regeln oder auch die letzte Regel in der Tabelle ist.<br />  
Du kannst die Anordnung ändern, indem du einfach die Zeilen mittels Drag-und-Drop an die gewünschte Position verschiebst. Du solltest neue Regeln zuerst speichern, bevor du sie einordnest.</li>  
<li><strong>Query-String</strong> Ist das, was man normalerweise nach dem Fragezeichen in einem Link sieht.    Damit werden eventuelle Parameter übergeben und automatisch angehangen, die nicht vom Format-String verarbeitet wurden.</li>
<li><strong>Speichern</strong> Dieser Schalter speichert die Regeln und übernimmt die Änderungen sofort. Weiterhin werden die Änderungen in der Datei .htaccess übernommen (falls beschreibbar) und es wird .htaccess/IsapiRewrite4.ini/nginx.conf angeboten (abhängig vom Server-Typ).</li>
</ol>';

/**
 * Other Section
 * Banlist Subsection
 */

$L['adm_ipmask'] = 'IP-Maske';
$L['adm_emailmask'] = 'E-Mail-Maske';
$L['adm_neverexpire'] = 'Verfällt niemals';
$L['adm_help_banlist'] = 'Beispiele für IP-Masken: 194.31.13.41, 194.31.13.*, 194.31.*.*, 194.*.*.*<br />Beispiele für E-Mail-Masken: @hotmail.com, @yahoo (Wildcards werden nicht unterstützt)<br /> Ein einzelner Eintrag kann eine IP-Maske, eine E-Mail-Maske oder beides beinhalten. <br />IP-Adressen werden nach allen Seiten und jede angezeigte Seite gefiltert, E-Mail-Masken nur für Benutzerregistrierungen.';  

$L['adm_searchthisuser'] = 'Suche nach dieser IP in der Benutzerdatenbank';
$L['adm_dnsrecord'] = 'DNS-Eintrag für diese Adresse';

$L['alreadyaddnewentry'] = 'Neuer Eintrag hinzugefügt';	//N-0.0.2
$L['alreadyupdatednewentry'] = 'Eintrag aktualisiert';	//N-0.0.2
$L['alreadydeletednewentry'] = 'Eintrag gelöscht';	//N-0.0.2

/**
 * Other Section
 * Hits Subsection
 */

$L['adm_byyear'] = 'Nach Jahr';
$L['adm_bymonth'] = 'Nach Monat';
$L['adm_byweek'] = 'Nach Woche';

$L['adm_ref_lowhits'] = 'Lösche Einträge mit Aufrufen weniger als 5';
$L['adm_maxhits'] = 'Das Maximum an Aufrufen wurde am %1$s erreicht, %2$s Seiten wurden an diesem Tag angezeigt.';

/**
 * Other Section
 * Referers Subsection
 */

$L['adm_ref_prune'] = 'Aufgeräumt';
$L['adm_ref_prunelowhits'] = 'Referer mit weniger als 5 Besuchern erfolgreich entfernt';

/**
 * Other Section
 * Log Subsection
 */

$L['adm_log'] = 'Systemlog';
$L['adm_infos'] = 'Informationen';
$L['adm_versiondclocks'] = 'Versionen und Uhren';
$L['adm_checkcoreskins'] = 'Kernkomponenten und Skins überprüfen';
$L['adm_checkcorenow'] = 'Kernkomponenten jetzt überprüfen!';
$L['adm_checkingcore'] = 'Prüfe Kernkomponenten...';
$L['adm_checkskins'] = 'Prüfen, ob alle Dateien im Skin vorhanden sind';
$L['adm_checkskin'] = 'TPL-Dateien für den Skin prüfen';
$L['adm_checkingskin'] = 'Skin wird geprüft...';
$L['adm_hits'] = 'Zugriffe';
$L['adm_check_ok'] = 'OK';
$L['adm_check_missing'] = 'Fehlt';

/**
 * Other Section
 * Infos Subsection
 */

$L['adm_phpver'] = 'PHP-Engine-Version';
$L['adm_zendver'] = 'Zend-Engine-Version';
$L['adm_interface'] = 'Interface zwischen Webserver und PHP';
$L['adm_os'] = 'Betriebssystem';
$L['adm_clocks'] = 'Uhren';
$L['adm_time1'] = '#1: unverarbeitete Serverzeit';
$L['adm_time2'] = '#2: vom Server zurückgegebene GMT-Zeit';
$L['adm_time3'] = '#3: GMT-Zeit + Zeitunterschied des Servers (Cotonti-Referenz)';
$L['adm_time4'] = '#4: Deine lokale Zeit, abgeleitet aus deinen Profileinstellungen';
$L['adm_help_versions'] = 'Konfiguriere die Server-Zeitzone, um die Uhr #3 korrekt einzustellen.<br />
Uhr #4 ist von den Zeiteinstellungen in deinem profil abhängig.<br />
Die Uhren #1 und #2 werden von Cotonti ignoriert.';

/**
 * Common Entries
 */

$L['adm_area'] = 'Bereich';
$L['adm_clicktoedit'] = '(Klicken zum Bearbeiten)';
$L['adm_confirm'] = 'Diesen Schalter zum Bestätigen aktivieren: ';
$L['adm_done'] = 'Erledigt';
$L['adm_failed'] = 'Fehlgeschlagen';
$L['adm_from'] = 'Von';
$L['adm_more'] = 'Weitere Tools...';
$L['adm_purgeall'] = 'Alles aufräumen';
$L['adm_queue_unvalidated'] = 'Unbestätigt';	// New in N-0.0.3
$L['adm_queue_validated'] = 'Bestätigt';	// New in N-0.0.3
$L['adm_required'] = '(Benötigt)';
$L['adm_setby'] = 'Gesetzt von';
$L['adm_to'] = 'An';
$L['adm_totalsize'] = 'Gesamte Größe';
$L['adm_warnings'] = 'Warnungen';

$L['editdeleteentries'] = 'Einträge bearbeiten oder löschen';
$L['viewdeleteentries'] = 'Einträge ansehen oder löschen';

/**
 * Extra Fields (Common Entries for Pages & Users)
 */

$L['adm_extrafields'] = 'Zusatzfelder';
$L['adm_extrafield_added'] = 'Neues Zusatzfeld erfolgreich hinzugefügt.';
$L['adm_extrafield_not_added'] = 'Fehler! Neues Zusatzfeld nicht hinzugefügt.';
$L['adm_extrafield_updated'] = 'Zusatzfeld erfolgreich aktualisiert.';
$L['adm_extrafield_not_updated'] = 'Fehler! Zusatzfeld nicht aktualisiert.';
$L['adm_extrafield_removed'] = 'Zusatzfeld erfolgreich entfernt.';
$L['adm_extrafield_not_removed'] = 'Fehler! Zusatzfeld nicht gelöscht.';
$L['adm_extrafield_confirmdel'] = 'Soll dieses Zusatzfeld wirklich gelöscht werden? Alle Daten in diesem Feld gehen verloren!';
$L['adm_extrafield_confirmupd'] = 'Soll dieses Zusatzfeld wirklich aktualisiert werden? Einige Daten könnten möglicherweise verloren gehen!';

$L['extf_Name'] = 'Name';
$L['extf_Type'] = 'Feldtyp';
$L['extf_Base_HTML'] = 'Standard-HTML';
$L['extf_Page_tags'] = 'Tags';
$L['extf_Description'] = 'Beschreibung (_TITLE)';

$L['adm_extrafield_new'] = 'Neues Zusatzfeld';
$L['adm_extrafield_noalter'] = 'Füge das neue Feld nicht der Datenbank hinzu, registriere es nur als extra';
$L['adm_extrafield_selectable_values'] = 'Select-Optionen (durch Komma getrennt:';
$L['adm_help_extrafield'] = 'Tipp: Feld &quot;Standard-HTML&quot; wird automatisch als Standard gewählt, wenn du es leer lässt und auf aktualisieren klickst.'; 

/**
 * Help messages that still don't work
 */

$L['adm_help_cache'] = 'Not available';
$L['adm_help_check1'] = 'Not available';
$L['adm_help_check2'] = 'Not available';
$L['adm_help_config']= 'Not available';
$L['adm_help_forums'] = 'Not available';
$L['adm_help_forums_structure'] = 'Not available';
$L['adm_help_pfsfiles'] = 'Not available';
$L['adm_help_pfsthumbs'] = 'Not available';

?>