<?php
/* ====================
[BEGIN_COT_EXT]
Hooks=ajax
[END_COT_EXT]
==================== */

/**
 * Datatable ajax
 *
 * @package Datatables
 * @copyright (c) Joanna Torz for Cotonti Team
 * @license https://github.com/Cotonti/Cotonti/blob/master/License.txt
 */

defined('COT_CODE') or die('Wrong URL');

	list($auth_read, $auth_write, $auth_admin) = cot_auth('plug', 'datatable');	
	cot_block($auth_read);

	$columns = array();
	
	// DB table to use
	$table = $db_datatable;

	// Table's primary key - to be filled later
	$primaryKey = '';
	
	// column blacklist
	$blacklist = explode(',', $cfg['plugin']['datatable']['blacklist']);
	
	// fetch columns
	$res = $db->query("SHOW COLUMNS FROM $db_datatable");
	while ($row = $res->fetch())
	{
		if ($row['Key'] == 'PRI' && $row['Extra'] == 'auto_increment') {
			
			$primaryKey = $row['Field'];
			$columns[] = array(
								'db' => $primaryKey,
								'dt' => 'DT_RowId',
								'formatter' => function( $d, $row ) {
									return 'row_'.$d;
								}
							);	
			
		}
		if (!in_array($row['Field'],$blacklist)) {				
				$columns[] = array('db' => $row['Field'], 'dt' => $row['Field']);	
		}	
	}

require_once( 'inc/cotonti_ssp.class.php' );

/*
// POST not working
if (isset($_POST)) {
	echo json_encode(
		COTSSP::simple($_POST, $db, $table, $primaryKey, $columns )
	);
} else {
*/	
	echo json_encode(
		COTSSP::simple($_GET, $db, $table, $primaryKey, $columns )
	);	
//}
