<?php
/* ====================
[BEGIN_COT_EXT]
Hooks=comments.loop
Tags=comments.tpl:{COMMENTS_ROW_REACTIONS_BUTTONS},{COMMENTS_ROW_REACTIONS_COUNTS}
[END_COT_EXT]
==================== */

/**
 * Reactions comments loop
 *
 * @package reactions
 * @version 1.0.1
 */

defined('COT_CODE') or die('Wrong URL');

if (!Cot::$cfg['plugin']['reactions']['comments_on']) {
    return;
}

// Ensure we have a valid comment row
global $row, $t;
if (empty($row) || !is_array($row) || !isset($row['com_id'], $row['com_authorid'])) {
    $t->assign([
        'COMMENTS_ROW_REACTIONS_BUTTONS' => '',
        'COMMENTS_ROW_REACTIONS_COUNTS'  => ''
    ]);
    return;
}

require_once cot_incfile('reactions', 'plug');

$ext      = 'comments';
$item     = (int)$row['com_id'];
$owner_id = (int)$row['com_authorid'];

$t->assign([
    'COMMENTS_ROW_REACTIONS_BUTTONS' => reaction_buttons(
        $ext,
        $item,
        $owner_id,
        Cot::$cfg['plugin']['reactions']['comments_class']
    ),
    'COMMENTS_ROW_REACTIONS_COUNTS'  => reaction_counts_display(
        $ext,
        $item
    )
]);
