/**
 * Reactions plugin JavaScript
 */
$(function() {
    // Initialize tooltips if available
    if (typeof $().tooltip === 'function') {
        $('[data-toggle="tooltip"]').tooltip();
    }

    // Click handler for reaction buttons
    $(document).on('click', '.reaction-btn', function() {
        var $btn = $(this);
        var type = $btn.data('reaction');
        var ext = $btn.data('ext');
        var item = $btn.data('item');
        
        // Get the action based on whether the button is already active
        var action = $btn.hasClass('active') ? 'remove' : 'add';
        
        // Disable all reaction buttons while processing
        var $buttons = $btn.closest('.reactions-container').find('.reaction-btn');
        $buttons.prop('disabled', true);
        
        // Make AJAX request
        $.ajax({
            url: 'index.php?r=reactions',
            type: 'GET',
            dataType: 'json',
            data: {
                action: action,
                type: type,
                ext: ext,
                item: item
            },
            success: function(response) {
                if (response.success) {
                    // Update buttons
                    $buttons.removeClass('active');
                    if (action === 'add') {
                        $btn.addClass('active');
                    }
                    
                    // Update counts
                    updateReactionCounts(ext, item, response.counts);
                } else {
                    alert(response.message);
                }
            },
            error: function() {
                alert('Failed to process your reaction. Please try again later.');
            },
            complete: function() {
                // Re-enable buttons
                $buttons.prop('disabled', false);
            }
        });
    });
    
    /**
     * Update reaction counts display
     */
    function updateReactionCounts(ext, item, counts) {
        var $counts = $('.reactions-counts[data-ext="' + ext + '"][data-item="' + item + '"]');
        
        if ($counts.length === 0) {
            // If counts container doesn't exist yet, we could add it dynamically
            // But for simplicity, we'll just reload the page
            return;
        }
        
        // Update each reaction count
        $.each(counts, function(type, count) {
            if (type !== 'total') {
                var $count = $('[data-reaction="' + type + '"][data-ext="' + ext + '"][data-item="' + item + '"]');
                if ($count.length > 0) {
                    if (count > 0) {
                        $count.text(count).parent().show();
                    } else {
                        $count.parent().hide();
                    }
                }
            }
        });
        
        // If there are no reactions, hide the counts container
        if (counts.total === 0) {
            $counts.hide();
        } else {
            $counts.show();
        }
        
        // Re-initialize tooltips if needed
        if (typeof $().tooltip === 'function') {
            $('[data-toggle="tooltip"]').tooltip('dispose').tooltip();
        }
    }
});